<?php
/**
 * DBData  ٷ  
 * 
 * @package php.db
 */

//import("php.db.Data");


/**
 * DB  Data ٷ  ŬԴϴ.
 * 
 * <code>
 * $db = DB_('mssql', 'db', true);
 *
 * $data = new DBData($db, 'members');
 * $data->userid('cyberuls');   //  userid = 'cyberuls'   ˴ϴ. 
 *
 *
 * //  select 
 * $data->select(" datetime is not null order by 1", false, array('ab','bc','cde'));
 *
 * //  selectPage 
 * $page = 1;
 * $limitPage = 10;
 * $data->selectPage(" datetime is not null order by 1", $page, $limitPage, array('ab','bc','cde'));
 * 
 * // count  
 * $limitPage = 10;
 * $limitBlock = 10;
 * $arr = $data->selectCount(" datetime is not null ", $limitPage, $limitBlock);
 * 
 * //$arr['count'] : ü , $arr['page'] :  , $arr['block'] : 
 *
 * 
 * $db->close();
 * </code> 
 * 
 * @package php.db
 */
class DBData extends Data {

	/**
	 * ̺ ̸ 
	 * @var string 
	 */
	protected $table;

	/**
	 * Ÿ Ÿ Ʈ 
	 *
	 * @var array 
	 */
	protected $types = array();


	/** 
	 * 
	 *
	 * @param IConnector $connector  
	 * @param string $table ̺ ̸ 
	 * @param string $where  
	 * @param string $field fieldƮ
	 */
	public function __construct($connector = null, $table = null, $where = null) {
		parent::__construct($connector);

		$this->setTable($table);

		if ($where) { 
			$this->select($where);
		}

	}

	/**
	 * ̺ ̸  
	 * 
	 * @param string $table ̸̺ 
	 */
	public function setTable($table) {
		$this->table = $table;
	}

	/**
	 * ̺ ̸ ɴϴ.
	 * 
	 * @return string 
	 */
	public function getTable() {
		return $this->table;
	}

	/**
	 * Ÿ Ʈ  
	 * 
	 * @return array Ÿ Ʈ 迭 ɴϴ.
	 */
	public function getTypeList() { 
		return $this->types;
	}
	
	/**
	 * Ÿ Ʈ մϴ.
	 * 
	 * <code> $dbdata->setTypeList(array('field1' => 'varchar', ....)); </code>
	 * 
	 * @param array $arr Ÿ Ʈ 
	 */
	public function setTypeList($arr) { 
		$this->types = array_change_key_case($arr, CASE_LOWER);
	}

	/** 
	 * ʵ  ˻Ѵ. 
	 * 
	 * <code> 
	 * // num ʵ  9  ڵ  ʵ 
	 * echo $data->num(9, 'int', '*'); 
	 *
	 * //str ʵ  Y,N  ڵ A,B,C ʵ 
	 * echo $data->str(array('Y','N'), 'string', 'A,B,C'); 
	 * </code>
	 * 
	 * @method DBData any_field() any_field(string|array $values, string $type, string $column) 
	 * @param string|array $values ʵ尪 Ʈ 
	 * @param string $type Ÿ  
	 * @param string $column Ÿ ÷ Ʈ 
	 * @return DBData 
	 */
	public function __call($field, $args) { 
		$values = $args[0];
		$type	= ($args[1]) ? $args[1] : 'string';
		$column = ($args[2]) ? $args[2] : ' * ';

		// ˻ϴ  迭  
		if (is_array($values)) { 

			foreach ($values as $key => $v) { 
				$values[$key] = $this->getConnector()->escape($v);
			}

			if ($args[1] == 'string') { 
				$values = "'".implode("','", $values)."'";
			} else { 
				$values = implode(",", $values);
			}
		} else { 

			$values = $this->getConnector()->escape($values);

			if ($args[1] == 'string') { 
				$values = "'{$values}'";
			} 
		}

		// ˻ڿ ϼ 
		$temp = $values;

		// sql ϼ 
		$sql = "select {$column} from {$this->table} where {$field} in ( {$temp} )";

//		echo $sql;

		$this->setData($this->getConnector()->getData($sql));

		return $this;
	}

	/**
	 * ˻ 
	 *
	 * <code> echo $data->select(" a = '1' ", false, array('a', 'b', 'c'));  </code>
	 *
	 * @param string $where   
	 * @param bool $hasNext ĭ   
	 * @param array $field_list  ʵ Ʈ
	 * @return DBData  
	 */
	public function select($where = '', $hasNext = false, $field_list = array())
	{
		$connector = $this->getConnector();

		$sql = new Sql($connector->program, "select");
		$sql->setFrom($this->table);

		foreach ($field_list as $field) { 
			$sql->add($field);
		}

		$str = $sql->toString(). " ". (trim($where) == '' ? '' : ' where '. $where );

//		echo $str;

		$data = $connector->getData($str);

		$this->setData($data);

		if ($hasNext) $this->next();

		return $this;
	}

	/**
	 * ü Ÿ ҷ 
	 *
	 * @return DBData
	 */
	public function loadAll() { 
		return $this->select(" 1 = 1");
	}

	/** 
	 * ¡ ˻  
	 *
	 * <code> echo $data->selectPage(" a = '1' ", 1, 10, array('a', 'b', 'c'));  </code>
	 *
	 * @param string $where 
	 * @param int $page ˻  
	 * @param int $pagesize  ڵ  
	 * @param array $field_list ʵ Ʈ 
	 * @return DBData $this 
	 */
	public function selectPage($where = '', $page = 1 , $pagesize = 10, $field_list = array())
	{
		$connector = $this->getConnector();

		$sql = new Sql($connector->program, "select");
		$sql->setFrom($this->table);

		foreach ($field_list as $field) { 
			$sql->add($field);
		}

		$str = $sql->toString(). " ". (trim($where) == '' ? '' : ' where '. $where );

//		echo $str;

		$data = $connector->getPageData($str, $page, $pagesize);

		$this->setData($data);

		return $this;
	}

	/**
	 * ˻   
	 *
	 * @param string $where ǹ 
	 * @param int $pagesize   Ÿ ڵ 
	 * @param int $blocksize   Ÿ   
	 * @return array    count : ü, page :  , block : 
	 * @see DBClient::getPageCountQuery()
	 */ 
	public function selectCount($where = '', $pagesize = 10, $blocksize = 10)
	{
		$connector = $this->getConnector();

		$sql = new Sql($connector->program, "select");
		$sql->setFrom($this->table);
		$sql->add('count(*) as cnt', '', false);

		$str = $sql->toString(). " ". (trim($where) == '' ? '' : ' where '. $where );

		return $connector->getPageCountQuery($str, $pagesize, $blocksize);
	}



	/**
	 *  ε ִ Ÿ delete  
	 * 
	 * @return bool    
	 */
	public function delete() {
		$connector = $this->getConnector();

		$tempSql = $connector->deleteSql($this);

		return $connector->query($tempSql->toString());
	}

	/**
	 *  ε ִ Ÿ update  
	 * 
	 * @param array $omit  ʵ Ʈ
	 * @param bool $is_update_field	false  ʵ, true  ʵ  	 
	 * @return bool    
	 */
	public function update($omit = array(), $is_update_field = false) {
		$connector = $this->getConnector();

		$tempSql = $connector->updateSql($this, $omit, $is_update_field);

		return $connector->query($tempSql->toString());
	}

	/**
	 *  ε ִ Ÿ insert  
	 *
	 * @param array $omit  ʵ Ʈ 
	 * @return bool    
	 */
	public function insert($omit = array()) {
		$connector = $this->getConnector();

		$tempSql = $connector->insertSql($this, $omit);

		return $connector->query($tempSql->toString()) or die("insert : ".$connector->error());
	}

	/**
	 *  Ÿ  insert  
	 *
	 * @param array $omit  ʵ Ʈ 	 
	 */
	public function insertAll($omit = array()) {
		$this->saveIndex();

		while($this->next()) 
			$this->insert($omit);

		$this->returnIndex();
	}

	/**
	 *  Ÿ  delete  
	 * 
	 */
	public function deleteAll() {
		$this->saveIndex();

		while($this->next()) 
			$this->delete();

		$this->returnIndex();
	}

	/**
	 *  Ÿ  update  
	 * 
	 * @param array $omit  ʵ Ʈ 
	 */
	public function updateAll($omit = array()) {
		$this->saveIndex();

		while($this->next()) 
			$this->update($omit);

		$this->returnIndex();
	}

	/**
	 * ܺ Ÿ   
	 * 
	 * @param string $table ڽ ̺ ̸ 
	 * @param string $field1 ڽ ʵ 
	 * @param string $field2 θ ʵ 
	 * @param string $field_list  ʵ Ʈ 
	 * @return DBData ڽ ̺ DBDataü
	 */
	public function getSubData($table, $field1, $field2, $field_list = '') { 
		$value = $this->get($field2);
		$field_list = (trim($field_list) == '') ? " * " : $field_list;
		$sql = "select {$field_list} from {$table} where $field = '{$value}'";

		return $this->getConnector()->getData($sql, $isOne);
	}
}
?>