<?php
/**
 * import() Լ õ Դϴ.
 *
 * @package default 
 */

session_start();

/**
 * ̺귯 Դϴ. 
 * ̺귯 ִ  ؼ ڵ ˴ϴ.
 *
 */
define("LIB", dirname(__FILE__).DIRECTORY_SEPARATOR);    // ̺귯  , ʼ  

$GLOBALS['INCLUDE_PATH_TABLE'] = array();
$GLOBALS['CLASS_TABLE'] = array();

/**
 * ڵ ̺귯 Ŭ 
 * 
 * $GLOBALS['CLASS_TABLE']  ϵ Ŭ ҷ ڵ Ŭ ȴ .
 * 
 * @see import()
 */
function __autoload($class) {

	// Ʈ  ȵǾ  Ŭ Ʈ ڵ ε 
	if (!$GLOBALS['CLASS_TABLE']) { 
		$GLOBALS['CLASS_TABLE'] = parse_ini_file(LIB.'class.ini');
	}

	$class = strtolower($class);

	// Ŭ  ϸ 
	if (array_key_exists($class, $GLOBALS['CLASS_TABLE']) ) { 
		import($GLOBALS['CLASS_TABLE'][$class]);
	}
}

/**
 * ̺귯 Ŭ 
 *
 *  php.lang.*  ó Ű ȿ ִ  Ŭ include ϴ  ù° ̰ 
 *  php.lang.String ó  Ŭ θ ϴ  ι° ̴. 
 *
 * <code>
 * import("php.lang.String");
 * import("php.lang.String,php.util.ArrayUtil");
 * import("php.lang.*,php.db.*");
 * </code>
 * 
 */
function import($path) {

	$path = explode(",", $path);

	// Ŭ 迭   ..
	if (sizeof($path) > 1) { 
		foreach ($path as $temp_path) { 
			import($temp_path);		
		}
		return;
	}

	if (empty($path))
		return false;

	$path = array_pop($path);

	$arr = explode(".", trim($path));
	$class = $arr[sizeof($arr)-1];  // Ŭ ̸ 

	if ($class == "*") {            // Ŭ ̸ * () ̸ 

	    // ش 丮 ؼ   php   includeѴ. 
		$dir = str_replace(".", DIRECTORY_SEPARATOR, $path);  
		$dir = str_replace(DIRECTORY_SEPARATOR."*", "", $dir);

		$temp_dir = LIB.$dir;

		// 丮   
		if (is_dir($temp_dir)) {

			// 丮 open 
			if ($d = opendir($temp_dir)) {

				// Ʈ  
				while (($file = readdir($d)) !== false) {

					$include_path = $temp_dir.DIRECTORY_SEPARATOR.$file;

					// ̹ include    
					if (in_array($include_path, $GLOBALS['INCLUDE_PATH_TABLE'])) { 
						continue;
					}

					// ., .., Ȯڰ php ƴ    
					if ($file == "." || $file == ".." || strpos($file, ".php") === FALSE) {
					    continue;
					} else {
					    include_once $include_path;
					}
				}

			   // 丮 ݱ 
 			   closedir($d);
			}
		 }
	}  else {	//   

		$path = str_replace(".", DIRECTORY_SEPARATOR, $path);

		$include_path = LIB.$path.".php";

		if (! in_array($include_path, $GLOBALS['INCLUDE_PATH_TABLE'])) { 

			//  Ŭ 
			include_once $include_path;

			// include Ʈ 
			$GLOBALS['INCLUDE_PATH_TABLE'][] = $include_path;
		}
	}
}

/**
 * Լ import ϱ  ԼԴϴ. 
 * php.function. Ű  մϴ. 
 * 
 * @param string $package Լ  Ű 
 */
function func($package) { 
	$list = array_map('trim', explode(",", $package));

	foreach ($list as $func) { 
		import("php.function.".str_replace('.', '_', strtolower($func)));
	}
}

// ⺻Լ ε 
func("php.lang,php.db,php.util");

// winbinder Լ ε 
func("php.ui.winbinder");
?>