<?php
/**
 * Pager Ŭ 
 *
 * @package php.util
 */
import("php.lang.PObject");

/**
 * Ʈ paging  ִ ŬԴϴ.
 * 
 * <code>
 * $url = "test.php?page=%page%";
 * $page = 1;
 * $limitPage = 10;
 * $limitBlock = 10;
 * $totalCount = 100;
 * 
 * $pager = new Pager($url, $page, $limitPage, $limitBlock, $totalCount);
 * echo $pager;
 *
 * echo $pager->getStartNum();    // Ʈ  ȣ  
 * </code>
 *
 * 
 * @package php.util
 */
class Pager extends PObject {
	private $page;
	private $block;
	private $limitPage;
	private $limitBlock;
	Private $totalCount;
	private $totalPage ;
	private $totalBlock;
	private $startPage;
	private $endPage;
	private $location; 
	private $title = array();

	/**
	 *  
	 * 
	 * @param string $url ¡ url 
	 * @param int $page   
	 * @param int $limitPage   Ÿ Ʈ  
	 * @param int $limitBlock   Ÿ   
	 * @param int $totalCount ü Ʈ  
	 */
	public function __construct($url, $page, $limitPage, $limitBlock, $totalCount) {
		$this->location		= $url ;
		$this->page			= $page;
		$this->limitPage	= $limitPage;
		$this->limitBlock	= $limitBlock;
		$this->totalCount	= $totalCount;

		//   ϱ 
		$this->totalPage	= ceil($this->totalCount / $this->limitPage);
		$this->block		= ceil($this->page/$this->limitBlock);
		$this->totalBlock	= ceil($this->totalPage / $this->limitBlock);

		//     
		$this->startPage	= ($this->block - 1) * $this->limitBlock + 1;
		$this->endPage		= $this->startPage + $this->limitBlock - 1;

		if ($this->endPage > $this->totalPage) {
			$this->endPage = $this->totalPage ;
		}

		$this->setTitle(array('[ó]','[]','[]','[]'));
	}

	/**
     * ó,,,   ؽƮ 
	 * 
	 * @param array $arr  
	 */
	public function setTitle($arr) {
		$this->title = $arr;
	}

	/**
	 *    
	 * 
	 * @return int   
	 */
	public function getPage()
	{
		return $this->page;
	}

	/**
	 *  ȣ 
	 * 
	 * @param int $i   
	 * @return string  url 
	 */
	public function replaceStr($i) {
		return str_replace("%page%", $i, $this->location);
	}

	/**
	 * ü    
	 *
	 * @return int ü   
	 */
	public function getTotalPage() {
		return $this->totalPage;
	}

	/**
	 * ó  ǥ 
	 *
	 * @return string 
	 */
	public function getFirstPage() {
		return ($this->page > 1) ? "1" : "";
	}

	/** 
	 *  
	 * 
	 * @return string|int   , ̸   
	 */
	public function getPrevBlock() {
		return ($this->block > 1) ? ($this->startPage - $this->limitBlock) : "";
	}

	/** 
	 *  
	 *
	 * @return int  ߵ   
	 */
	public function getStartPage() {
		return $this->startPage;
	}

	/** 
	 *  
	 *
	 * @return int     
	 */
	public function getEndPage() {
		return $this->endPage;
	}

	/** 
	 *   ȣ 
	 *
	 * @return int  ȣ
	 */
	public function getStartNum() {
		return $this->totalCount - ($this->limitPage * ($this->page - 1));
	}

	/**
	 *  
	 *
	 * @return int|string    ȣ, ̸  
	 */
	public function getNextBlock() {
		return ($this->block < $this->totalBlock) ? ($this->endPage+1) : "";
	}

	/**
	 *   
	 *
	 * @return int|string   ȣ, ̸  
	 */
	public function getLastPage() {
		return ($this->page < $this->totalPage) ? ($this->totalPage) : "";
	}

	/** 
	 * ¡ ȯ  
	 *
	 * @return string ȯ ¡  
	 */
	public function toString() {
		$str = "";

		if ($this->getFirstPage() != "") {
			$str .= "<a href='".$this->replaceStr($this->getFirstPage())."'>".$this->title[0]."</a>";
		} else {
			$str .= $this->title[0];
		}

		$str .= "&nbsp;";

		if ($this->getPrevBlock() != "") {
			$str .= "<a href='".$this->replaceStr($this->getPrevBlock())."'>".$this->title[1]."</a>";
		} else {
			$str .= $this->title[1];
		}

		$str .= "&nbsp;";
		
		if ($this->getTotalPage() <= 1) {
			$str .= " <strong>1</strong> ";
		} else {

			for ($i = $this->startPage; $i <= $this->endPage; $i++) {
				if ($i == $this->page) {
					$str .= "<strong>".$i."</strong>&nbsp;";
				} else {
					$str .= "<a href='".$this->replaceStr($i)."'>".$i."</a>&nbsp;";
				}
			}
		}

		$str .= "&nbsp;";		

		if ($this->getNextBlock() != "") {
			$str .= "<a href='".$this->replaceStr($this->getNextBlock())."'>".$this->title[2]."</a>";
		} else {
			$str .= $this->title[2];
		}

		$str .= "&nbsp;";

		if ($this->getLastPage() != "") {
			$str .= "<a href='".$this->replaceStr($this->getLastPage())."'>".$this->title[3]."</a>";
		} else {
			$str .= $this->title[3];
		}

		return $str;
	}
}

?>