<?
/**
 * NetdriveClient Ŭ
 *
 * @package php.net.netdrive
 */
import("php.lang.PObject");
import("php.net.netdrive.NetdriveConfig");
import("php.net.netdrive.NetdriveData");
import("php.net.IConnector");
import("php.util.ArrayUtil");

/**
 * NetdriveClient Ŭ
 *
 * @package php.net.netdrive
 */
class NetdriveClient extends PObject implements IConnector {

	private $_attribute = array();

	private $con;
	private $result;

	public function __construct($host = '', $sub = '', $os = 'WINDOWS', $delimiter = "\\") {
		$this->host			= $host;
		$this->sub			= $sub;
		$this->os			= $os;
		$this->delimiter	= $delimiter;

		$this->setAttribute('program',		"NETDRIVE");
		$this->setAttribute('host',			$host);
		$this->setAttribute('sub',			$sub);
		$this->setAttribute('os',			$os);
		$this->setAttribute('delimiter',	$delimiter);
		$this->setAttribute('start_url',	$start_url);
	}

	public function set($name) {
		$name = strtoupper($name)."_".$this->getAttribute("program");

		$this->setAttribute('host',			constant("{$name}_HOST"));
		$this->setAttribute('sub',			constant("{$name}_SUB"));
		$this->setAttribute('os',			constant("{$name}_OS"));
		$this->setAttribute('delimiter',	constant("{$name}_DELIMITER"));
		$this->setAttribute('start_url',	constant("{$name}_START_URL"));
	}

	public function getSub() { 
		return $this->getAttribute('sub');
	}

	public function getStartUrl() { 
		return $this->getAttribute('start_url');
	}

	public function setAttribute($key, $value) { 
		$this->_attribute[strtoupper($key)] = $value;
	}

	public function getAttribute($key) { 
		return $this->_attribute[strtoupper($key)];
	}

	public function connect() { 

	}

	public function login() { 

	}


	public function createData($result) { 
		$data = new NetdriveData($this);

		foreach ($result as $a)  {
			$data->add($a);
		}

		return $data;
	}

	public function getData($path) { 
		$arr = $this->getFileList($path);

		return $this->createData($arr);
	}

	private function getTotalPath($path = '') { 
		if ($this->getAttribute('os') == 'WINDOWS') { 
			$path = str_replace("/", "\\", $path);
		}
		
		$str = $this->getAttribute('sub').$path ;

		return $str;
	}

	public function getFileList($path = '') { 

		$total = $this->getTotalPath($path);

		if(strpos(PHP_OS, 'WIN') == 0) { 
			$command = "dir";
			$isWindows = true;
		} else {
			$command = "ls -l ";
			$isWindows = false;
		}

		$total_command = "$command $total";
		$result = shell_exec($total_command);

		$temp = explode("\n", $result);

		if ($isWindows) { 
			$temp = array_slice($temp, 7, count($temp)-10);
		} else { 
			$temp = array_slice($temp, 1, count($temp)-2);
		}

//		print_p($temp);

		$arr = array();

		foreach ($temp as $t) { 
			$method = "getDescriptionFile".ucwords($this->getAttribute('os'));
			$arr[] = call_user_method($method, $this, $t);
		}
		
		return $arr;
	}

	public function close() { 

	}

	public function getDescriptionFileLinux($str) { 
		$arr = explode(" ", $str);
		$temp = array();

		foreach ($arr as $value) {
			if (trim($value) && $value != '->') { 
				$temp[] = $value;
			}
		}

		$isDir = (substr($temp[0], 0, 1) == 'd') ? 'D' : '';

		$temp2 = array(
			'dir'		=> $isDir,
			'auth'		=> substr($temp[0], 1),
			'num'		=> $temp[1],
			'user'		=> $temp[2],
			'group'		=> $temp[3],
			'capacity'	=> $temp[4],
			'date'		=> "{$temp[5]} {$temp[6]}",
			'filename'	=> $temp[7],
			'link'		=> $temp[8],
			'ext'		=> ($isDir) ? '' : array_pop(explode(".", $temp[7]))
		);

		return $temp2;
	}

	public function getDescriptionFileWindows($str) { 
		$arr = explode(" ", $str);
		$temp = ArrayUtil::filter($arr);

		/*
		 * 0 : --  2009-06-26
		 * 1 : ,   
		 * 2 : ð:PM  03:24PM
		 * 3 : <DIR> Ǵ 뷮
		 * 4 : ̸ 
		 */

		// ð  
		$str = "{$temp[0]} {$temp[1]}";
		$temp_date = sscanf("{$temp[0]} {$temp[1]} {$temp[2]}", "%4d-%2d-%2d %s %2d:%2d");

		if ($temp_date[5] == '' && ($temp_date[4] >= 1 && $temp_date[4] <= 11)) { 
			$temp_date[4] += 12;
		}

		$str = sprintf("%04d-%02d-%02d %02d:%02d:00", $temp_date[0], $temp_date[1], $temp_date[2], $temp_date[4], $temp_date[5]);

		// 丮  Ȯ 
		$isDir = ($temp[3] == '<DIR>') ? 'D' : '';

		$temp2 = array(
			'dir'		=> $isDir,
			'auth'		=> '',
			'num'		=> '',
			'user'		=> '',
			'group'		=> '',
			'capacity'	=> (!$isDir) ? str_replace(",", "", $temp[3]) : '',
			'date'		=> date('Y-m-d H:i', strtotime($str)),
			'filename'	=> $temp[4],
			'link'		=> '',
			'ext'		=> ($isDir) ? '' : array_pop(explode(".", $temp[4]))
		);

		return $temp2;
	}
}

?>