<?php
/**
 * Request  Լ  
 * 
 * @package php.lang
 */


import("php.lang.PObject");

// 
session_start();


/**
 *    
 *
 * @return array 
 */
function GV_($type) { 

	if (is_array($type) ) return $type;

	$type = strtoupper($type);
	switch($type) { 
	case 'POST' :		return $_POST;
	case 'GET' :		return $_GET;
	case 'REQUEST' :	return $_REQUEST;
	case 'SERVER' :		return $_SERVER;
	case 'SESSION' :	return $_SESSION;
	case 'COOKIE' :		return $_COOKIE;
	case 'ENV' :		return $_ENV;
	default	:			return $type;
	}
}

/**
 * $_GET   ޱ 
 * ʵ忡  ٸ ⺻ $_GET   Ǿ. 
 *
 * @param string $field	get   
 * @param mixed $value	$field  ٸ ⺻ '' Ѵ.
 * 
 */
function G_($field, $value = '') {
	if (empty($_GET[$field])) {
		$_GET[$field] = $value;
	}

	return $_GET[$field];
}

/**
 * $_POST   ޱ 
 * ʵ忡  ٸ ⺻ $_POST   Ǿ. 
 *
 * @param string $field	post   
 * @param mixed $value	$field  ٸ ⺻ '' Ѵ.
 * 
 */
function P_($field, $value = '') {
	if (empty($_POST[$field])) {
		$_POST[$field] = $value;
	}
	return $_POST[$field];
}

/**
 * $_REQUEST   ޱ 
 * ʵ忡  ٸ ⺻ $_REQUEST   Ǿ. 
 *
 * @param string $field	get   
 * @param mixed $value	$field  ٸ ⺻ '' Ѵ.
 * 
 */
function R_($field, $value = '') {
	if (empty($_REQUEST[$field])) {
		$_REQUEST[$field] = $value;
	}
	return $_REQUEST[$field];
}

/**
 * $_SESSION   ޱ 
 * ʵ忡  ٸ ⺻ $_SESSION   Ǿ. 
 *
 * @param string $field	$_SESSION Ű̸ 
 * @param mixed $value	$field  ٸ ⺻ '' Ѵ.
 * 
 */
function S_($field, $value = '') {
	if (empty($_SESSION[$field])) {
		$_SESSION[$field] = $value;
	}
	return $_SESSION[$field];
}

/**
 * $_COOKIE   ޱ 
 * ʵ忡  ٸ ⺻ $_COOKIE   Ǿ. 
 *

 * @param string $field	$_COOKIE   
 * @param mixed $value	$field  ٸ ⺻ '' Ѵ.
 * 
 */
function C_($field, $value = '') {
	if (empty($_COOKIE[$field])) {
		$_COOKIE[$field] = $value;
	}
	return $_COOKIE[$field];
}

/**
 * $_SERVER   ޱ 
 *

 * @param string $field	 , ҹ   
 * 
 */
function E_($field) {
	$field = strtoupper($field);

	return $_SERVER[$field];
}

/**
 * 迭 <input type="hidden" > ڿ ȯ
 *

 * @param array $arr		迭
 * @param string $prefix	key  տ  ̸
 * @return string 
 *
 */
function H_($arr, $prefix = '') {
	if (gettype($arr) != "array") {
		return "迭 ƴմϴ.";
	}

	$str = "";
	foreach ($arr as $key => $value) {
		$str .= "<input type='hidden' name='".$prefix.$key."' value='".$value."' />\n";
	}

	return $str;
}

/**
 * GET, POST  ؼ hidden ü 
 *

 * @param string $type		get, post, request, session, server  
 * @param string $prefix	key  տ  ̸
 * @return void
 */
function HIDDEN_PRINT($type) {
	echo H_(GV_($type));
}

/**
 * GET, POST  ؼ table 
 *

 * @param string $type		get, post, request, session, server  
 * @return void
 */
function VIEW_($type) {

	$arr = GV_($type);

	if (gettype($arr) != "array") {
		return "迭 ƴմϴ.";
	}
	
	echo "<table border='1'>";
	echo  "<tr><th>Key</th><th>Value</th></tr>";
	
	foreach ($arr as $key => $value) {

			if (is_array($value)) { 
				echo  "<tr><td>";
				echo $key;
				echo "</td><td>";
				VIEW_($value);
				echo "</td></tr>";					
			} else { 

				$value = htmlspecialchars($value);
				$value = nl2br($value);
				echo  "<tr><td>";
				echo $key;
				echo "</td><td>";
				echo $value;
				echo "</td></tr>";	
			}
	}

	echo "</table>";
}

/**
 * ⺻  
 *

 * @param mixed $value	
 * @param mixed $default	⺻ ''
 * @return mixed	$value $default  
 *
 */
function D_($value, $default = '') {

	if (empty($value)) {
		$value = $default;
	}

	return $value;
}

/**
 * ⺻  
 * 
 * <code>echo IF_($a, '1', '2');   // $a 1̸ $a , ƴϸ 2 </code>
 *

 * @param mixed $value1	
 * @param mixed $value2	
 * @param mixed $default	⺻ ''
 * @return mixed	$value1 $value2   $value1, ٸ $default ȯ
 *
 */
function IF_($value1, $value2, $default = '') { 
	return ($value1 == $value2) ? $value1 : $default;
}

/**
 * ⺻  
 * 
 * <code>echo IF2_($a, '1', '2', '3');   // $a 1̸ 2 , ƴϸ 3 </code>
 *

 * @param mixed $value1	
 * @param mixed $value2	
 * @param mixed $return1	$value1 $value2    ȯ  
 * @param mixed $return2	$value1 $value2  ٸ  ȯ  
 * @return mixed	
 *
 */
function IF2_($value1, $value2, $return1 = '', $return2 = '') { 
	return ($value1 == $value2) ? $return1 : $return2;
}

/*
 *   
 *
 * 
 */
function SESSION_CLOSE()
{
	session_unset();
	session_destroy();
}

/*
 * <pre> ±׸  print_r() Լ  
 *

 * @param mixed $arr  php   ִ  ڷ
 */
function print_p($arr) {
	echo "<pre>";
	print_r($arr);
	echo "</pre>";
}

?>