<?php
/**
 * Oracle
 *
 * @package php.db
 */

import("php.db.DBClient");
import("php.db.OracleConfig");

/**
 * DBClient ƿƼ ԼԴϴ.
 * 
 * <code>$db = oracle_('test_db', true); </code>
 *
 * @see DB_()
 * @param string $db ȯ漳   ̸
 * @param bool $isConnect ü  ٷ ų , ٷ ɷ true, ƴϸ false
 * @return Oracle DBClient  ü
 */
function oracle_($db, $isConnect = false) { 
	return DB_('oracle', $db, $isConnect);
}


/**
 * Ŭ  Ŭ  
 *
 * @package php.db
 */
class Oracle extends DBClient { 

	private $tempStmt;

	private $cursor = array();
	private $bindList = array();
	private $defineList = array();

	/**
	 * 
	 *
	 */
	public function __construct($host = '', $port = '', $id = '', $pass = '', $db = '', $schema = '', $version = '') {
		$program		= strtoupper(__CLASS__);
		parent::__construct($program, $host, $port, $id, $pass, $db, $schema, $version);
	}

	/**
	 * database  
	 * 
	 * @return resource  resource
	 */
	public function _connect() {
		// 10g 
		if ($this->version == '10') { 
			$sid = sprintf("//%s/%s", $this->host, $this->db);
		} else { 
			$sid = $this->db;
		}

		return oci_connect($this->id, $this->pass, $sid);
	}

	/** 
	 * DB ϱ 
	 */
	public function _selectDb() { 
		return true;
	}

	/** 
	 * bind ޼ҵ 
	 *
	 * @param string $param ε  ̸
	 * @param mixed $value ε  
	 * @param int $maxLength ε  , -1 Ѿ 
	 * @param string $type ε Ÿ 
	 * @return bool 
	 */
	public function bind($param, $value, $maxlength = -1, $type = '') {
		if ($type == '') {
			return oci_bind_by_name($this->stmt, $param, $value, $maxlength);
		} else {
			return oci_bind_by_name($this->stmt, $param, $value, $maxlength, $type);
		}
	}

	/**
	 *  ݱ 
	 */
	public function close() {

		if ($this->con) {
			oci_close($this->con);
		}
	}

	/** 
	 * commit 
	 *
	 * @return bool
	 */
	public function commit() {
		return oci_commit($this->con);
	}

	public function define($column, $var, $type) {
		return oci_define_by_name($this->stmt, $column, $var, $type);
	}

	/**
	 *  ޼ 
	 * 
	 * @return string  ޼ 
	 */
	public function error() {
		$arr = oci_error();

		return $arr['message'];
	}

	/**
	 *   
	 *
	 * <code>
	 * $db = DB_('oracle', 'test', true);
	 *
	 * $db->parse("insert into test_table values ('1', '2')");
	 * $db->execute();		//   
	 * $db->commit();
	 *
	 * $db->close();
	 * </code>
	 * 
	 * @return resource statement  ҽ 
	 */
	public function execute($mode = OCI_DEFAULT) {
		$this->exec = oci_execute($this->stmt, $mode);
		return $this->exec;
	}

	/**
	 *  select  ؼ fetch    (row) Ѵ. 
	 *
	 * ϵǴ  array('ʵ' => '', ...); ¸ . 
	 * 
	 * @param resource $stmt select   resource
	 * @return array row Ÿ 
	 */
	public function fetch($stmt) {		
		return oci_fetch_array($stmt, OCI_ASSOC + OCI_RETURN_LOBS);
	}

	/** 
	 * ޸  
	 * 
	 * @return bool
	 */
	public function free($result) { 
		return $this->freeStatement($result);
	}

	/**
	 * prepare ޸  
	 * 
	 * @param resource $stmt oci_prepare() Լ   resource 
	 * @return bool  
	 */
	public function freeStatement($stmt = null) {
		return oci_free_statement(($stmt == null) ? $this->stmt: $stmt);
	}


	/**
	 * ߻Ÿ  
	 */
	protected function getAbstractType($type)
	{
		$type = strtoupper($type);

		switch ($type) {
			case 'FILE' :
			case 'CFILE' :
			case 'CLOB': 
			case 'BLOB':
			case 'RDD':					// rowid
			case 'NTY':					// named types
//			case 'INT':
//			case 'CHR':
			case 'BIN':					// binary
			case 'LNG':
			case 'LBI': 
			case 'RSET':				// cursor
				return constant("SQLT_".$type);
			default: 
				return '';
		}
	}

	/**
	 *    ʵ  Ѵ.
	 *
	 * @param resource $stmt select   resource
	 * @return int ʵ尳 
	 */
	public function getFieldCount($stmt) {
		return oci_num_fields($stmt);
	}

	/**
	 *  ġ ʵ ̸ ´. 
	 *
	 * @param resource $stmt select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵ̸ 
	 */
	public function getFieldName($stmt, $i) {
		return oci_field_name($stmt, $i+1);
	}

	/**
	 *  ġ ʵ Ÿ ´. 
	 *
	 * @param resource $stmt select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵŸ
	 */
	public function getFieldType($stmt, $i) {
		return oci_field_type($stmt, $i+1);
	}

	/**
	 *    
	 * 
	 * @return resource 
	 */
	public function getResult() { 
		return $this->stmt;
	}

	/**
	 * DBData  
	 * 
	 * <code>
	 * $db = DB_('oracle', 'test', true);
	 * 
	 * $data = $db->getData("select 1 from dual");
	 * echo $data;
	 * 
	 * $db->close();
	 * </code>
	 *
	 * @param	string $query DB query
	 * @param	boolean $isOne ε ĭ ű
	 * @param	string $baseClass  Ŭ ̸ 
	 * @return	DBData 
	 */
	function getData($query, $isOne = false, $baseClass = "DBData") 
	{

		$this->parse($query);
		$this->execute();

		return $this->getBindData($isOne, $baseClass);
	} 

	/** 
	 * prepare    DBData ü  
	 *
	 * <code>
	 * $db = DB_('oracle', 'test', true);
	 *
	 * $db->parse("select * from test_table where aaa = :aaa and bbb = :bbb");
	 * $db->bind(":aaa", 2);
	 * $db->bind(":bbb", 3);
	 * $db->execute();
	 * 
	 * $data = $db->getBindData();		
	 * echo $data;
	 *
	 * $db->close();
	 * </code>
	 * 
	 * @return DBData 
	 */
	function getBindData($isOne = false, $baseClass = "DBData") {

		$data = $this->createData($this->getResult(), $baseClass);

		//   ¥ true
		// true ̸ next ٷ  · Ѿ´. 
		if ($isOne) 
			$data->next();

		return $data;
	}

	/**
	 * cursor  DBData 
	 *
	 * <code>
	 * 
	 * $db = DB_('oracle', 'test', true);
	 * 
	 * $cursor = $db->newCursor('test_cursor');
	 * 
	 * ....... 
	 * 
	 * $data = $db->getCursorData('test_cursor');
	 * echo $data;
	 * 
	 * $db->close();
	 * 
	 * </code>
	 * 
	 * @return DBData 
	 */
	function getCursorData($name, $isOne = false, $baseClass = 'DBData' ) {

		$data = $this->createData($this->cursor[$name], $baseClass);

		//   ¥ true
		// true ̸ next ٷ  · Ѿ´. 
		if ($isOne) 
			$data->next();

		return $data;
	}

	/**
	 * select  ؼ ¡ DBData Ѵ. 
	 *
	 * <code>
	 *
	 * $db = DB_('oracle', 'test', true);
	 *
	 * $data = $db->getPageData("select 1 from dual", 1, 10);
	 * echo $data;
	 *
	 * $db->close();
	 * 
	 * </code>
	 * 
	 * @param string $query select 
	 * @param int $page    
	 * @param int $count  Ʈ  
	 * @param string $baseClass  DBData   Ŭ , ⺻ DBData  
	 * @return DBData
	 */
	public function getPageData($query, $page, $count = 10,$baseClass = 'DBData') {

		//  ϱ 
		$start = ($page-1)*$count+1;
		$end = $start + $count-1;

		$sql = " SELECT * FROM ( SELECT a.*, RowNum as rNum FROM ( $query ) a WHERE RowNum <= $end ) WHERE $start <= rNum";

		return $this->getData($sql, false, $baseClass);
	}

	/**
	 * insert sql  
	 *
	 * <code>
	 * $db = DB_('oracle', 'test', true);
	 * 
	 * $data = $db->getData("select 1 from dual");
	 * 
	 * echo $db->insertSql($data)
	 * 
	 * $db->close();
	 * </code>
	 *
	 * @param	DBData $data sql   DBData ü 
	 * @param	array $omit	 ʵ 
	 * @return	Sql							
	 */
	public function insertSql(DBData $data) { 
		$tempSql = parent::insertSql($data);

		$field = $data->getTable()."_SEQ.NEXTVAL";

		$tempSql->add('NUM', $field, false);

		return $tempSql;
	}

	/**
	 * Ŀ ϱ 
	 * 
	 * @param string $name Ŀ̸ 
	 */
	public function newCursor($name) {
		$this->cursor[$name] = oci_new_cursor($this->con);
	}

	/**
	 * sql  Ľϱ 
	 *
	 * @param string $query Ľ̵ 
	 * @return resource Ľ̵ statment resource
	 */
	public function parse($query) {
		$this->stmt = oci_parse($this->con, $query);
		return $this->stmt;
	}


	/** 
	 * Ϲ   
	 * 
	 * @param string $sql  query 
	 * @param bool $isCommit commit  , ٷ commit ̸ true, ƴϸ false
	 * @param array $args ε   
	 */
	public function query($query, $isCommit = true, $args = array()) {
		$this->parse($query);


		foreach ($args as $key => $value) { 
			$this->bind($key, $value);
		}

		$this->execute();

		if ($isCommit) {
			$this->commit();
		}
	}

	/**
	 * ӽ statment ҽ ȯ
	 *
	 */
	private function returnStatement() {
		$this->stmt = $this->tempStmt;
	}

	/** 
	 * rollback
	 *
	 * @return bool  ̸ true, ̸ false 
	 */
	public function rollback() {
		return oci_rollback($this->con);
	}

	/**
	 * ӽ statment ҽ  
	 */
	private function saveStatement() {
		$this->tempStmt = $this->stmt;
		$this->stmt = $this->cursor;
	}

	/**
	 * ν 
	 * 
	 * <code>
	 *  // 1. Ϲ  
	 * 
	 *  // 2.    
	 * </code> 
	 * 
	 * @param bool $hasSyntax Syntax  ִ ,   true, ⺻ ν ̸ false 
	 * @return bool ̸ true, ̸ false
	 */
	public function spExecute($hasSyntax = false) {
	
		$bind_list = "";


		// ü  
		if ($hasSyntax) { 
			$str = $this->__sp_name;
		} 
		// Ű  
		else { 
			$keys = array_keys($this->__sp_bind_list);


			// ε Ʈ  
			foreach ( $keys as $key) { 
				// ̸  
				$bind_list[] = ':'.$this->__sp_bind_list[$key]['name'];
			}

			$bind_list = implode(",", $bind_list);

			// ν ڿ  
			$str = "BEGIN {$this->__sp_name}($bind_list); END;";
		}

		$this->__sp_statement = $this->parse($str);

		// ε Ű 
		foreach ($keys as $key) { 
			$param_name = ":".$this->__sp_bind_list[$key]['name'];
			$type		= $this->getAbstractType($this->__sp_bind_list[$key]['type']);

			// ε Ʈ 
			$temp = array(
				$this->__sp_statement, 
				$param_name, 
				&$this->__sp_bind_list[$key]['value'],
				$this->__sp_bind_list[$key]['length']
			);

			
			// ߻ Ÿ 
			if (empty($type) === false) { 
				$temp[] = $type;
			}
			
			// ε 
			call_user_func_array('oci_bind_by_name', $temp);
		}

		$this->__sp_execute_result = oci_execute($this->__sp_statement, OCI_DEFAULT);
	
		// ν  
		return $this->__sp_execute_result;
	
	}

}

?>