<?php
/**
 * Mysqli
 *
 * @package php.db
 */

import("php.db.Mysql");

/**
 * DBClient ƿƼ ԼԴϴ.
 * 
 * <code>$db = mysqli_('test_db', true); </code>
 *
 * @see DB_()
 * @param string $db ȯ漳   ̸
 * @param bool $isConnect ü  ٷ ų , ٷ ɷ true, ƴϸ false
 * @return Mysql_i DBClient  ü
 */
function mysqli_($db, $isConnect = false) { 
	return DB_('mysql_i', $db, $isConnect);
}

/**
 * mysqli  Ŭ 
 *
 * @package php.db
 */
class Mysql_i extends Mysql {

	private $mysqli;

	/**
	 * 
	 *
	 */
	public function __construct($host = '', $port = '', $id = '', $pass = '', $db = '', $schema = '', $version = '') {
		parent::__construct($host, $port, $id, $pass, $db, $schema, $version);
	}

	/**
	 * database  
	 * 
	 * @return resource  resource
	 */
	protected function _connect() { 
		$this->mysqli = new mysqli( $this->host,  $this->id,  $this->pass, $this->db );

		return true;
	}

	/** 
	 * DB ϱ 
	 */
	protected function _selectDb() { 
		return true;
	}

	/**
	 *  row  
	 *
	 * @return int 
	 */
	public function affectedRows() { 
		return $this->mysqli->affected_rows();
	}


	public function bind() { 
		$arr = func_get_args();

		return call_user_func_array(array($this->getResult(), 'bind_param'), $arr);
	}

	public function bindResult() { 
		$arr = func_get_args();

		return call_user_func_array(array($this->getResult(), 'bind_result'), $arr);
	}

	/**
	 *  ݱ 
	 */
	public function close()
	{
		$this->mysqli->close();
	}

	/**
	 *  ޼ 
	 * 
	 * @return string  ޼ 
	 */	
	public function error() {
		return $this->mysqli->error;
	}

	/**
	 * ڿ escape	
	 * 
	 * @param string $str  escape  ڿ 
	 * @return string escape  ڿ
	 */
	public function escape($str) { 
		return $this->mysqli->real_escape_string($str);
	}

	/**
	 *  select  ؼ fetch    (row) Ѵ. 
	 *
	 * ϵǴ  array('ʵ' => '', ...); ¸ . 
	 * 
	 * @param resource $result select   resource
	 * @return array row Ÿ 
	 */
	public function fetch($result) {
		return $result->fetch_assoc();
	}


	public function fetchField($result, $attribute = 'name') { 
		$arr = array();

	    while ($finfo = $result->fetch_field()) {
			$arr[] = $finfo->{$attribute};
	    }

		return $arr;		
	}

	/** 
	 * ޸  
	 * 
	 * @return bool
	 */
	public function free($result) {
		if ($result) { 
			return $result->free();
		} 

		return false;
	}

	/**
	 *    ʵ  Ѵ.
	 *
	 * @param resource $result select   resource
	 * @return int ʵ尳 
	 */
	public function getFieldCount($result) {
		return $result->field_count;
	}

	/**
	 *  ġ ʵ ̸ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵ̸ 
	 */
	public function getFieldName($result, $i) {
		$arr = $this->fetchField($result);

		return $arr[$i]->name;
	}


	public function getFieldList($result) { 
		return $this->fetchField($result, 'name');
	}

	/**
	 *  ġ ʵ Ÿ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵŸ
	 */
	public function getFieldType($result, $i) { 
		$arr = $this->getFieldTypeList($result);

		return $arr[$i];
	}

	public function getFieldTypeList($result) {
		return $this->fetchField($result, 'type');
	}

	/** 
	 * Ϲ   
	 * 
	 * @param string $sql  query 
	 * @return resource  resource
	 */
	public function query($sql) {
		$this->result = $this->mysqli->query($sql);
		
		return $this->result;
	}

	public function prepare($sql) { 
		$this->result = $this->mysqli->prepare($sql);
		
		return $this->result;
	}

}

?>