<?php
/**
 * DBClient
 *
 * @package php.db
 */

import("php.lang.PObject");
import("php.net.IConnector");
import("php.db.Sql");
import("php.db.DBData");

/**
 * DBClient ƿƼ ԼԴϴ.
 * 
 * <code>$db = DB_('mssql', 'test_db', true); </code>
 *
 * @see DBClient::createConnector()
 * @param string $class  DBClient  Ŭ̸ (mssql, oracle, cubrid, mysql, mysql_i, sqlite, postgres)
 * @param string $db ȯ漳   ̸
 * @param bool $isConnect ü  ٷ ų , ٷ ɷ true, ƴϸ false
 * @return Mssql|Oracle|Mysql|Cubrid|Postgres|Mysql_i|Sqlite DBClient  ü
 */
function DB_($class, $db, $isConnect = false) { 
	return DBClient::createConnector($class, $db, $isConnect);
}

/**
 * DB ڿ  ߻ ŬԴϴ.
 *
 * <code>
 *  // DB  
 *  $db = DB_('mssql', 'test_db', true);
 * 
 *  // Ÿ Ÿ  
 *  $data = $db->getMetaData("table");
 *  echo $data->top(1);
 *
 *  // ν  
 *	$db->spName('test');
 *	$db->spBind('aaa', 'int', 3, $is_output);     
 *	$db->spBind('bbb', 'int', 3, 'return', $var); 
 *
 *	$db->spSet('aaa', 10);
 * 
 *	$db->spExecute();
 *
 *	echo $db->spGet('bbb');
 *	print_r($db->spGetParameters());
 *
 *  // DB  
 *  $db->close();
 *
 * </code>
 *
 * @package php.db
 * @see DB_()
 */
abstract class DBClient extends PObject implements IConnector {

	/**
	 * Ӽ  
	 *
	 * program, host, port, id, pass, db, schema, version 
	 * 
	 */
	private $_attribute = array();

	/**
	 *  resource
	 *
	 * @var resource
	 */
	protected $con;

	/**
	 *   resource
	 *
	 * @var resource
	 */
	protected $result;

	/**
	 * ν resource
	 *
	 * @var resource
	 */
	protected $stmt;


	/*
	 * Ŭ  resource
	 *
	 * @var resource
	 */
	protected $exec;


	/**
	 * ν ̸
	 *
	 * @var string
	 */
	protected $__sp_name;

	/**
	 * ν  Ʈ 
	 *
	 * @var array
	 */
	protected $__sp_bind_list = array();

	/**
	 * ν  resource
	 *
	 * @var resource
	 */
	protected $__sp_execute_result = null;

	/**
	 * ν  resource
	 *
	 * @var resource 
	 */
	protected $__sp_statement = null;

	/*
	 *  
	 *
	 */
	public function __construct($program = '', $host = '', $port = '', $id = '', $pass = '', $db = '', $schema = '', $version = '')  {

		$this->program	=	strtoupper($program);
		$this->host		=	$host;
		$this->port		=	$port;
		$this->id		=	$id;
		$this->pass		=	$pass;
		$this->db		=	$db;
		$this->schema	=	$schema;
		$this->version	=	$version;
	}

	/**
	 *  ҽ 
	 * 
	 * @return	resource		 ҽ 
	 */
	abstract protected function _connect();

	/**
	 * DB 
	 * 
	 */
	abstract protected function _selectDb();


	/**
	 * Ӽ о , getAttribute()   Դϴ. 
	 *
	 * ex) echo $dbclient->program;
	 * 
	 * @param	string $key   ̸ 
	 * @return	mixed
	 *
	 */
	public function __get($key) { 
		return $this->_attribute[strtolower($key)];
	}

	/**
	 * Ӽ ϱ , setAttribute()   Դϴ. 
	 *
	 * ex) $dbclient->program = "mssql";
	 * 
	 * @param	string $key	Ӽ ̸
	 * @param	mixed $value Ӽ
	 * @return	mixed
	 *
	 */
	public function __set($key, $value) { 
		$this->_attribute[strtolower($key)] = $value;
	}

	/**
	 *  ࿡   row  
	 *
	 * @return	int
	 */
	public function affectedRows() { return 0; }

	/**
	 * Ʈ  
	 *
	 * @access public
	 * @return bool ۵Ǿ true, ƴϸ false 
 	 */
	public function begin() { return true; }

	/**
	 * 
	 * 
     * @return DBClient  ü
	 */
	public function connect() 
	{
		$this->con = $this->_connect();

		$this->_selectDb();

		// йȣ 
		$this->id	= "";
		$this->pass = "";

		return $this;
	}


	/**
	 * commit 
	 * 
	 */
	public function commit() { }


	/**
	 * ݱ
	 * 
	 * @return bool 
	 */
	public function close()
	{ 
		return true;
	}

	/**
	 *    
	 * 
	 * @static 
	 * @param	string $dbClass	database  (mysql, mssql, oracle, progres, cubrid, sqlite)
	 * @param	string $db database ̸
	 * @param	bool $isConnect database   , ̸ true , ⺻ false 
	 * @return	DBClient		DBClient  Ŭ
	 */
	public static function createConnector($dbClass, $db, $isConnect = false) {

		$obj = null;

		if (class_exists($dbClass)) { 
			$obj = new $dbClass();
			$obj->set($db);

			if ($isConnect) $obj->connect();
		} 

		return $obj;
	}

	/**
	 * DBData ü  
	 * 
	 * @param	resource $resource	 ҽ
	 * @param	string $baseClass  Ŭ ̸ 
	 * @return	DBData
	 */
	public function createData($result, $baseClass = "DBdata") {
		// ⺻ Data Ŭ ϰ 
		// Data Ŭ  ٸ Data Ŭ ϸ ȴ. 

		$data = new $baseClass($this);
		$data->setBaseClass($baseClass);

		if (!$result)
			return $data;

		$data->setFields($this->getFieldList($result));
		$data->setTypeList($this->getFieldTypeList($result));


		// Ÿ ߰
		while ($d = $this->fetch($result)) 
			$data->add($d);

		return $data;
	}

	/**
	 * delete sql  
	 *
	 * @param	DBData $data sql   DBData ü 
	 * @return	Sql							
	 */
	public function deleteSql(DBData $data) { 
		$sql = new Sql($this->program, "delete");
		$sql->setFrom($data->getTable());
		$sql->addWhere('','NUM','=', $data->num, false);

		return $sql;
	}

	/**
	 *  
	 * 
	 */
	abstract public function error() ;

	/**
	 *  DB ڿ escape	
	 * 
	 * @param string $str  escape  ڿ 
	 * @return string escape  ڿ
	 */
	public function escape($str) { 
		return str_replace("'", "''", $str);
	}



	/**
	 * ڵ 
	 *
	 * @param	resource $result  
	 * @return	array
	 */
	abstract public function fetch($result) ;

	/**
	 * ޸ 
	 *
	 * @param	resource $result   
	 */
	abstract public function free($result) ;

	/**
	 *    
	 * 
	 * @return resource 
	 */
	public function getResult() {
		return $this->result;
	}

	/**
	 * DBData  
	 * 
	 * @param	string $query DB query
	 * @param	boolean $isOne ε ĭ ű
	 * @param	string $baseClass  Ŭ ̸ 
	 * @return	DBData 
	 */
	public function getData($query, $isOne = false, $baseClass = 'DBData') 
	{
		$this->query($query);

		$data = $this->createData($this->getResult(), $baseClass);

		if (!$this->getResult())  
			$this->free($this->getResult());

		if ($isOne) 
			$data->next();

		return $data;
	}

	/**
	 *  
	 * 
	 * @param	int $total ü 
	 * @param	int $limitPage   Ʈ 
	 * @param	int $limitBlock   
	 * @return	array		count : ü, page :  , block :   
	 */
	public function getPageCount($total, $limitPage, $limitBlock) { 
		$count = $total;
		$page = ceil($count/$limitPage);
		$block = ceil($page/$limitBlock);

		$temp = array('count'=>$count, 'page'=>$page, 'block'=>$block);

		return $temp;		
	}

	/**
	 *   
	 * 
	 * @param	string $sql	  
	 * @param	int $limitPage   Ʈ 
	 * @param	int $limitBlock   
	 * @return	array count : ü, page :  , block :   
	 */
	public function getPageCountSubquery($sql, $limitPage, $limitBlock) {
		$sql = "SELECT COUNT(*) as cnt FROM ( $sql )";

		return $this->getPageCountQuery($sql, $limitPage, $limitBlock);
	}

	/**
	 * Ϲ  
	 *
	 * count(*)  alias cnt  ؾ  .
	 * 
	 * @param	string $sql	Ϲ  
	 * @param	int $limitPage   Ʈ 
	 * @param	int $limitBlock	  
	 * @return	array	count : ü, page :  , block :   
	 */
	public function getPageCountQuery($sql, $limitPage, $limitBlock) {
		$data = $this->getData($sql, true);

		return $this->getPageCount($data->get('cnt', 0), $limitPage, $limitBlock);
	}

	/**
	 * ʵ   
	 *
	 * @param	resource $result  
	 * @return	int
	 */
	abstract public function getFieldCount($result) ;

	/**
	 * ʵ ̸   
	 *
	 * @param	resource $result  
	 * @param	int $i ʵ offset, 0-based number
	 * @return	string		ʵ ̸ 
	 */
	abstract public function getFieldName($result, $i) ;


	/**
	 * Ǿ  ؼ ʵ帮Ʈ  ´. 
	 * DBDataü   Ǿ  
	 *
	 * @param	resource $stmt    
	 * @return	array			
	 */
	public function getFieldList($stmt) {
		// ʵ Ʈ  
		$ncols = $this->getFieldCount($stmt);

		$arr = array();
		for ($i = 0; $i < $ncols; $i++) {
			$arr[] = $this->getFieldName($stmt, $i);
		}		

		return $arr;
	}

	/**
	 * ʵ Ÿ   
	 *
	 * @param	resource $result  
	 * @param	int $i ʵ offset, 0-based number
	 * @return	string		ʵ Ÿ ̸ 
	 */
	abstract public function getFieldType($result, $i);

	/**
	 * Ǿ  ؼ ʵ Ÿ Ʈ  ´. 
	 * DBDataü   Ǿ  
	 *
	 * @param	resource $stmt    
	 * @return	array			
	 */
	public function getFieldTypeList($stmt) { 
		// ʵ Ʈ  
		$ncols = $this->getFieldCount($stmt);

		$arr = array();
		for ($i = 0; $i < $ncols; $i++) {
			$arr[] = $this->getFieldType($stmt, $i);
		}		

		return $arr;
	}

	/**
	 *  Ÿ Ÿ 
	 * 
	 * <pre>
	 *   : php/db/meta/
     *   : {ŸŸ}Data_{program}{version}.php 
	 * </pre>
	 *
	 * <code>
	 * 	    //   db  ̺ Ʈ Dataü ȯ
	 * 		$db->getMetaData('table');					
	 * 
	 *		// ־ ̺ ؼ ε Ʈ Dataü ȯ
	 *		$db->getMetaData('index', '̸̺');	
	 * 
	 * 		// ־ ̺ ؼ ÷ Ʈ Dataü ȯ
	 *		$db->getMetaData('column', '̸̺');	
	 * 
	 * </code>
	 *
	 * @param string $meta_type  ŸŸ Ÿ  (table, database, column, index, job, param, proc, view, serial, etc)
	 * @param string $object ü ̸ 
	 * @param array $option    ɼ, DB Ʋ 
	 * @return	DBData 
	 */
	public function getMetaData($meta_type = 'table', $object = '', $option = array()) {

		//  ̸ 
		$filename = sprintf("%sData_%s%s.php", ucwords($meta_type), $this->program, $this->version );

		// ŸData ʿ  
		$meta_info = array(
			'schema_name'	=> $this->escape($this->schema),
			'object_name'	=> $this->escape($object),
			'db_name'		=> $this->escape($this->db),
			'option'		=> $option
		);

		///  н  
		$path = LIB."php/db/meta/".$filename;

		// Ÿ sql о
		if (file_exists($path)) {
			return include $path;
		} else { 
			return new DBData($this);
		}
	}


	/**
	 * insert sql  
	 *
	 * @param	DBData $data sql   DBData ü 
	 * @param	array $omit	 ʵ 
	 * @return	Sql							
	 */
	public function insertSql(DBData $data, $omit = array()) { 
		$tempSql = new Sql($this->program, "insert");
		$tempSql->setFrom($data->getTable());

		$rows = $data->gets();

		foreach ($data->getFields() as $field) {
			if ($field != 'num') {
				$tempSql->add($field, $rows[$field]);
			}
		}

		return $tempSql;
	}

	/**
	 *  DB Ȯϱ 
	 *
	 * <code>
	 * if ($dbclient->is('mssql')) { 
	 *    echo "database is mssql";
	 * } 
	 *
	 * if ($dbclient->is('mysql', '5')) { 
     *    echo "current version : mysql 5" ;
	 * }
	 * </code>
	 *
	 * @param	string $db_name	Ÿ̽  (mysql, mssql, oracle, postgres, cubrid, sqlite)
	 * @param	string $version	Ӽ
	 * @return	boolean			
	 *
	 */
	public function is($db_name, $version = '') { 
		if (!$version) { 
			return ($this->program == strtoupper($db_name));
		} else { 
			return ($this->program == strtoupper($db_name) && $this->version == $version);
		}
	}

	/**
	 * Ǿ ִ θ ˷
	 *
	 * @access public 
	 * @return bool Ǿ  true, ƴϸ false 
	 */
	public function isConnected() { 
		return ($this->con) ? true : false ;
	}


	/**
	 *  ϱ
	 *
	 * @param	string $sql	sql 
	 * @return	resource		 ,   false 
	 */
	abstract public function query($sql) ;


	/**
	 * rollback
	 * 
	 */
	public function rollback() { }


	/**
	 * result set ̵ 
	 *
	 * @param	int $count ̵ row  
	 */
	public function seek($count) { }

	/**
	 * ἳ,  {Ŭ}Config.php Ͽ   
	 * 
	 * {̸}_{Ŭ}_HOST : db ּ <br >
	 * {̸}_{Ŭ}_PORT : Ʈ <br >
	 * {̸}_{Ŭ}_ID   : ̵ <br > 
	 * {̸}_{Ŭ}_PASS : йȣ  <br >
	 * {̸}_{Ŭ}_DB   : DB ̸  <br >
	 * {̸}_{Ŭ}_VERSION :  <br >
	 * {̸}_{Ŭ}_SCHEMA  : Ű  <br >
	 * 
	 * @param	string $name   ̸ 
	 *
	 */
	public function set($name)
	{
		$name = strtoupper($name."_".$this->program);

		$this->host		=	constant("{$name}_HOST");
		$this->port		=	constant("{$name}_PORT");
		$this->id		=	constant("{$name}_ID");
		$this->pass		=	constant("{$name}_PASS");
		$this->db		=	constant("{$name}_DB");
		$this->version	=	constant("{$name}_VERSION");
		$this->schema	=	constant("{$name}_SCHEMA");
	}

	/**
	 * ἳ,  /php/db/conf/{db}/{̸}.ini Ͽ   
	 * 
	 * host : db ּ <br >
	 * port : Ʈ <br >
	 * id   : ̵ <br > 
	 * pass : йȣ  <br >
	 * db   : db ̸  <br >
	 * version :  <br >
	 * schema  : Ű  <br >
	 * 
	 * @param	string $name   ̸ 
	 *
	 */
	public function setConfig($name) { 
		$name		= strtolower($name);
		$program	= strtolower($this->program);

		$path = LIB."php/db/conf/{$program}/{$name}.ini";

		if (!file_exists($path)) return; 

		$arr = parse_ini_file($path, true);

		$this->setProperty($arr[$name]);
	}

	/**
	 * Ӽ 
	 * 
	 * @param	array $arr  Ӽ 
	 *
	 */
	public function setProperty($arr) { 
		foreach ($arr as $key => $value) { 
			$value = str_replace("{LIB}", LIB, $value);

			$this->{strtolower($key)}	 = $value;
		}
	}

	/**
	 * update sql  
	 *
	 * @param	DBData $data sql   DBData ü 
	 * @param	array $omit	 ʵ 
	 * @param	bool $is_update_field	false  ʵ, true  ʵ  
	 * @return	Sql							
	 */
	public function updateSql(DBData $data, $omit = array(), $is_update_field = false) {
		$sql = new Sql($this->program, "update");
		$sql->setFrom($data->getTable());

		$rows = $data->gets();

		foreach ($data->getFields() as $field) {
			if ($field != 'num') {

				if ($is_update_field) { 
					if (in_array($field, $omit)) { 
						$sql->add($field, $rows[$field]);
					}
				} else { 
					if (!in_array($field, $omit)) { 
						$sql->add($field, $rows[$field]);
					}
				}
			}
		}

		$sql->addWhere('','NUM','=', $data->num, false);

		return $sql;
	}

	/**
	 * ε Ʈ  
	 *
	 * @param string $name ε ̸ 
	 * @param string $type ε Ÿ, Ÿ̽  Ʋ 
	 * @param string $output output , in, out, inout, return 
	 * @param int $length Ÿ, -1  
	 * @param mixed $value  Ÿ Ǵ output   Ÿ
	 */
	public function spBind($name, $type = '', $output = 'in', $length = -1, &$value = null ) {

		$this->__sp_bind_list[strtolower($name)] = array(
			'name' => $name,
			'type' => strtolower($type),
			'output' => strtolower($output),
			'length' => $length,
			'value' => $value
		);
	}



	/**
	 * ν  
	 *
	 *  Ŭ ϴ Ŭ spExecute ޼ҵ带 ؼ ν    ֽϴ.
	 * 

	 */
	public function spExecute()  {}

	/**
	 * Ķ   
	 * 
	 * @param string $name Ķ ̸ 
	 * @return mixed spBind ߴ $value   ɴϴ. 
	 */
	public function spGet($name) {
		return $this->__sp_bind_list[strtolower($name)]['value'];
	}	

	/**
	 * Ķ Ʈ  
	 * 
	 * @return array ε ̸  value  迭 մϴ.
	 */
	public function spGetParameters() {
		$temp = array();

		foreach ($this->__sp_bind_list as $key => $arr) { 
			$temp[$key] = $arr['value'];
		}

		return $temp;
	}

	/**
	 * ν ̸ 
	 * 
	 * @param string $proc_name ν ̸ 
	 */
	public function spName($proc_name)  {
		$this->__sp_name = $proc_name;
	}

	/** 
	 * Ķ   
	 * 
	 * @param string $name ε ̸ 
	 * @param mixed $value	ε ̸  Ÿ 
	 */
	public function spSet($name, $value) {
		$this->__sp_bind_list[strtolower($name)]['value'] = $value;	
	}

	/** 
	 * Ķ Ʈ  
	 *
	 * @param array $arr ε    մϴ.
	 */
	public function spSetParameters($arr) {
		foreach ($arr as $key => $value) { 
			$this->spSet($key, $value);
		}
	}

}

?>