<?php
/**
 * ť긮
 *
 * @package php.db
 */


import("php.db.DBClient");
import("php.db.CubridConfig");


/**
 * DBClient ƿƼ ԼԴϴ.
 * 
 * <code>$db = cubrid_('test_db', true); </code>
 *
 * @see DB_()
 * @param string $db ȯ漳   ̸
 * @param bool $isConnect ü  ٷ ų , ٷ ɷ true, ƴϸ false
 * @return Cubrid DBClient  ü
 */
function CUBRID_($db, $isConnect = false) { 
	return DB_('cubrid', $db, $isConnect);
}

/**
 * ť긮  Ŭ
 *
 * <code>
 *  $cubrid = DB_('cubrid', 'testdb', true);
 *
 *  $cubrid->query("insert into testclass values ('aaaa')");
 *  echo $cubrid->getData("select * from testclass");
 * 
 *  $cubrid->close();
 * </code>
 *
 * @package php.db
 */
class Cubrid extends DBClient {

	private $tempStmt;

	private $oid		= null;

	private $cursor		= array();

	private $proc_name	= "";

	private $bind_list	= array();

	/**
	 * 
	 *
	 */
	public function __construct($host = '', $port = '', $id = '', $pass = '', $db = '', $schema = '', $version = '') {
		$program		= strtoupper(__CLASS__);
		parent::__construct($program, $host, $port, $id, $pass, $db, $schema, $version);
	}

	/**
	 * DB 
	 * 
	 * @return resource 
	 */
	protected function _connect() {
		return cubrid_connect(
					$this->host, 
					$this->port, 
					$this->db,
					$this->id,
					$this->pass
				);
	}

	protected function _selectDb() { 
		return true;
	}

	/**
	 *  row  
	 *
	 * @return int 
	 */
	public function affectedRows() { 
		return cubrid_affected_rows($this->getResult());
	}

	/** 
	 * set Ÿ Ӽ  ߰ 
	 *
	 * @param string $attr  Ӽ̸ 
	 * @param mixed $value Ӽ 
	 * @param string $oid oid 
	 * @return bool
	 */
	public function addSet($attr, $value, $oid = '') { 
		return cubrid_set_add($this->con, $this->getOID($oid), $attr, $value);
	}

	/** 
	 *  seq  ߰
	 *
	 * @param string $attr  Ӽ̸ 
	 * @param mixed $value Ӽ 
	 * @param string $oid oid 
	 * @return bool
	 */
	public function addSeq($attr, $value, $oid = '') { 
		$size = cubrid_col_size($this->con, $this->getOID($oid), $attr);

		return $this->insertSeq($attr, $size+1, $value);
	}

	/** 
	 *  oid شǴ instance  
	 *  
	 *  δ Ÿ̽ ڵ尡  ˴ϴ. 
	 *  
	 * @param string $oid oid 
	 * @return bool 
	 */
	public function drop($oid = '') { 
		return cubrid_drop($this->con, $this->getOID($oid));
	}

	/** 
	 * set Ÿ Ӽ  
	 *
	 * @param string $attr  Ӽ̸ 
	 * @param mixed $value Ӽ 
	 * @param string $oid oid 
	 * @return bool
	 */
	public function dropSet($attr, $value, $oid = '') { 
		return cubrid_set_drop($this->con, $this->getOID($oid), $attr, $value);
	}

	/**
	 * oid Ư Ӽ   
	 * 
	 * @param string $attr Ӽ(ʵ) ̸ 
	 * @param string $oid Ӽ(ʵ)   ִ oid 
	 * @return mixed|array oid Ӽ 
	 */
	public function get($attr, $oid = '') { 
		if (is_array($attr)) { 
			$temp = array();

			foreach ($attr as $temp_attr) { 
				$temp[$temp_attr] = cubrid_get($this->con, $this->getOID($oid), $temp_attr);
			}

			return $temp;
		} else { 
			return cubrid_get($this->con, $this->getOID($oid), $attr);
		}
	}

	/**
	 *  oid  
	 * 
	 * @param resource $result    result 
	 * @return string result ˻ oid 
	 *
	 */
	public function getCurrentOID($result) { 
		return cubrid_current_oid($result);
	}



	/**
	 * oid   
	 *
	 * ⺻  oid  parameter  oid ȯѴ.  
	 * 
	 * @param string $oid  oid 
	 * @return string 
	 */ 
	public function getOID($oid = '') { 
		return (empty($oid)) ? $this->oid : $oid;
	}



	/** 
	 *  oid Ӽ 迭   
	 * 
	 * @param string $oid oid 
	 * @return array  
	 */
	public function gets($oid = '') { 
		return cubrid_get($this->con, $this->getOID($oid));
	}

	/** 
	 *  seq Ư  ֱ 
	 * 
	 * @param string $attr  Ӽ̸ 
	 * @param int $index  sequence index , ó ġ 1 
	 * @param mixed $value Ӽ 
	 * @param string $oid oid 
	 * @return bool
	 */
	public function insertSeq($attr, $index, $value, $oid = '') { 
		return cubrid_seq_insert($this->con, $this->getOID($oid), $attr, $index, $value);
	}

	/**
	 * oid   Ȯ 
	 *
	 * @param string $oid  üũ oid 
	 * @return bool  oid ϸ true, ƴϸ false
	 */
	public function isInstance($oid = '') { 
		return cubrid_is_instance($this->con, $this->getOID($oid));
	}


	/** 
	 *  oid Ӽ  
	 * 
	 * @param string $attr Ӽ(ʵ)
	 * @param mixed $value Ӽ
	 * @param string $oid oid 
	 * @return bool    true, ƴϸ false
	 */
	public function put($attr, $value, $oid = '') { 
		
		$args = array($this->con, $this->getOID($oid), $attr);


		if (is_array($arr) == false) { 
			$args[] = $value;	
		} 

		return call_user_func_array('cubrid_put', $args); 
	}

	/**
	 *  Ӽ ÿ  
	 * 
	 * <code>$cubrid->puts(array('aa' => 1, 'bb' => 2, 'cc' => 3), $oid);</code>
	 *
	 * @param array $attr_list ӼƮ
	 * @param string $oid oid 
	 * @return bool
	 */
	public function puts($attr_list, $oid = '') { 
		return cubrid_put($this->con, $this->getOID($oid), $attr_list);
	}

	/**
	 * oid 
	 *
	 * @param string $oid oid 
	 */
	public function setOID($oid) { 
		$this->oid = $oid;
	}




	/** 
	 *  seq Ư  
	 * 
	 * @param string $attr  Ӽ̸ 
	 * @param int $index  sequence index , ó ġ 1 
	 * @param string $oid oid 
	 * @return bool
	 */
	public function dropSeq($attr, $index, $oid = '') { 
		return cubrid_seq_insert($this->con, $this->getOID($oid), $attr, $index);
	}

	/** 
	 *  seq Ư  ϱ (update)
	 * 
	 * @param string $attr  Ӽ̸ 
	 * @param int $index  sequence index , ó ġ 1 
	 * @param mixed $value   
	 * @param string $oid oid 
	 * @return bool
	 */
	public function putSeq($attr, $index, $value, $oid = '') { 
		return cubrid_seq_put($this->con, $this->getOID($oid), $attr, $index, $value);
	}

	/** 
	 * collection   
	 *
	 * Ӽ collection Ÿ   ´. 
	 * 
	 * @param string $attr  Ӽ̸ 
	 * @param string $oid oid 
	 * @return int 
	 */
	public function getCollectionSize($attr, $oid = '') { 
		return cubrid_col_size($this->con, $this->getOID($oid), $attr);
	}

	/** 
	 * collection Ÿ 迭 ·  (set, multiset, sequence)
	 *
	 * Ӽ collection Ÿ   迭 ɴϴ. 
	 *
	 * @param string $attr  Ӽ̸ 
	 * @param string $oid oid 
	 * @return array
	 */
	public function getCollection($attr, $oid = '') { 
		return cubrid_col_get($this->con, $this->getOID($oid), $attr);
	}

	/** 
	 *  Ÿ set, multiset, sequence   Data ü ´.
	 *
	 * collection Ÿ߿  Ŭ(̺) · Ǿ ִ   
	 * װͿ  Ÿ DBData ü ȯݴϴ. 
	 * 
	 * @param string $attr  Ӽ̸ 
	 * @param bool $isOne  ĭ   
	 * @param string $oid oid 
	 * @return DBData
	 */
	public function getOIDData($attr, $isOne = false, $oid = '', $baseClass = 'DBData') { 
		$a = $this->getCollection($attr, $this->getOID($oid));

		$data = new $baseClass($this);

		if (empty($a)) { 
			return $data;
		}


		$data->setFields(array_keys($this->gets($a[0])));
		$data->addField('oid');

		foreach ($a as $oid) { 
			$arr = $this->gets($oid);
			$arr['oid'] = $oid;
			$data->add($arr);
		}

		if ($isOne) { 
			$data->next();
		}

		return $data;
	}

	/** 
	 *  б lock  
	 * 
	 * @param string $oid oid 
	 * @return bool 
	 */
	public function setReadLock($oid = '') { 
		return cubrid_lock_read($this->con, $this->getOID($oid));
	}

	/** 
	 *   lock  
	 * 
	 * @param string $oid oid 
	 * @return bool 
	 */
	public function setWriteLock($oid = '') { 
		return cubrid_lock_write($this->con, $this->getOID($oid));
	}

	/** 
	 *  ݱ 
	 * 
	 * @return bool 
	 */
	public function close() {
		cubrid_disconnect($this->con);
	}


	/** 
	 * commit 
	 *
	 * cubrid  ⺻ Ʈ ϱ  insert, update, delete  commit  ؾ մϴ. 
	 * select  commit ָ ϴ. 
	 * 
	 * @return bool 
	 */
	public function commit() { 
		cubrid_commit($this->con);
	}

	/** 
	 * rollback
	 *
	 * @return bool 
	 */
	public function rollback() { 
		cubrid_rollback($this->con);
	}

	/** 
	 * result ޸  
	 *
	 * @param resource $result select  result 
	 * @return bool
	 */
	public function free($result) { 
		return cubrid_close_request($result);
	}

	/** 
	 *   ޼  
	 * 
	 * @return string  ޼ 
	 */
	public function error() {
		return cubrid_error_msg($this->con);
	}

	/**
	 * Ŀ ̵ 
	 * 
	 * @param int $count ̵ų ġ
	 * @param string $origin  first, current, last, ⺻ current 
	 * @return bool
	 */
	public function seek($count, $origin = 'current') { 
		$temp_origin = constant("CUBRID_CURSOR_".strtoupper($origin));

		return cubrid_move_cursor($this->getResult(), $count, $temp_origin);
	}

	/** 
	 * Ϲ   
	 * 
	 * <code>$cubrid->query("insert into tclass values ('a')");</code>
	 *
	 * @param string|resource $query   ̳ prepare   resource
	 * @param string $option   ɼ,  oid, async, all
	 * @return resource $query  resource, ϸ false 
	 */
	public function query($query, $option = '') {
	
		$options = strtolower($option);

		if ($option == 'oid') { 
			$option = CUBRID_INCLUDE_OID;
		} else if ($option == 'async') {
			$option = CUBRID_ASYNC;
		} else if ($option == 'all') { 
			$option = CUBRID_ASYNC | CUBRID_INCLUDE_OID;
		}

		if (is_string($query)) {	// Ϲ sql 
			$args = array($this->con, $query);

			if ($option != '') { 
				$args[] = $option;
			}

			$this->result = call_user_func_array('cubrid_execute', $args);

			return $this->result;

		} else {		// prepare ̿ ü  

			$args = array($query);

			if ($option != '') { 
				$args[] = $option;
			}

			call_user_func_array('cubrid_execute', $args);

			$this->result = $query;

			return $query;
		}
	}

	/**
	 * ε   ϰ ϴ ޼ҵ 
	 * 
	 * ε  ?  ǥѴ. 
	 *
	 * <code>
	 * //prepare ⺻   
	 * $sql = "select * from board where title = ?";
	 * $number = "";
	 *
	 * $stmt = $cubrid->prepare($sql);
	 * $cubrid->bind($stmt, 1, $number);
	 *
	 * echo $cubrid->getData($stmt);   or  $cubrid->query($stmt);
	 * </code>
	 *
	 * @param string $query   
	 * @param string $option ɶ oid     , 'oid' oid 
	 * @return resource prepare ޼ҵ  resource
	 */
	public function prepare($query, $option = '')  { 
		if (strtolower($option) == 'oid') { 
			$option = CUBRID_INCLUDE_OID;
		} 

		$args = array($this->con, $query);

		if ($option != '') { 
			$args[] = $option;
		}

		$this->tempStmt = call_user_func_array('cubrid_prepare', $args);

		return $this->tempStmt;
	} 

	/** 
	 * bind ޼ҵ 
	 *
	 * @param resource $stmt prepare()  resource
	 * @param int $index ε  ġ, ⺻ 1 
	 * @param mixed $bind_value ε  
	 * @param string bind_vlaue_type ε Ÿ, ť긮忡 Ǵ ŸԸ ״ Ѵ. 
	 */
	public function bind($stmt, $index = 1, $bind_value, $bind_value_type = '') { 

		$bind_value_type = strtoupper($bind_value_type);

		$args = array($stmt, $index, $bind_value);

		if ($bind_value_type != '') { 
			$args[] = $bind_value_type;
		} 

//		$temp = cubrid_bind($stmt, $index, $bind_value, $bind_value_type);

		$temp = call_user_func_array('cubrid_bind', $args);

		return $temp ;
	}

	/** 
	 *   resource ȯѴ. 
	 *
	 * @return resource|bool
	 */
	public function getResult() { 
		return $this->result;
	}

	/**
	 *    ʵ  Ѵ.
	 *
	 * @param resource $result select   resource
	 * @return int ʵ尳 
	 */
	public function getFieldCount($result) {
		return cubrid_num_cols($result);
	}

	/**
	 *    ʵ ̸ Ʈ 迭 Ѵ.
	 *
	 * @param resource $result select   resource
	 * @return array ʵ̸ Ʈ 
	 */
	public function getFieldList($result) { 
		return cubrid_column_names($result);
	}

	/**
	 *  ġ ʵ ̸ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵ̸ 
	 */
	public function getFieldName($result, $i) {
		$arr = $this->getFieldList($result);

		return $arr[$i];
	}

	/**
	 *  ġ ʵ Ÿ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵŸ
	 */
	public function getFieldType($result, $i) {
		$arr = $this->getFieldTypeList($result);

		return $arr[$i];
	}

	/**
	 *  ġ ʵŸ Ʈ ´. 
	 *
	 * @param resource $result select   resource
	 * @return array ʵŸ Ʈ
	 */
	public function getFieldTypeList($result) {	
		return cubrid_column_types($result);
	}

	/**
	 *  select  ؼ fetch    (row) Ѵ. 
	 *
	 * ϵǴ  array('ʵ' => '', ...); ¸ . 
	 * 
	 * @param resource $result select   resource
	 * @return array row Ÿ 
	 */
	public function fetch($result) {
		return cubrid_fetch($result, CUBRID_ASSOC);
	}

	/**
	 * select  ؼ ¡ DBData Ѵ. 
	 *
	 * 
	 * @param string $query select 
	 * @param int $page    
	 * @param int $count  Ʈ  
	 * @param string $order_type   , order : order by  ¡, group : group by  ¡,  rownum ¡ 
	 * @param string $baseClass  DBData   Ŭ , ⺻ DBData  
	 * @return DBData
	 */
	public function getPageData($query, $page = 1, $count = 10, $order_type = 'order', $baseClass = 'DBData') {
		
		if (!in_array($order_type, array('order', 'group'))) { 
			die('order_type  ƲȽϴ.(order, group   ϳ ּ)');
		}
		

		//  ϱ 
		$start = ($page-1)*$count+1;
		$end = ($start+$count-1);

		if ($order_type == 'order') { 
			$query .= " for orderby_num() between {$start} and {$end} ";
		} else if ($order_type == 'group') { 
			$query .= " having groupby_num() between {$start} and {$end} ";			
		} else { 
			$query .= " and rownum between {$start} and {$end} ";
		}


		return $this->getData($query, false, $baseClass);
	}

	/**
	 *  Ÿ  ´ ڿ ǥ ش. 
	 *
	 * <code>
	 *  // '123'  ǥ 
	 *  echo $cubrid->getTypeConvert('char', '123');
	 * 
	 *  // 123  ǥ 
	 *  echo $cubrid->getTypeConvert('int', '123');
	 * </code>
	 * 
	 * @param string $type Ÿ ̸ 
	 * @param mixed $value ȯ  
	 * @return string 
	 */
	public function getTypeConvert($type, $value) { 
		$type = strtoupper($type);
		$str = $value;

		switch ($type) { 
			case 'CHAR':
			case 'VARCHAR':
			case 'STRING':
				$str = "'".$this->escape($str)."'";
				break;
			case 'NCHAR':
			case 'NCHAR VARYING':
				$str = "N'".$this->escape($str)."'";
				break;
			case 'BIT':
			case 'BIT VARYING':
				$str = "B'".$this->escape($str)."'";
				break;
			case 'NUMERIC':
			case 'DECIMAL':
			case 'INTEGER': 
			case 'INT': 
			case 'SMALLINT':
			case 'MONETARY':
				$str = intval($str);
				break;
			case 'FLOAT':
			case 'REAL':
			case 'DOUBLE PRECISION':
				$str = floatval($str);
				break;
			case 'DATE':
			case 'TIME':
			case 'TIMESTAMP':
				$str = "{$type}'".$this->escape($str)."'";
				break;
			case 'SET': 
			case 'MULTISET': 
			case 'LIST': 
			case 'SEQUENCE':
				$str = "{".$str."}";
				break;
			default :
				$str = "{$str}";
				break;
		}

		return $str;
	}


	/** 
	 * ο glo Ŭ  oid  
	 *
	 * @param string $class_name  cubrid Ŭ ̸ , Ϲ glo  ϴ. 
	 * @param string $file_name   ̸ 
	 * @return resource|bool   νϽ, ƴϸ false 
	 * @see Cubrid::loadGLO(),Cubrid::printGLO(),Cubrid::saveGLO()
	 */
	 public function newGLO($class_name, $file_name) { 
		return cubrid_new_glo($this->con, $class_name, $file_name);
	 }

	/** 
	 * glo νϽ ϴ file_name 
	 *
	 * @param string $file_name   ̸ 
	 * @param resource $oid  glo νϽ
	 * @return bool ϸ true, ϸ false 
	 * @see Cubrid::newGLO(),Cubrid::printGLO(),Cubrid::saveGLO()
	 */
	 public function loadGLO($file_name, $oid = '') { 
		return cubrid_load_from_glo($this->con, $this->getOID($oid), $file_name);
	 }

	/** 
	 * glo νϽ ǥ 
	 * 
	 * <code>
	 * // ̳ʸ ״ ȭ鿡  
	 * $cubrid->printGLO($glo);
	 *
	 * // gif ̹ ȭ鿡  
	 * $cubrid->printGLO($glo, 'image/gif');
	 * </code>
	 * 
	 * @param resource $oid  glo νϽ
	 * @param string $content_type  header  content-type 
	 * @return bool ϸ true, ϸ false 
	 * @see Cubrid::loadGLO(),Cubrid::newGLO(),Cubrid::saveGLO()
	 */
	 public function printGLO($oid = '', $content_type = '' ) {

		if ($content_type) { 
			header("Content-Type : {$content_type}");
		}

		return cubrid_send_glo($this->con, $this->getOID($oid));
	 }

	/** 
	 * glo νϽ  file_name ִ Ÿ ϱ 
	 *
	 * νϽ  ٲߴϴ.
	 * 
	 * @param string $file_name glo  ϸ 
	 * @param resource $oid glo νϽ 
	 * @return bool ϸ true, ϸ false 
	 * @see Cubrid::loadGLO(),Cubrid::printGLO(),Cubrid::newGLO()
	 */
	 public function saveGLO($file_name, $oid = '') { 
		return cubrid_save_to_glo($this->con, $this->getOID($oid), $file_name);
	 }


	/**
	 * ν 
	 * 
	 * @return bool ̸ true, ̸ false
	 */
	public function spExecute() {
	
		$output_count	= 0;
		$output_list	= array();

		// ڿ  
		$head = "call {$this->__sp_name}(";
		$temp = array();
		$var_init = array();
		$bind_init = array();

		// ε 
		foreach (array_keys($this->__sp_bind_list) as $key) { 

			// out, inout ̸ ʱⰪ  
			if ($this->__sp_bind_list[$key]['output'] == 'in') { 
				$bind_init[] = $this->__sp_bind_list[$key];
			} else { 

				$var_init[] = sprintf("select %s into %s from db_root;", 
											$this->getTypeConvert($this->__sp_bind_list[$key]['type'], $this->__sp_bind_list[$key]['value']), 
											$this->__sp_bind_list[$key]['name']
				);

			}

			// ν   
			if ($this->__sp_bind_list[$key]['output'] == 'in') { 
				$temp[]	= '?';
			} else {
				$temp[]	= $this->__sp_bind_list[$key]['name'];
			}

			// out, inout  ̸  
			if (in_array($this->__sp_bind_list[$key]['output'], array('out', 'inout'))) { 
				$output_list[] = $this->__sp_bind_list[$key]['name'];
			}
		}
		
		$head .= implode(",", $temp);

		$head .= ") ";


		// output   
		foreach ($var_init as $var_sql) { 
			$this->query($var_sql);
		}

		// ν  
		$this->__sp_statement = $this->prepare($head);

		// ε 
		foreach ($bind_init as $key => $value) { 

			$this->bind($this->__sp_statement, $key+1, $value['value'], $value['type']);
		}

		$this->__sp_execute_result = $this->query($this->__sp_statement);


		// output  ޱ 
		if (count($output_list) > 0 ) { 
			$sql = "select ".implode(",", $output_list). " from db_root ";
			$data = $this->getData($sql, true);

			foreach ($output_list as $output_var) { 
				$this->__sp_bind_list[$output_var]['value'] = $data->{$output_var};
			}
		}

		return true;

	
	}	
}

?>