<?php
import("php.lang.*");

class DateTimeSelect extends PObject {
	private $year;
	private $month;
	private $day;
	private $hour;
	private $minute;
	private $second;

	private $period = array();
	private $prefix = '';
	private $text = array();
	private $event = array();

	public function __construct($year= '', $month = '', $day = '', $hour = '', $minute = '', $second = '') {
		$this->set($year, $month, $day, $hour, $minute, $second);
		$this->setText('', '', '', '', '', '');
	}

	// ¥  
	public function set($year, $month, $day, $hour, $minute, $second){
		$this->year = $year;
		$this->month = $month;
		$this->day = $day;
		$this->hour = $hour;
		$this->minute = $minute;
		$this->second = $second;

		if ($year !== '')	{ $this->setPeriod('year', $year-5, $year+5, 1); }
		if ($month !== '')	{ $this->setPeriod('month', 1, 12, 1); }
		if ($day !== '')	{ $this->setPeriod('day', 1, date('t', mktime(0,0,0,$month,1,$year)), 1); }
		if ($hour !== '')	{ $this->setPeriod('hour', 0, 23, 1); }
		if ($minute !== '') { $this->setPeriod('minute', 0, 59, 1); }
		if ($second !== '') { $this->setPeriod('second', 0, 59, 1); }
	}

	public function format($str, $format = '%04d-%02d-%02d %02d:%02d:%02d')
	{
		sscanf($str, $format, $year, $month, $day, $hour, $minute, $second);

		$this->set($year, $month, $day, $hour, $minute, $second);
	}

	public function setPeriod($key, $start, $end, $add = 1) {
		$this->period[$key] = array('start'=>$start, 'end'=>$end, 'add' =>$add);
	}

	public function setText($year, $month, $day, $hour, $minute, $second) 
	{
		$this->text['year'] = $year;
		$this->text['month'] = $month;
		$this->text['day'] = $day;
		$this->text['hour'] = $hour;
		$this->text['minute'] = $minute;
		$this->text['second'] = $second;
	}
	
	// ̺Ʈ ߰ ϱ 
	public function setEvent($type, $event, $code) {
		$this->event[$type] = array($event, $code);
	}

	public function setPrefix($str) {
		$this->prefix = $str;
	}

	public function getSelect($key) {

		if (trim($this->{$key}) == '') {
			return "";
		}

		// select ± 
		$select = T_('select', true);
		$select->setAttribute(
			array(
				'name' => $this->prefix.$key,
				'id' => $this->prefix.$key."_id"
			)	
		);

		// ̺Ʈ ߰
		if($this->event[$key]) {
			$select->addAttribute($this->event[$key][0], $this->event[$key][1]);
		}

		// option ±  
		for ($i = $this->period[$key]['start']; $i <= $this->period[$key]['end']; $i += $this->period[$key]['add']) {
			$option = T_('option', true);
			$option->addAttribute('value', sprintf("%02d",$i));

			if ($this->{$key} == $i) {
				$option->addAttribute('selected', 'selected');
			}

			$option->add(sprintf("%02d", $i));

			$select->add($option);
		}

		return $select->toString()." ".$this->text[$key];
	}

	public function toString() {
		$arr = array();

		$arr[] = $this->getSelect('year');
		$arr[] = $this->getSelect('month');
		$arr[] = $this->getSelect('day');
		$arr[] = $this->getSelect('hour');
		$arr[] = $this->getSelect('minute');
		$arr[] = $this->getSelect('second');

		return implode(" ", $arr);
	}
}

?>