<?php

import("php.parser.tag.AbstractTag");
import("php.db.*");
import("php.db.info.*");

class ViewTag extends AbstractTag { 
	public function __construct($obj) {
		parent::__construct($obj);
	}

	/*
	 *  ̿Ͽ ĽϿ  Ӽ  Ѵ. 
	 *
	 *  view server:127.0.0.1  
	 *  view service:127.0.0.1 list
	 *  view service:DB̸  
	 *  view db:DB̸  (proc|table|view|function)
	 *  view mcode:ڵ̸ (string|select)
	 */
	public function parseAttribute() { 
		$attribute	= explode(" ", $this->get('attribute'));
		$arr		= explode(":", $attribute[0]);
		$protocol	= strtolower($arr[0]);

		$this->setAttribute('view_type', $attribute[1]);

		switch($protocol)  {
			case "server":		// 
				$this->setAttribute('protocol',		$protocol);				
				$this->setAttribute('ip',			$arr[1]);
				break;
			case "service":		// 
				$this->setAttribute('protocol',		$protocol);
				$this->setAttribute('service_type', $arr[1]);
				break;
			case "db":			// 
				$this->setAttribute('protocol',		$protocol);
				$this->setAttribute('service_type', $arr[1]);
				break;				
			case "proc":		// ν
				break;
			case "table":		// ̺
				$this->setAttribute('protocol',		$protocol);
				$this->setAttribute('service_type', $arr[1]);
				$this->setAttribute('table_name',	$arr[2]);
				break;
			case "function":	// Լ
				break;
			case "view":		// 
				break;
			case "mcode":		// ڵ
				$this->setAttribute('protocol',		$protocol);
				$this->setAttribute('service_type', $attribute[0]);

				if (!$this->get('view_type')) 
					$this->set('view_type', 'string');
				break;
		}

	}

	//  Ľ 
	public function parseDescription() { 
		$protocol = $this->getAttribute('protocol');

		switch($protocol)  {
			case "server": 
			case "service": 
			case "db": 
			case "proc": 
			case "table": 
			case "function": 
			case "view": 
			case "mcode": 
				$temp = "get".ucwords($protocol);
				$str = call_user_method($temp, $this);
				break;
			default : 
				$str = $this->get('description');
				break;
		}

	   $this->set('convert', $str);
	}

	//  ȯ
	public function getServer() { 
		$ip = $this->getAttribute('ip');
		
		$db = DBClient::createConnector('mysql', 'project');
		$db->connect();

		$data = $db->getData("select * from servers where ip = '{$ip}'", true);

		$data->setDatabase(null);
		$str = $data;
		
		$db->close();

		return $str;
	}

	//  ȯ
	public function getService() { 
		$service_type	= $this->getAttribute('service_type');
		$view_type		= $this->getAttribute('view_type');
		
		$db = DBClient::createConnector('mysql', 'project');
		$db->connect();

		if ($view_type == 'list') { 
			$server_num = $db->getData("select num from servers where ip = '{$service_type}'", true)->num;
			$data = $db->getData("select * from services where servers_num = '{$server_num}'", true);
		} else { 
			$data = new Data($db, 'services');
			$data->select(" name = '{$service_type}' ", true);
		}

		$data->setDatabase(null);
		$str = $data;

		$db->close();

		return $str;
	}

	public function getDb() { 
		$service_type	= $this->getAttribute('service_type');
		$view_type		= $this->getAttribute('view_type');

		$db = DBClient::createConnector('mysql', 'project');
		$db->connect();

		if ($view_type) { 
			$table_list = array(
				'table'		=> 'tables',	
				'proc'		=> 'proces',	
				'view'		=> 'views',	
				'function'	=> 'functions'
			);

			$service_data = new ServiceData($db, 'services');
			$service_data->select(" name = '{$service_type}' ", true);

			$db2 = $service_data->createConnector();

			// ̺ Ʈ 
			$method_type = ucwords($view_type);
			$method = "get{$method_type}Data";
			$data2 = call_user_method($method, $db2);

			//  ü ̸  
			$obj = new Data($db, $table_list[$view_type]);
			$obj->select(" services_num = {$service_data->num}");

			// 迭 
			$arr = $obj->getColumnList('name2', 'name');

			// ʵ ߰
			$data2->addField('name2');

			//  ̸ 
			while($data2->next()) { 
				$data2->name2 = $arr[$data2->name];
			}

			$data2->init();
			$data2->setDatabase(null);
			$str = $data2;

			$db2->close();
		} else { 
			$data = new Data($db, 'services');
			$data->select(" name = '{$service_type}' and service_type= 'DB' ", true);

			$str = $data;
		}

		$db->close();

		return $str;
	}

	// ̺  
	public function getTable() { 
		$service_type	= $this->getAttribute('service_type');
		$view_type		= $this->getAttribute('view_type');
		$table_name		= $this->getAttribute('table_name');

		$db = DBClient::createConnector('mysql', 'project');
		$db->connect();

		if ($view_type == "field") { 
			$data = new ServiceData($db, 'services');
			$data->select(" name = '{$service_type}' and service_type= 'DB' ", true);

			$table_data = new TableData($db, 'tables');
			$table_data->select(" services_num = {$data->num} and name = '{$table_name}'", true);

			if (!$table_data->isEmpty()) { 
				// ʵ ȯ
				$field_list = $table_data->field_list;
				$value_list = $table_data->value_list;
			} else { 
				$field_list = array();
				$value_list = array();
			}

			// ÷ Ÿ 
			$db2 = $data->createConnector();

			$field_data = $db2->getColumnData($table_name);
			$field_data->addField("example");

			while($field_data->next()) { 
				if (trim($field_data->column_comment) == '' ) {
					$field_data->column_comment = $field_list[$field_data->column_name];	
				} 

				$field_data->example = CodeData::getCodeString($db, $value_list[$field_data->column_name]);
			}

			$field_data->init();

			$db2->close();

			$str = $field_data->toDataTable(array('column_name','column_comment','data_type', 'data_length', 'example'));
		}

		$db->close();

		return $str;
	}

	// ڵ ν (̺ )
	public function getMcode() { 
		$service_type	= $this->getAttribute('service_type');
		$view_type		= $this->getAttribute('view_type');

		$db = DBClient::createConnector('mysql', 'project');
		$db->connect();

		if ($view_type == 'string') { 
			$str = CodeData::getCodeString($db, $service_type);
		} else { 
			$str = CodeData::getCode($db, $service_type, $service_type);
		}

		$db->close();

		return $str;
	}

}


?>