<?php

import("php.parser.tag.AbstractTag");

class LinkTag extends AbstractTag { 
	public function __construct($obj) {
		parent::__construct($obj);
	}

	/*
	 *  ̿Ͽ ĽϿ  ü  Ѵ. 
	 */
	public function parseAttribute() { 
		$attribute	= explode(" ", $this->get('attribute'));
		$arr		= explode(":", $attribute[0]);
		$protocol	= strtolower($arr[0]);

		switch($protocol) {
			case "server":
			case "service": 
			case "db": 
			case "table": 
			case "proc": 
			case "view": 
			case "function": 
			case "http":
			case "ftp":
				$this->setAttribute('protocol', $protocol);
				$this->setAttribute('link',		$attribute[0]);
				$this->setAttribute('title',	$attribute[1]);

				break;
		}

	}

	public function parseDescription() { 
		switch($this->getAttribute('protocol')) {
			case "server":
			case "service": 
			case "db": 
			case "table": 
			case "proc": 
			case "view": 
			case "function": 
				$title = $this->getAttribute('link');
				$link = "/link/move.mgame?protocol=".$title;
				$str = "<a href='{$link}'>{$title}</a>";
				break;
			case "http" :
			case "ftp":
				$title = ($this->getAttribute('title')) ? $this->getAttribute('title') : $this->getAttribute('link');
				$link = $this->getAttribute('link');
				$str = "<a href='{$link}'>{$title}</a>";
				break;
		}

	   $this->set('convert', $str);
	}
}


?>