<?

import("php.db.Data");

class OpenApiData extends Data { 
	private $_attribute = array();

	public function __construct() { 
		parent::__construct(null);
	}

	public function getAttribute($key) { 
		$str = $this->_attribute[strtolower($key)];

		return $str;
	}

	public function setAttribute($key, $value) { 
		$this->_attribute[strtolower($key)] = $value;
	}

	/**
	 * 
	 * Ӽ   attr  prefix ָ OpenApiData ü attribute ǹѴ.
	 * ƴҶ Data ü ü ʵ  ǹѴ.
	 *
	 * @override
	 */
	public function __get($key) { 
		$key = strtolower($key);
		$temp = explode("_", $key);

		if ($temp[0] == 'attr') { 
			array_shift($temp);
			$var_name = implode("_", $temp);

			return $this->getAttribute($var_name);
		} else { 
			return parent::__get($key);
		}
	}

	/**
	 *
	 * Ӽ   attr  prefix ָ OpenApiData ü attribute ǹѴ.
	 * ƴҶ Data ü ü ʵ  ǹѴ.
	 *
	 * @override
	 */
	public function __set($key, $value) { 
		$key = strtolower($key);
		$temp = explode("_", $key);

		if ($temp[0] == 'attr') { 
			array_shift($temp);
			$var_name = implode("_", $temp);
			$this->setAttribute($var_name, $value);
		} else { 
			parent::__set($key, $value);
		}
	}

	/**
	 *
	 * @override
	 */
	public function toString($fields = array(), $names = array()) { 
	
		//    
		$str = parent::toString($fields, $names);

		// ̺  
		$table = T_('table', true);
		$table->addAttribute('border', '1');

		$tr = T_('tr', true);
		$tr->add(T_('th', true)->add('attribute'));	
		$tr->add(T_('th', true)->add('description'));	

		$table->add($tr);
		
		foreach ($this->_attribute as $key => $value) { 
			$tr = T_('tr', true);
			$tr->add(T_('td', true)->add($key));	
			$tr->add(T_('td', true)->add($value));	

			$table->add($tr);
		}

		$tr = T_('tr', true);
		$td = T_('td', true)->addAttribute('colspan', '2')->add($str);
		$tr->add($td);

		$table->add($tr);

		return $table->toString();
	}
}

?>