<?php

import("php.db.migration.TableSpec");

class OracleTableSpec extends TableSpec { 
	
	public function __construct($db = '', $table = '', $field = null, $option = null, $index = null) { 
		parent::__construct('ORACLE', $db, $table, $field, $option, $index);
	}

	protected function getColumnName() { 
		$column_name	= strtolower($this->field->column_name);

		$column_name	= str_replace(" ", "_", $column_name);
		$column_name	= str_replace(".", "_", $column_name);

		return $column_name;
	}

	protected function getDataType() { 
		if ($this->db == $this->convert_db) { 
			$data_type		= $this->field->data_type;
		} else  {
			$data_type		= TypeConvert::getRealType($this->convert_db, $this->field->meta_type);
			$type_list		= array_values($data_type);
			$type_list		= array_map('strtoupper', $type_list);

			$data_type		= ($type_list[0]) ? $type_list[0] : $type_list[1];
			$data_type		= ($data_type == 'ETC') ? 'VARCHAR2' : $data_type;
		}

		return $data_type;
	}

	protected function getTypeLength($data_type) { 
		switch($data_type) { 
			case 'NUMBER' : 
				return sprintf("(%01d,%01d)",	$this->field->data_prec,	$this->field->data_scale);
				break;
			case 'CHAR':
			case 'VARCHAR2':
				return sprintf("(%01d)",		$this->field->data_length);
				break;
		}
	
		return "";
	}

	protected function getNotNull() { 
		return ($this->field->isnull == '') ? 'NOT NULL': '';
	}


	protected function getColumnDefault($data_type) { 

		if (!$this->field->column_default) { 
			return "";
		}

		switch($data_type) { 
			case 'NUMBER':
				return sprintf("DEFAULT %01d",		$this->field->column_default);
				break;
			case 'CHAR':
			case 'VARCHAR2':
				return sprintf("DEFAULT '%1s'",	$this->field->column_default);
				break;
			default:
				return sprintf("DEFAULT %s",		$this->field->column_default);
				break;
		}

		return "";
	}

	protected function getIsAuto() { 
		return "";
	}

	protected function createHeader() {
		return $this->table;
	}

	protected function createOption() {}

	protected function createIndex() {}

	protected function createConstraints() {}

}


?>