<?php
import("php.db.DBClient");
import("php.db.OracleConfig");

class Oracle extends DBClient { 

	private $tempStmt;

	private $cursor = array();
	private $bindList = array();
	private $defineList = array();

	public function __construct($host = '', $port = '', $id = '', $pass = '', $db = '', $schema = '', $version = '') {
		$program		= strtoupper(__CLASS__);
		parent::__construct($program, $host, $port, $id, $pass, $db, $schema, $version);
	}

	public function _connect() {
		// 10g 
		if ($this->version == '10') { 
			$sid = sprintf("//%s/%s", $this->getAttribute('host'), $this->getAttribute('db'));
		} else { 
			$sid = $this->getAttribute('db');
		}

		return oci_connect($this->getAttribute('id'), $this->getAttribute('pass'), $sid);
	}

	public function _selectDb() { 
		return true;
	}

	public function close() {
		oci_close($this->con);
	}

	public function free($result) { 
		return $this->freeStatement($result);
	}

	public function error() {
		$arr = oci_error();

		return $arr['message'];
	}

	public function execute($mode = OCI_DEFAULT) {
		$this->exec = oci_execute($this->stmt, $mode);
	}

	public function parse($query) {
		$this->stmt = oci_parse($this->con, $query);
	}

	// Ϲ   
	public function query($query, $isCommit = true, $args = array()) {
		$this->parse($query);


		foreach ($args as $key => $value) { 
			$this->bind($key, $value);
		}

		$this->execute();

		if ($isCommit) {
			$this->commit();
		}
	}

	public function getResult() { 
		return $this->stmt;
	}

	public function insertSql(DBData $data) { 
		$tempSql = parent::insertSql($data);

		$field = $data->getTable()."_SEQ.NEXTVAL";

		$tempSql->add('NUM', $field, false);

//		echo $tempSql;

		return $tempSql;
	}

	public function getFieldCount($stmt) {
		return oci_num_fields($stmt);
	}

	public function getFieldName($stmt, $i) {
		return oci_field_name($stmt, $i+1);
	}

	public function getFieldType($stmt, $i) {
		return oci_field_type($stmt, $i+1);
	}

	public function commit() {
		return oci_commit($this->con);
	}

	public function rollback() {
		return oci_rollback($this->con);
	}

	public function define($column, $var, $type) {
		return oci_define_by_name($this->stmt, $column, $var, $type);
	}

	public function bind($param, $var, $maxlength = -1, $type = '') {
		if ($type == '') {
			return oci_bind_by_name($this->stmt, $param, $var, $maxlength);
		} else {
			return oci_bind_by_name($this->stmt, $param, $var, $maxlength, $type);
		}
	}

	public function newCursor($name) {
		$this->cursor[$name] = oci_new_cursor($this->con);
	}

	public function fetch($stmt) {
		return oci_fetch_assoc($stmt);
	}

	private function saveStatement() {
		$this->tempStmt = $this->stmt;
		$this->stmt = $this->cursor;
	}

	private function returnStatement() {
		$this->stmt = $this->tempStmt;
	}

	public function freeStatement($stmt = null) {
		return oci_free_statement(($stmt == null) ? $this->stmt: $stmt);
	}

	// Data Ŭ  
	function getData($query, $isOne = false, $baseClass = "DBData") 
	{

		$this->parse($query);
		$this->execute();

		return $this->getBindData($isOne, $baseClass);
	} 

	// ε  Ÿ 
	function getBindData($isOne = false, $baseClass = "DBData") {

		$data = $this->createData($this->getResult(), $baseClass);

		//   ¥ true
		// true ̸ next ٷ  · Ѿ´. 
		if ($isOne) 
			$data->next();

		return $data;
	}

	// Ŀ Ÿ 
	function getCursorData($name, $isOne = false, $baseClass = 'DBData' ) {

		$data = $this->createData($this->cursor[$name], $baseClass);

		//   ¥ true
		// true ̸ next ٷ  · Ѿ´. 
		if ($isOne) 
			$data->next();

		return $data;
	}

	public function getPageData($query, $page, $count = 10,$baseClass = 'DBData') {

		//  ϱ 
		$start = ($page-1)*$count+1;
		$end = $start + $count-1;

		$sql = " SELECT * FROM ( SELECT a.*, RowNum as rNum FROM ( $query ) a WHERE RowNum <= $end ) WHERE $start <= rNum";

		return $this->getData($sql, false, $baseClass);
	}

}

?>