<?php
import("php.db.Mysql");

class Mysql_i extends Mysql {

	private $mysqli;

	public function __construct($host = '', $port = '', $id = '', $pass = '', $db = '', $schema = '', $version = '') {
		parent::__construct($host, $port, $id, $pass, $db, $schema, $version);
	}

	/**
	 * @override 
	 */
	public function error() {
		return $this->mysqli->error;
	}

	/**
	 * @override 
	 */
	protected function _connect() { 
		$this->mysqli = new mysqli(
					$this->getAttribute('host'), 
					$this->getAttribute('id'), 
					$this->getAttribute('pass'),
					$this->getAttribute('db')
		);

		return true;
	}

	/**
	 * @override 
	 */
	protected function _selectDb() { 
		return true;
	}

	/**
	 * @override 
	 */
	public function close()
	{
		$this->mysqli->close();
	}

	/**
	 * @override 
	 */
	public function free($result) {
		if ($result) { 
			return $result->free();
		} 

		return false;
	}

	public function affectedRows() { 
		return $this->mysqli->affected_rows();
	}

	public function escape($str) { 
		return $this->mysqli->real_escape_string($str);
	}

	/**
	 * @override 
	 */
	public function query($sql) {
		$this->result = $this->mysqli->query($sql);
		
		return $this->result;
	}

	public function prepare($sql) { 
		$this->result = $this->mysqli->prepare($sql);
		
		return $this->result;
	}

	public function bind() { 
		$arr = func_get_args();

		return call_user_func_array(array($this->getResult(), 'bind_param'), $arr);
	}

	public function bindResult() { 
		$arr = func_get_args();

		return call_user_func_array(array($this->getResult(), 'bind_result'), $arr);
	}

	/**
	 * @override 
	 */
	public function getFieldCount($result) {
		return $result->field_count;
	}

	/**
	 * @override 
	 */
	public function getFieldName($result, $i) {
		$arr = $this->fetchField($result);

		return $arr[$i]->name;
	}

	public function fetchField($result, $attribute = 'name') { 
		$arr = array();

	    while ($finfo = $result->fetch_field()) {
			$arr[] = $finfo->{$attribute};
	    }

		return $arr;		
	}

	/**
	 * @override 
	 */
	public function getFieldList($result) { 
		return $this->fetchField($result, 'name');
	}

	/**
	 * @override 
	 */
	public function getFieldType($result, $i) { 
		$arr = $this->getFieldTypeList($result);

		return $arr[$i];
	}

	/**
	 * @override 
	 */
	public function getFieldTypeList($result) {
		return $this->fetchField($result, 'type');
	}

	// Ÿ  
	public function fetch($result) {
		return $result->fetch_assoc();
	}

}

?>