<?php

/**
 * @package php.db
 */

/**
 * @import php.lang.Tag
 * @import php.db.Sql
 * @import php.net.IConnector
 */
import("php.lang.Tag");

/**
 * Data Ŭ 
 *
 * @name Data 
 * @version 1.0
 */
class Data extends PObject implements ArrayAccess {

	/**
	 * Connector ()
	 *
	 * @access	protected
	 * @name	$connector
	 * @var		object
	 */
	protected $connector;

	/**
	 * Data Ŭ  Ŭ ̸
	 *
	 * @access	protected
	 * @name	$baseClass
	 * @var		string		
	 */
	protected $baseClass;

	/**
	 * data  
	 *
	 * @access	protected
	 * @name	$listCount
	 * @var		integer	
	 */
	protected $listCount;			

	/**
	 * ʵ ̸ 迭
	 *
	 * @access	protected
	 * @name	$fields
	 * @var		array
	 */
	protected $fields = array();

	/**
	 * row Ÿ 迭
	 *
	 * @access	protected
	 * @name	$row
	 * @var		array
	 */
	protected $row = array();

	/**
	 * row Ÿ Ű index
	 *
	 * @access	private
	 * @name	$index
	 * @var		int
	 */
	private $index;

	/**
	 * row Ÿ Ű temp index
	 *
	 * @access	private
	 * @name	$tempIndex
	 * @var		int
	 */
	private $tempIndex;

	/**
	 * 
	 *
	 * @construct
	 * @access	public
	 * @name	__construct
	 * @param	$connector	IConnector  
	 */
	public function __construct($connector = null)
	{
		$this->listCount = 0;

		$this->setIndex(-1);
		$this->setConnector($connector);
	}

	/**
	 *  
	 *
	 * @access	public
	 * @name	setConnector
	 * @param	$connector	IConnector  
	 * @return	void 
	 */
	public function setConnector($connector) {
		$this->connector = $connector;
	}

	/**
	 *  ϱ 
	 *
	 * @access	public
	 * @name	getConnector
	 * @return	IConnector 
	 */
	public function getConnector() { 
		return $this->connector;
	}

	/**
	 * Ʈ  0  üũ 
	 *
	 * @access	public
	 * @name	isEmpty
	 * @return	boolean		true :  , false : Ÿ 1 ̻ 
	 */
	public function isEmpty(){
		return ($this->listCount == 0);
	}

	/**
	 *  ڵ ,  false 
	 *
	 * @access	public
	 * @name	next
	 * @return	boolean		true : Ÿ , false :  Ÿ  
	 */
	public function next()
	{
		if ($this->index >= $this->listCount-1) {
			$this->index = $this->listCount;	
			return false;
		}

		$this->index++;

		return true;
	}

	/**
	 *  ڵ  ,  false  
	 *
	 * @access	public
	 * @name	prev
	 * @return	boolean		true :  Ÿ , false :  Ÿ  
	 */
	public function prev()
	{
		if ($this->index > -1) {
			$this->index--;
			
			return true;
		}

		return false;
	}

	/**
	 * ε -1 ʱȭ.
	 *
	 * @access	public
	 * @name	init()
	 * @return	void
	 */
	public function init()
	{
		$this->setIndex(-1);
	}

	/**
	 *  ε ϱ 
	 *
	 * @access	public
	 * @name	getIndex()
	 * @return	int
	 */
	public function getIndex()
	{
		return $this->index;
	}

	/**
	 *  ε ϱ
	 *
	 * @access	public
	 * @name	setIndex()
	 * @param	$index	int		 ε  
	 * @return	int
	 */
	public function setIndex($index)
	{
		$this->index = $index;
		return $this;
	}
	
	/**
	 *  ε ӽ ε ȣ ϰ, ε ʱȭѴ. 
	 *
	 * @access	public
	 * @name	saveIndex()
	 * @return	void
	 */
	public function saveIndex()
	{
		$this->tempIndex = $this->getIndex();
		$this->init();
	}

	/**
	 * ӽ ε 
	 *
	 * @access	public
	 * @name	returnIndex()
	 * @return	void
	 */
	public function returnIndex()
	{
		$this->setIndex($this->tempIndex);
	}

	/* php 5.0  */
	/**
	 * get() ޼ҵ  ޼ҵ
	 * ٸ ü Ӽó    ְ ش. (php5 ̻ ȴ.) 
	 *
	 * ex) $data = new Data(); 
	 *     while($data->next()) { 
	 *        echo $data->name;
	 *     }
	 *
	 *     //   ڵ name ̶ public Ӽ   __get ޼ҵ带 ȣѴ. 
	 *     // __get ޼ҵ ٽ get ޼ҵ带 ȣϰ Ϸ ʵ   ϴ.
	 * 
	 * @access	public
	 * @name	__get()
	 * @param	$key	string	˻ ʵ尪, ҹ   
	 * @return	mixed
	 * @since	php5 or later 
	 */
	public function __get($key)
	{
		return $this->get($key);
	}

	/*
	 * ʵ  Ѵ. set ޼ҵ   
	 *
	 * @access	public
	 * @name	__set()
	 * @param	$key	string	˻ ʵ尪, ҹ   
	 * @param	$value	mixed	 
	 * @return	void
	 * @since	php5 or later 
	 */
	public function __set($key, $value)
	{
		$this->set($key, $value);
	}

	/*
	 *  ε شϴ row ʵ   ´. 
	 *
	 * @access	public
	 * @name	get()
	 * @param	$key		string	˻ ʵ̸, ʵ̸ ҹڸ  ʴ´. 
	 * @param	$default	mixed	ʵ尡 ų ʵ忡   $default  ش. 
	 * @return	mixed
	 */
	public function get($key, $default = '')
	{

		if ($this->index == -1 || $this->index == $this->listCount) {
			return $default;
		}

		$key = $this->filterKey($key);
		$data = $this->row[$this->index][$key];

		if (is_null($data)) return $data;
		if (is_numeric($data)) return $data;

		return ($data) ? $data : $default;
	}

	/*
	 *  ε شϴ row ʵ  Ѵ. 
	 *
	 * @access	public
	 * @name	set()
	 * @param	$key	string	˻ ʵ̸, ʵ̸ ҹڸ  ʴ´. 
	 * @param	$value	mixed	 ʵ 
	 * @return	void
	 */
	public function set($key, $value)
	{
		$key = $this->filterKey($key);
		$this->row[$this->index][$key] = $value;
	}

	/*
	 *  ε شϴ row  ´.
	 *
	 * @access	public
	 * @name	gets()
	 * @return	array
	 */
	public function gets()
	{
		return $this->getRow($this->index);
	}

	/*
	 * ó row  ´.
	 *
	 * @access	public
	 * @name	getFirst()
	 * @return	array
	 */
	public function getFirst() { 
		return $this->getRow(0);
	}

	/*
	 *  row  ´.
	 *
	 * @access	public
	 * @name	getLast()
	 * @return	array
	 */
	public function getLast() { 
		return $this->getRow($this->listCount-1);
	}

	public function moveFirst() { 
		$this->setIndex(0);
	}

	public function moveLast() { 
		$this->setIndex($this->getListCount() - 1);
	}

	/**
	 * ε ġ ó  
	 *
	 */
	public function isFirst() { 
		return ($this->getIndex() == 0);
	}

	/**
	 * ε ġ   
	 *
	 */
	public function isLast() { 
		return ($this->getListCount()-1 == $this->getIndex());
	}

	/**
	 * ε ġ ʱȭ   
	 *
	 */
	public function isInit() { 
		return ($this->getIndex() == -1);
	}

	/*
	 * ʵ̸ ͸
	 *
	 * @access	public
	 * @name	filterKey()
	 * @param	$key	string	ȯ ʵ ̸ 
	 * @return	string
	 */
	protected function filterKey($key) {
		return strtolower($key);
	}
	
	/*
	 * ش ε row  
	 *
	 * @access	public
	 * @name	getRow()
	 * @param	$index	int	 ε 
	 * @return	array
	 */
	public function getRow($index){
		return $this->row[$index];
	}

	/*
	 * data  ִ  row  Ѵ. 
	 *
	 * @access	public
	 * @name	getRows()
	 * @return	array
	 */
	public function getRows()
	{
		return $this->row;
	}


	// Ư Լ Ͽ  
	public function loop($function, array $field_list) { 
		$this->saveIndex();

		while($this->next()) { 
			foreach ($field_list as $field) { 
				$this->set($field, $function($this->get($field)));
			}
		}

		$this->returnIndex();
	}

	/*
	public function customLoop($function, array $field_list, array $arg_list) { 

	}
	*/


	/*
	 * data  ִ  row  Ѵ.
	 *
	 * @access	public
	 * @name	setRows()
	 * @param	$rows	array	 Ÿ  迭
	 * @return	void
	 */
	public function setRows(array $rows)
	{

		/*
		foreach ($rows as &$row) { 
			$row = array_change_key_case($row, CASE_LOWER);
		}

		print_r($rows);
		*/

		$this->row = $rows;
		$this->listCount = count($this->row);
	}

	/*
	 * row Ÿ ߰ϱ 
	 *
	 * @access	public
	 * @name	add()
	 * @param	$arr	array	 Ÿ  迭
	 * @return	void
	 */
	public function add(array $arr)
	{
		$index = $this->listCount;

		// ӽ ε 
		$this->saveIndex();

		//    
		$this->row[$index] = array(); 

		// ε  ϰ 
		$this->setIndex($index);

		// ε ϸ  ..
		$arr = $this->map($arr);
		foreach ($this->fields as $field) {
			$this->set($field, $arr[$field]);
		}

		// Ʈ īƮ  
		$this->listCount++;

		//  ε  
		$this->returnIndex();
	}

	/*
	 * row Ÿ ε
	 *
	 * @access	public
	 * @name	bind()
	 * @param	$arr	array	 Ÿ  迭
	 * @param	$omit	array	ε    迭 
	 * @return	void
	 */
	public function bind($arr, $omit = array('num')) {
		$arr = $this->map($arr);
		$omit = array_map('strtolower', $omit);

		$keys = array_keys($arr);

		foreach ($this->fields as $field) {
			
			// ʵ  ߿ arr Ű  ε  ʴ´. 
			if (!in_array($field, $keys)) { 
				continue;
			}

			// ε ʵ忡 
			if (in_array($field, $omit)) { 
				continue;
			}

			$this->set($field, $arr[$field]);
		}
	}

	/*
	 * row  Ÿ Ű ϰ ҹڷ ٲش.
	 *
	 * @access	protected
	 * @name	map()
	 * @param	$arr	array	 Ÿ  迭
	 * @return	array	
	 */
	protected function map(array $arr) {
		return array_change_key_case($arr, CASE_LOWER);
	}

	/* 
	 * ʵ ̸ ٲٱ 
	 *
	 * Ű : array('ʵ' => 'ʵ');
	 *
	 *  :  $data->convertField(array('A' => '', 'B' => ''));
	 *
	 * @access	public 
	 * @name	convertField()
	 * @param	$field_list	array	ٲ ʵ 
	 * @return	void	
	 */
	public function convertField($field_list = array()) { 
		$keys		= array_values($field_list);
		$temp_keys	= array_keys($field_list);

		$this->saveIndex();

		while($this->next()) { 
			foreach ($temp_keys as $key) {
				$this->set($field_list[$key], $this->get($key));
				$this->dropData($key);
			}
		}

		foreach ($this->fields as &$key) { 
			$key = (array_key_exists ( $key, $field_list)) ? $field_list[$key] : $key;
		}

		$this->returnIndex();
	}

	/**
	 * ʵ Ÿ  
	 *
	 *  Ÿ 迭 ܵ˴ϴ. 
	 *
	 * @access	protected
	 * @name	dropData()
	 * @param	$key	string	ٲ ʵ 
	 * @return	void	
	 */
	protected function dropData($key) { 
		unset($this->row[$this->index][$key]);
	}

	/**
	 * ʵ  
	 *
	 * 迭 ܵ˴ϴ. 
	 *
	 * @access	protected
	 * @name	dropField()
	 * @param	$key	int		ٲ ʵ ε 
	 * @return	void	
	 */
	protected function dropField($key) { 
		unset($this->fields[$key]);
	}

	/**
	 * ʵ Ʈ ߰
	 *
	 * @access	public
	 * @name	addField()
	 * @param	$key	string	߰ ʵ
	 * @return	void	
	 */
	public function addField($key) {
		$this->fields[] = strtolower($key);
	}

	/**
	 * ʵ Ʈ 
	 *
	 * @access	public
	 * @name	setFields()
	 * @param	$arr	array	߰ ʵ
	 * @return	void	
	 */
	public function setFields($arr)
	{
		$this->fields = array_map('strtolower',$arr);
	}

	/**
	 * ʵ Ʈ 
	 *
	 * @access	public
	 * @name	getFields()
	 * @return	array		ʵ Ʈ 迭 
	 */
	public function getFields()
	{
		return $this->fields;
	}

	/**
	 * ⺻ Ŭ  
	 *
	 * @access	public
	 * @name	setBaseClass()
	 * @param	$class	string	⺻ Ŭ
	 * @return	void	
	 */
	public function setBaseClass($class)
	{
		$this->baseClass = $class;
	}

	/**
	 * ü row   
	 *
	 * @access	public
	 * @name	getListCount()
	 * @return	int			row  
	 */
	public function getListCount()
	{
		return $this->listCount;
	}

	/**
	 * ü ʵ   
	 *
	 * @access	public
	 * @name	getFieldCount()
	 * @return	int			ʵ  
	 */
	public function getFieldCount()
	{
		return count($this->fields);
	}

	/**
	 * column   迭 ϱ
	 *
	 * ex) 1. 1 迭    
	 * 
	 * 			$data->getColumnList('ʵ');    
	 * 
	 * 	   ʵ شǴ column   迭 ݴϴ.
	 * 
	 * 	   2.  迭  
	 *
	 *			$data->getColumnList('ʵ', 'key ʵ');    
	 *
	 *		array('keyʵ' => 'ʵ', ...... )  迭 ݴϴ.
	 *
	 * @access	public
	 * @name	getColumnList()
	 * @param	$field	string	 ʵ
	 * @param	$key	string	key ʵ, ⺻ ''
	 * @return	int			ʵ  
	 */
	public function getColumnList($field, $key = '') {
		// Ÿ  
		$this->saveIndex();

		$temp = array();

		while($this->next()) {
			if ($key) { 
				$temp[$this->get($key)] = $this->get($field);
			} else { 
				$temp[] = $this->get($field);
			}
		}

		// ε ֱ 
		$this->returnIndex();

		return $temp;
	}

	// ߺ  Ʈ  
	public function distinct($field) { 
		$temp_list = array();

		$this->saveIndex();

		while($this->next()) { 
			$temp_list[trim($this->get($field))] = $this->get($field);
		}

		$this->returnIndex();

		$temp_list = array_keys($temp_list);

		return $temp_list;
	}


	/**
	 *  Dataü  ˻   Data ü  
	 *
	 * ex)  $new_data = $data->find('ʵ', '');
	 *      echo $new_data;
	 *
	 * @access	public
	 * @name	find()
	 * @param	$field	string	˻ ʵ
	 * @param	$value	string	˻ 
	 * @return	php.db.Data 			
	 *
	 */
	public function find($field, $value) { 
		$this->saveIndex();

		$data = new Data($this->getConnector());
		$data->setFields($this->getFields());

		while($this->next()) { 
			if ($this->get($field) == $value) { 
				$data->add($this->gets());
			}
		}

		$this->returnIndex();

		return $data;
	}

	/**
	 *  ϴ ʵθ Ÿ  
	 *
	 * ex)  $new_data = $data->column(array('ʵ1', 'ʵ2','ʵ3'));
	 *      echo $new_data;
	 *
	 * @access	public
	 * @name	column()
	 * @param	$field_list	array	и ʵ Ʈ 
	 * @return	php.db.Data 			
	 *
	 */
    public function column() { 

		// ʵ Ʈ   
		$field_list = func_get_args();

		$this->saveIndex();

		$field_list = array_map('strtolower', $field_list);

		$field_list = (count($field_list) == 0) ? $this->getFields() : $field_list;

		$data = new Data($this->getConnector());
		$data->setFields($field_list);

		while($this->next()) { 
			$arr = array();
			foreach ($field_list as $field) { 
				$arr[$field] = $this->get($field);
			}

			$data->add($arr);
		}

		$this->returnIndex();

		return $data;
	}

	/**
	 *   Data 
	 *
	 * ex)  $new_data = $data->top(5);		//  5 
	 *      echo $new_data;
	 *
	 * @access	public
	 * @name	top()
	 * @param	$count	int		  
	 * @return	php.db.Data 			
	 *
	 */
	public function top($count) { 
		return $this->page(1, $count);
	}

	/** 
	 * Page ȭ  Data  
	 *
	 * ex)  $new_data = $data->page(1, 10);		//    10,   1 
	 *      echo $new_data;
	 *
	 * @access	public
	 * @name	page()
	 * @param	$page		int		 
	 * @param	$page_size	int		   
	 * @return	php.db.Data 			
	 *
	 */
	public function page($page = 1, $page_size = 10) { 

		$this->saveIndex();

		$data = new Data($this->getConnector());
		$data->setFields($this->getFields());

		$start = ($page - 1)*$page_size - 1;		//  ׻ -1 

		$this->setIndex($start);
		
		for($i = 0; $this->next() && $i < $page_size; $i++) { 
			$data->add($this->gets());
		}

		$this->returnIndex();

		return $data;

	}


	/**
	 * table ± ü 
	 *
	 *   ׽Ʈ Ÿ 
	 * 
	 *   NUM | NAME | AGE
	 *    1  | ZINO | 28 
	 *    2  | SU   | 20 
	 *
	 * ex)  1. $data->toDataTable();			
	 *
	 *		| NUM | NAME | AGE |
	 *		|  1  | ZINO | 28  |
	 *		|  2  | SU   | 20  |
     *
	 *		ü Ÿ ״ table ±׷ 
	 *
	 *      2. $data->toDataTable(array('num'));
	 *
	 *		| NUM | 
	 *		|  1  | 
	 *		|  2  | 
	 *
	 *		num ʵ忡 ؼ table ±׷ 
	 *
	 *      3. $data->toDataTable(array('num'), array('num' => 'Ϸùȣ'));
	 *
	 *		| Ϸùȣ | 
	 *		|  1       | 
	 *		|  2       | 
	 *
	 *		num ʵ忡 ؼ    Ҷ 'num'  'Ϸùȣ'  ٲ ؼ Ѵ. 
	 *
	 * @access	public
	 * @name	toDataTable()
	 * @param	$field_list	array	ְ  ʵ Ʈ
	 * @param	$name_list	array	ʵ Ʈ ٸ ̸ Ʈ
	 * @return	php.lang.Tag			table Tag ü 
	 */
	public function toDataTable($field_list = array(), $name_list = array()) 
	{
		$table = T_("table", true);
		$table->setAttribute(
			array('border' => '1')
		);
	
		// µ ʵ  
		$field_list = (count($field_list) == 0) ? $this->fields : $field_list ;
		$hasName = (count($name_list) > 0) ? true : false;

		// ʵ   
		$tr = T_("tr", true);

		foreach ($field_list as $field) {
			$th = T_("th",true);

			if ($hasName) { 
				$th->add(isset($name_list[$field]) ? $name_list[$field] : $field);
			} else {
				$th->add($field);
			}
			$tr->add ($th);
		}

		$table->add($tr);

		// Ÿ  
		$this->saveIndex();

		while($this->next()){  
			$tr =  T_("tr", true);

			foreach ($field_list as $field){
				$f = T_("td", true);
				$f->add($this->get($field));

				$tr->add($f);
			}

			$table->add($tr);
		}

		$this->returnIndex();

		return $table;
	}

	/**
	 * ̺  
	 */
	public function toString($fields = array(), $names = array())
	{
		$obj = $this->toDataTable($fields, $names);

		return $obj->toString();
	}

	/**
	 * ȭ  
	 */
	public function display($fields = array(), $names = array())
	{
		echo $this->toString($fields, $names);
	}

	/**
	 * json  ȯ  
	 * 
	 * $option    all,  field, data 
	 */
	public function toJSON($option = 'all') { 
		
		$option = strtolower($option);

		if ($option == 'all') { 
			return json_encode(array('field' => $this->fields, 'row' => $this->row));
		} else if ($option == 'field') { 
			return json_encode($this->fields);
		} else if ($option == 'row') { 
			return json_encode($this->row);
		}

		return json_encode("");
	}

	//   xml ȯش. 
	public function toXml()
	{
		$xml = T_("data", true);
		$this->saveIndex();

		while($this->next()){  
			$record =  T_("record", true);

			foreach ($this->fields as $field){

				if (PObject::isObject($this->get($field), 'Data')) { 
					$f = T_(strtolower($field)."_list", true);					
					$str = $this->get($field)->toXml();
				} else { 
					$f = T_(strtolower($field), true);
					$str = $this->get($field);
				}

				$f->add($str);

				$record->add($f);
			}

			$xml->add($record);
		}

		$this->returnIndex();

		return $xml->toString();
	}

	/*
	 *  Data ü ٸ Data ü 
	 *
	 * @access	public
	 * @name	setData()
	 * @param	$data	php.db.Data		ܺ Data ü 
	 * @return	void
	 */
	public function setData(Data $data)
	{
		$this->setFields($data->getFields());
		$this->setRows($data->getRows());
		$this->init();
	}

	/** 
	 *   ߰ 
	 *
	 *
	 *  ex) $data = new Data();
	 *
	 *		$data->sort(array('field1' => SORT_DESC, 'field2' => SORT_ASC));
	 *		or    
	 *		$data->sort(array('field1' => 'desc', 'field2' => 'asc'));
	 *
	 *		echo $data;
	 *
	 * @access	public
	 * @name	sort()
	 * @param	$arr	array		 Ÿ 
	 * @return	void
	 *
	 **/
	public function sort($arr) {
		$arr = $this->map($arr);

		$this->saveIndex();
		
		$temp = array();
		
		//  Ķ 
		$params = array();

		foreach ($arr as $key => $desc) { 
			// ĵ Ÿ  
			${$key} = $this->getColumnList($key);		

			//  ʵ 
			$params[] = ${$key};						

			//   
			$params[] = (strtolower($desc) == 'desc' or $desc == SORT_DESC ) ? SORT_DESC : SORT_ASC ;	
		}

		$params[] = &$this->row;						// ü Ÿ   


		// Ÿ  Ű ϼ 
		call_user_func_array('array_multisort', $params);

		$this->returnIndex();
	}

	/**
	 *  ƿƼ ޼ҵ 
	 */

	/** 
	 * հ ϱ 
 	 */
    public function sum($field) { 
		$arr = $this->getColumnList($field);

		return array_sum($arr);
	}

	/** 
	 *  ϱ
 	 */
	public function avg($field) { 
		$sum	= $this->sum($field);
		$count	= $this->getListCount();

		return ($count == 0) ?  0 : ($sum/$count);
	}

	/**
	 *  ArrayAccess interface  
	 */
	function offsetExists($name) {
		return in_array(strtolower($name), $this->fields);
	}

	function offsetGet($name) {
		return $this->get($name);
	}

	function offsetSet($name, $value) {
		$this->set($name, $value);
	}

	function offsetUnset($name) {
		$this->dropData($name);
	}

}
?>