<?php

import("php.lang.PObject");
import("php.net.IConnector");
import("php.db.Sql");
import("php.db.DBData");

/**
 * DB ڿ  ߻ ŬԴϴ.
 *
 * @import	php.lang.PObject, php.interface.IConnector
 * @package php.db
 * @name	DBClient
 * @abstract 
 *
 */
abstract class DBClient extends PObject implements IConnector {

	/**
	 * Ӽ  
	 *
	 * program, host, port, id, pass, db, schema, version 
	 */
	private $_attribute = array();

	/**
	 *  resource
	 * 
	 * @name $con
	 * @type resource
	 */
	protected $con;

	/**
	 *   resource
	 * 
	 * @name $result
	 * @type resource
	 */
	protected $result;

	/**
	 * ν resource
	 * 
	 * @name $stmt
	 * @type resource
	 */
	protected $stmt;


	/*
	 * Ŭ  resource
	 *
	 */
	protected $exec;

	/*
	 *  
	 *
	 *
	 */
	public function __construct($program = '', $host = '', $port = '', $id = '', $pass = '', $db = '', $schema = '', $version = '')  {

		$this->setAttribute('PROGRAM',	strtoupper($program));
		$this->setAttribute('HOST',		$host);
		$this->setAttribute('PORT',		$port);
		$this->setAttribute('ID',		$id);
		$this->setAttribute('PASS',		$pass);
		$this->setAttribute('DB',		$db);
		$this->setAttribute('SCHEMA',	$schema);
		$this->setAttribute('VERSION',	$version);
	}

	/**
	 * ἳ
	 * 
	 * @access	public 
	 * @name	set()
	 * @param	$name string	  ̸ 
	 * @return	void
	 * @override
	 *
	 */
	public function set($name)
	{
		$name = strtoupper($name."_".$this->getAttribute("program"));

		$this->setAttribute('HOST',		constant("{$name}_HOST"));
		$this->setAttribute('PORT',		constant("{$name}_PORT"));
		$this->setAttribute('ID',		constant("{$name}_ID"));
		$this->setAttribute('PASS',		constant("{$name}_PASS"));
		$this->setAttribute('DB',		constant("{$name}_DB"));
		$this->setAttribute('VERSION',	constant("{$name}_VERSION"));
		$this->setAttribute('SCHEMA',	constant("{$name}_SCHEMA"));
	}

	public function getAttribute($key) { 
		return $this->_attribute[strtoupper($key)];
	}

	public function setAttribute($key, $value) { 
		$this->_attribute[strtoupper($key)] = $value;
	}

	/**
	 * Ӽ о , getAttribute()   Դϴ. 
	 *
	 * ex) echo $dbclient->program;
	 * 
	 * @access	public 
	 * @name	__get()
	 * @param	$key string	  ̸ 
	 * @return	mixed
	 * @since	php 5.0 
	 *
	 */
	public function __get($key) { 
		return $this->getAttribute($key);
	}

	/**
	 * Ӽ ϱ , setAttribute()   Դϴ. 
	 *
	 * ex) $dbclient->program = "mssql";
	 * 
	 * @access	public 
	 * @name	__get()
	 * @param	$key	string	Ӽ ̸
	 * @param	$value	mixed	Ӽ
	 * @return	mixed
	 * @since	php 5.0 
	 *
	 */
	public function __set($key, $value) { 
		$this->setAttribute($key, $value);
	}

	/**
	 *  DB Ȯϱ 
	 *
	 * ex) if ($dbclient->is('mssql')) { 
	 *			echo "database is mssql";
	 *     } 
	 *
	 *     if ($dbclient->is('mysql', '5')) { 
     *			echo "current version : mysql 5" ;
	 *		}
	 * 
	 * @access	public 
	 * @name	is()
	 * @param	$db_name	string	Ÿ̽  (mysql, mssql, oracle, progres, cubrid)
	 * @param	$version	string	Ӽ
	 * @return	boolean			
	 *
	 */
	public function is($db_name, $version = '') { 
		if (!$version) { 
			return ($this->program == strtoupper($db_name));
		} else { 
			return ($this->program == strtoupper($db_name) && $this->version == $version);
		}
	}

	/**
	 * 
	 * 
	 * @access	public 
	 * @name	connect()
	 * @return	void 
	 */
	public function connect() 
	{
		$this->con = $this->_connect();

		$this->_selectDb();
	}

	/**
	 * commit 
	 * 
	 * @access	public 
	 * @name	commit()
	 * @return	void 
	 */
	public function commit() { }

	/**
	 * rollback
	 * 
	 * @access	public 
	 * @name	rollback()
	 * @return	void 
	 */
	public function rollback() { }

	/**
	 *  ҽ 
	 * 
	 * @access	public 
	 * @name	_connect()
	 * @abstract 
	 * @return	resource		 ҽ 
	 * @since	php 5.0 
	 */
	abstract protected function _connect();

	/**
	 *  ҽ 
	 * 
	 * @access	public 
	 * @name	_selectDb()
	 * @abstract 
	 * @return	void
	 * @since	php 5.0 
	 */
	abstract protected function _selectDb();


	/**
	 *    
	 * 
	 * @access	public 
	 * @name	createConnector()
	 * @static 
	 * @return	php.db.DBClient	 db ´ DBClient  Ŭ, Mysql, Mssql, Oracle, Postgres, Cubrid, Mysql_i
	 * @since	php 5.0 
	 */
	public static function createConnector($dbClass, $db) {

		$obj = null;

		if (class_exists($dbClass)) { 
			$obj = new $dbClass();
			$obj->set($db);
		} 

		return $obj;
	}

	/**
	 * ݱ
	 * 
	 * @access	public 
	 * @name	close()
	 * @abstract 
	 * @override
	 * @return	void 
	 * @since	php 5.0 
	 */
	public function close()
	{ 
		return true;
	}

	 
	/**
	 *    
	 * 
	 * @access	public 
	 * @name	getResult()
	 * @abstract 
	 * @override
	 * @return	resource  
	 * @since	php 5.0 
	 */
	public function getResult() {
		return $this->result;
	}

	/**
	 * IData ̽  
	 * 
	 * @access	public 
	 * @name	createData()
	 * @abstract 
	 * @param	$resource	resource	 ҽ
	 * @param	$baseClass	string		 Ŭ ̸ 
	 * @return	php.db.DBData
	 * @since	php 5.0 
	 */
	public function createData($result, $baseClass = "DBdata") {
		// ⺻ Data Ŭ ϰ 
		// Data Ŭ  ٸ Data Ŭ ϸ ȴ. 

		$data = new $baseClass($this);
		$data->setBaseClass($baseClass);

		if (!$result)
			return $data;

		$data->setFields($this->getFieldList($result));
		$data->setTypeList($this->getFieldTypeList($result));

		// Ÿ ߰
		while ($d = $this->fetch($result)) 
			$data->add($d);

		return $data;
	}

	/**
	 * Data  
	 * 
	 * @access	public 
	 * @name	getData()
	 * @abstract 
	 * @param	$query		string		DB query
	 * @param	$isOne		boolean		ε ĭ ű
	 * @param	$baseClass	string		 Ŭ ̸ 
	 * @return	php.db.DBData 
	 * @since	php 5.0 
	 */
	public function getData($query, $isOne = false, $baseClass = 'DBData') 
	{
		$this->query($query);

		$data = $this->createData($this->getResult(), $baseClass);

		if (!$this->getResult())  
			$this->free($this->getResult());

		if ($isOne) 
			$data->next();

		return $data;
	}

	/**
	 *  
	 * 
	 * @access	public 
	 * @name	getPageCount()
	 * @param	$total			int	ü 
	 * @param	$limitPage		int	  Ʈ 
	 * @param	$limitBlock		int	  
	 * @return	array		count : ü, page :  , block :   
	 */
	public function getPageCount($total, $limitPage, $limitBlock) { 
		$count = $total;
		$page = ceil($count/$limitPage);
		$block = ceil($page/$limitBlock);

		$temp = array('count'=>$count, 'page'=>$page, 'block'=>$block);

		return $temp;		
	}

	/**
	 *   
	 * 
	 * @access	public 
	 * @name	getPageCountSubquery()
	 * @param	$sql			string	  
	 * @param	$limitPage		int		  Ʈ 
	 * @param	$limitBlock		int		  
	 * @return	array					count : ü, page :  , block :   
	 */
	public function getPageCountSubquery($sql, $limitPage, $limitBlock) {
		$sql = "SELECT COUNT(*) as cnt FROM ( $sql )";

		return $this->getPageCountQuery($sql, $limitPage, $limitBlock);
	}

	/**
	 * Ϲ  
	 * 
	 * @access	public 
	 * @name	getPageCountQuery()
	 * @param	$sql			string	Ϲ  
	 * @param	$limitPage		int		  Ʈ 
	 * @param	$limitBlock		int		  
	 * @return	array					count : ü, page :  , block :   
	 */
	public function getPageCountQuery($sql, $limitPage, $limitBlock) {
		$data = $this->getData($sql, true);

		return $this->getPageCount($data->get('cnt', 0), $limitPage, $limitBlock);
	}

	/**
	 * Ǿ  ؼ ʵ帮Ʈ  ´. 
	 * DBDataü   Ǿ  
	 *
	 * @access	public 
	 * @name	getFieldList()
	 * @param	$stmt	resource	   
	 * @return	array			
	 */
	public function getFieldList($stmt) {
		// ʵ Ʈ  
		$ncols = $this->getFieldCount($stmt);

		$arr = array();
		for ($i = 0; $i < $ncols; $i++) {
			$arr[] = $this->getFieldName($stmt, $i);
		}		

		return $arr;
	}

	/**
	 * Ǿ  ؼ ʵ Ÿ Ʈ  ´. 
	 * DBDataü   Ǿ  
	 *
	 * @access	public 
	 * @name	getFieldTypeList()
	 * @param	$stmt	resource	   
	 * @return	array			
	 */
	public function getFieldTypeList($stmt) { 
		// ʵ Ʈ  
		$ncols = $this->getFieldCount($stmt);

		$arr = array();
		for ($i = 0; $i < $ncols; $i++) {
			$arr[] = $this->getFieldType($stmt, $i);
		}		

		return $arr;
	}

	/**
	 * update sql  
	 *
	 * @access	public 
	 * @name	updateSql()
	 * @param	$data	php.db.DBData	sql   DBData ü 
	 * @param	$omit	array			 ʵ 
	 * @return	php.db.Sql							
	 */
	public function updateSql(DBData $data, $omit = array()) {
		$sql = new Sql($this->getAttribute('program'), "update");
		$sql->setFrom($data->getTable());

		$rows = $data->gets();

		foreach ($data->getFields() as $field) {
			if ($field != 'num') {
				if (!in_array($field, $omit)) { 
					$sql->add($field, $rows[$field]);
				}
			}
		}

		$sql->addWhere('','NUM','=', $data->num, false);

//		echo $sql;

		return $sql;
	}

	/**
	 * insert sql  
	 *
	 * @access	public 
	 * @name	insertSql()
	 * @param	$data	php.db.DBData	sql   DBData ü 
	 * @param	$omit	array			 ʵ 
	 * @return	php.db.Sql							
	 */
	public function insertSql(DBData $data, $omit = array()) { 
		$tempSql = new Sql($this->getAttribute('program'), "insert");
		$tempSql->setFrom($data->getTable());

		$rows = $data->gets();

		foreach ($data->getFields() as $field) {
			if ($field != 'num') {
				$tempSql->add($field, $rows[$field]);
			}
		}

//		echo $tempSql;

		return $tempSql;
	}

	/**
	 * delete sql  
	 *
	 * @access	public 
	 * @name	deleteSql()
	 * @param	$data	php.db.DBData	sql   DBData ü 
	 * @return	php.db.Sql							
	 */
	public function deleteSql(DBData $data) { 
		$sql = new Sql($this->getAttribute('program'), "delete");
		$sql->setFrom($data->getTable());
		$sql->addWhere('','NUM','=', $data->num, false);

		return $sql;
	}

	// ڿ escape	
	public function escape($str) { 
		return str_replace("'", "''", $str);
	}


	/**
	 *  
	 * 
	 * @access	public 
	 * @name	error()
	 * @abstract 
	 * @return	void 
	 * @since	php 5.0 
	 */
	abstract public function error() ;

	/**
	 *  ϱ
	 *
	 * @access	public 
	 * @name	query
	 * @abstract
	 * @param	$sql	string  sql 
	 * @return	resource		 ,   false 
	 * @since php 5.0 
	 */
	abstract public function query($sql) ;


	/**
	 * ʵ   
	 *
	 * @access	public 
	 * @name	getFieldCount
	 * @abstract
	 * @param	$result resource   
	 * @return	int
	 * @since php 5.0 
	 */
	abstract public function getFieldCount($result) ;

	/**
	 * ʵ ̸   
	 *
	 * @access	public 
	 * @name	getFieldName
	 * @abstract
	 * @param	$result resource   
	 * @param	$i		int		  ʵ offset, 0-based number
	 * @return	string		ʵ ̸ 
	 * @since php 5.0 
	 */
	abstract public function getFieldName($result, $i) ;

	/**
	 * ʵ Ÿ   
	 *
	 * @access	public 
	 * @name	getFieldType
	 * @abstract
	 * @param	$result resource   
	 * @param	$i		int		  ʵ offset, 0-based number
	 * @return	string		ʵ Ÿ ̸ 
	 * @since	php 5.0 
	 */
	abstract public function getFieldType($result, $i);

	/**
	 * ڵ 
	 *
	 * @access	public 
	 * @name	fetch
	 * @abstract
	 * @param	$result resource  
	 * @return	array
	 * @since php 5.0 
	 */
	abstract public function fetch($result) ;

	/**
	 * ޸ 
	 *
	 * @access	public 
	 * @name	free
	 * @abstract
	 * @param	$result resource    
	 * @return	void
	 * @since php 5.0 
	 */
	abstract public function free($result) ;

	/**
	 * result set ̵ 
	 *
	 * @access	public 
	 * @name	seek
	 * @param	$count int	̵ row  
	 * @return	void
	 * @since php 5.0 
	 */
	public function seek($count) { }

	/**
	 *  ࿡   row  
	 *
	 * @access	public 
	 * @name	affectedRows()
	 * @return	int
	 * @since	php 5.0 
	 */
	public function affectedRows() { }

	/**
	 *  Ÿ Ÿ 
	 * 
	 *   php/db/meta/
     *   {ŸŸ}Data_{program}{version}.php 
	 *
	 * ex)  $db->getMetaData('table');					//   db  ̺ Ʈ Dataü ȯ
	 *		$db->getMetaData('index', '̸̺');	// ־ ̺ ؼ ε Ʈ Dataü ȯ
	 *		$db->getMetaData('column', '̸̺');	// ־ ̺ ؼ ÷ Ʈ Dataü ȯ
	 *
	 * @return	php.db.DBData 
	 */
	public function getMetaData($meta_type = 'table', $object = '') {

		//  ̸ 
		$filename = sprintf("%sData_%s%s.php", 
							ucwords($meta_type), 
							$this->getAttribute('program'), 
							$this->getAttribute('version')
					);

		// ŸData ʿ  
		$arr = array(
			'schema_name'	=> $this->getAttribute('schema'),
			'object_name'	=> $object,
			'db_name'		=> $this->getAttribute('db')
		);

		///  н  
		$path = LIB."php/db/meta/".$filename;

		// Ÿ sql о
		if (file_exists($path)) {
			include $path;
		} else { 
			return new DBData($this);
		}

		//   Ǿ  ʴٸ ִ Data ü 
		if (!$sql) { 
			return new DBData($this);
		}

		$data = $this->getData($sql);

//		echo $data;

		return $data;
	}
}

?>