<?php
import("php.db.DBClient");
import("php.db.CubridConfig");

class Cubrid extends DBClient {

	private $tempStmt;

	private $oid		= null;
	private $cursor		= array();

	private $proc_name	= "";
	private $bind_list	= array();

	public function __construct($host = '', $port = '', $id = '', $pass = '', $db = '', $schema = '', $version = '') {
		$program		= strtoupper(__CLASS__);
		parent::__construct($program, $host, $port, $id, $pass, $db, $schema, $version);
	}

	protected function _connect() {
		return cubrid_connect(
					$this->getAttribute('host'), 
					$this->getAttribute('port'), 
					$this->getAttribute('db'),
					$this->getAttribute('id'),
					$this->getAttribute('pass')
				);
	}

	protected function _selectDb() { 
		return true;
	}

	public function affectedRows() { 
		return cubrid_affected_rows($this->getResult());
	}

	/******************
	 * oid  
	 ******************/

	// oid   Ȯ 
	public function isInstance($oid = '') { 
		return cubrid_is_instance($this->con, $this->getOID($oid));
	}

	// oid 
	public function setOID($oid) { 
		$this->oid = $oid;
	}

	public function getOID($oid = '') { 
		return (empty($oid)) ? $this->oid : $oid;
	}

	// oid Ư Ӽ   
	public function get($attr, $oid = '') { 
		if (is_array($attr)) { 
			$temp = array();

			foreach ($attr as $temp_attr) { 
				$temp[$temp_attr] = cubrid_get($this->con, $this->getOID($oid), $temp_attr);
			}

			return $temp;
		} else { 
			return cubrid_get($this->con, $this->getOID($oid), $attr);
		}
	}

	// oid Ӽ Ʈ   
	public function gets($oid = '') { 
		return cubrid_get($this->con, $this->getOID($oid));
	}

	// oid Ӽ  
	public function put($attr, $value, $oid = '') { 
		
		$args = array($this->con, $this->getOID($oid), $attr);


		if (is_array($arr) == false) { 
			$args[] = $value;	
		} 

		return call_user_func_array('cubrid_put', $args); 
	}

	public function puts($attr_list, $oid = '') { 
		return cubrid_put($this->con, $this->getOID($oid), $attr_list);
	}

	// oid شǴ instance  
	public function drop($oid = '') { 
		return cubrid_drop($this->con, $this->getOID($oid));
	}

	// ÷ Ÿ  

	// set ߰ 
	public function addSet($attr, $value, $oid = '') { 
		return cubrid_set_add($this->con, $this->getOID($oid), $attr, $value);
	}

	// set  
	public function dropSet($attr, $value, $oid = '') { 
		return cubrid_set_drop($this->con, $this->getOID($oid), $attr, $value);
	}

	// seq Ư  ֱ 
	public function insertSeq($attr, $index, $value, $oid = '') { 
		return cubrid_seq_insert($this->con, $this->getOID($oid), $attr, $index, $value);
	}

	// seq ߰
	public function addSeq($attr, $value, $oid = '') { 
		$size = cubrid_col_size($this->con, $this->getOID($oid), $attr);

		return $this->insertSeq($attr, $size+1, $value);
	}

	// seq  
	public function dropSeq($attr, $index, $oid = '') { 
		return cubrid_seq_insert($this->con, $this->getOID($oid), $attr, $index);
	}

	// seq Ư  ϱ
	public function putSeq($attr, $index, $value, $oid = '') { 
		return cubrid_seq_put($this->con, $this->getOID($oid), $attr, $index, $value);
	}

	// collection   
	public function getCollectionSize($attr, $oid = '') { 
		return cubrid_col_size($this->con, $this->getOID($oid), $attr);
	}

	// collection Ÿ 迭 ·  (set, multiset, sequence)
	public function getCollection($attr, $oid = '') { 
		return cubrid_col_get($this->con, $this->getOID($oid), $attr);
	}

	//  Ÿ set, multiset, sequence   Data ü ´.
	public function getOIDData($attr, $isOne = false, $oid = '', $baseClass = 'DBData') { 
		$a = $this->getCollection($attr, $this->getOID($oid));

		$data = new $baseClass($this);

		if (empty($a)) { 
			return $data;
		}


		$data->setFields(array_keys($this->gets($a[0])));
		$data->addField('oid');

		foreach ($a as $oid) { 
			$arr = $this->gets($oid);
			$arr['oid'] = $oid;
			$data->add($arr);
		}

		if ($isOne) { 
			$data->next();
		}

		return $data;
	}

	// б lock  
	public function setReadLock($oid = '') { 
		return cubrid_lock_read($this->con, $this->getOID($oid));
	}

	//  lock  
	public function setWriteLock($oid = '') { 
		return cubrid_lock_write($this->con, $this->getOID($oid));
	}

	//  ݱ 
	public function close() {
		cubrid_disconnect($this->con);
	}

	// commit 
	public function commit() { 
		cubrid_commit($this->con);
	}

	// rollback 
	public function rollback() { 
		cubrid_rollback($this->con);
	}

	// result ޸  
	public function free($result) { 
		return cubrid_close_request($result);
	}

	//  ޼  
	public function error() {
		return cubrid_error_msg($this->con);
	}

	// Ϲ   
	// CUBRID_INCLUDE_OID, CUBRID_ASYNC   : |    
	//  oid, async 

	public function query($query, $option = '') {
	
		$options = strtolower($option);

		if ($option == 'oid') { 
			$option = CUBRID_INCLUDE_OID;
		} else if ($option == 'async') {
			$option = CUBRID_ASYNC;
		} else if ($option == 'all') { 
			$option = CUBRID_ASYNC | CUBRID_INCLUDE_OID;
		}

		if (is_string($query)) {	// Ϲ sql 
			$args = array($this->con, $query);

			if ($option != '') { 
				$args[] = $option;
			}

			$this->result = call_user_func_array('cubrid_execute', $args);

			return $this->result;

		} else {		// prepare ̿ ü  

			$args = array($query);

			if ($option != '') { 
				$args[] = $option;
			}

			call_user_func_array('cubrid_execute', $args);

			$this->result = $query;

			return $query;
		}
	}

	/**
	 *  prepare ⺻   
	 *
	 * $sql = "select * from board where title = ?";
	 * $number = "";
	 *
	 * $stmt = $cubrid->prepare($sql);
	 * $cubrid->bindPrepare($stmt, 1, $number);
	 *
	 * echo $cubrid->getData($stmt);   or  $cubrid->query($stmt);
	 *
	 *
	 */

	// prepare  
	public function prepare($query, $option = '')  { 
		if (strtolower($option) == 'oid') { 
			$option = CUBRID_INCLUDE_OID;
		} 

		$args = array($this->con, $query);

		if ($option != '') { 
			$args[] = $option;
		}

		$this->tempStmt = call_user_func_array('cubrid_prepare', $args);

		return $this->tempStmt;
	} 

	// bind  
	public function bindPrepare($stmt, $index = 1, $bind_value, $bind_value_type = '') { 

		$bind_value_type = strtoupper($bind_value_type);

		$args = array($stmt, $index, $bind_value);

		if ($bind_value_type != '') { 
			$args[] = $bind_value_type;
		} 

//		$temp = cubrid_bind($stmt, $index, $bind_value, $bind_value_type);

		$temp = call_user_func_array('cubrid_bind', $args);

		return $temp ;
	}

	public function getResult() { 
		return $this->result;
	}

	public function getFieldCount($result) {
		return cubrid_num_cols($result);
	}

	public function getFieldList($result) { 
		return cubrid_column_names($result);
	}

	public function getFieldName($result, $i) {
		$arr = $this->getFieldList($result);

		return $arr[$i];
	}

	public function getFieldType($result, $i) {
		$arr = $this->getFieldTypeList($result);

		return $arr[$i];
	}

	public function getFieldTypeList($result) {	
		return cubrid_column_types($result);
	}

	public function fetch($result) {
		return cubrid_fetch($result, CUBRID_ASSOC);
	}

	public function getPageData($query, $page = 1, $count = 10, $order_type = 'order', $baseClass = 'DBData') {
		
		if (!in_array($order_type, array('order', 'group'))) { 
			die('order_type  ƲȽϴ.(order, group   ϳ ּ)');
		}
		

		//  ϱ 
		$start = ($page-1)*$count+1;
		$end = ($start+$count-1);

		if ($order_type == 'order') { 
			$query .= " for orderby_num() between {$start} and {$end} ";
		} else if ($order_type == 'group') { 
			$query .= " having groupby_num() between {$start} and {$end} ";			
		} else { 
			$query .= " and rownum between {$start} and {$end} ";
		}


		return $this->getData($query, false, $baseClass);
	}

	// ν   
	//
	// mssql      ְڲ ϰڽϴ. 

	public function init($proc_name) { 
		$this->proc_name = $proc_name;
		$this->bind_list = array();
	}

	// ε 
	public function bind($inout_type, $name, $data_type = '', $value = '') { 
		$this->bind_list[] = array(
				'name'			=> $name, 
				'data_type'		=> $data_type, 
				'inout_type'	=> $inout_type, 
				'value'			=> $value
		);
	}

	// ν  
	public function execute() { 

		$output_count	= 0;
		$output_list	= array();

		// ڿ  
		$head = "call {$this->proc_name}(";
		$temp = array();
		$var_init = array();

		foreach ($this->bind_list as $bind) { 
			$var_init[] = sprintf("select %s into %s from db_root;", 
										$this->getTypeConvert($bind['data_type'], $bind['value']), 
										$bind['name']
			);

			$temp[]	= $bind['name'];

			if (in_array($bind['inout_type'], array('out', 'inout'))) { 
				$output_count++;
				$output_list[] = $bind['name'];
			}
		}
		
		$head .= implode(",", $temp);

		$head .= ") ";


		//   
		foreach ($var_init as $var_sql) { 
			$this->query($var_sql);
		}

		// ν  
		if (!$this->query($head)) { 
			return false;
		}

		// ƿǲ  ޱ 
		if ($output_count > 0 ) { 
			$sql = "select ".implode(",", $output_list). " from db_root ";
			return $this->getData($sql, true);
		}

		return true;
	}

	public function getTypeConvert($type, $value) { 
		$type = strtoupper($type);
		$str = $value;

		switch ($type) { 
			case 'CHAR':
			case 'VARCHAR':
			case 'NCHAR':
			case 'NCHAR VARYING':
			case 'STRING':
			case 'BIT':
			case 'BIT VARYING':
				$str = "'{$str}'";
				break;
			case 'NUMERIC':
			case 'DECIMAL':
			case 'INTEGER': 
			case 'INT': 
			case 'SMALLINT':
			case 'MONETARY':
			case 'FLOAT':
			case 'REAL':
			case 'DOUBLE PRECISION':
				$str = "{$str}";
				break;
			case 'DATE':
			case 'TIME':
			case 'TIMESTAMP':
				$str = "{$type}'{$str}'";
				break;
			case 'SET': 
			case 'MULTISET': 
			case 'LIST': 
			case 'SEQUENCE':
				$str = "{".$str."}";
				break;
			default :
				$str = "{$str}";
				break;
		}

		return $str;
	}


	/*
	   glo  ޼ҵ  
	 */

	// ο glo Ŭ  oid  
	 public function newGLO($class_name, $file_name) { 
		return cubrid_new_glo($this->con, $class_name, $file_name);
	 }

	// oid شϴ glo  file_name 
	 public function loadGLO($file_name, $oid = '') { 
		return cubrid_load_from_glo($this->con, $this->getOID($oid), $file_name);
	 }

	// oid شϴ glo ȭ鿡 ״  
	 public function printGLO($oid = '', $content_type = '' ) {

		if ($content_type) { 
			header("Content-Type : {$content_type}");
		}

		return cubrid_send_glo($this->con, $this->getOID($oid));
	 }

	// oid شϴ glo file_name ִ Ϸ ϱ 
	 public function saveGLO($file_name, $oid = '') { 
		return cubrid_save_to_glo($this->con, $this->getOID($oid), $file_name);
	 }

}

?>