<?php
/*** 
   php.lang.*  처럼 패키지 안에 들어있는 모든 클래스들을 include 하는 것이 첫번째 형태이고 
   php.lang.String 처럼 실제 클래스 경로를 명시하는 것이 두번째 형태이다. 
***/

define("LIB", dirname(__FILE__)."/");    // 라이브러리 절대 경로, 필수  

function import($path) {
	if (empty($path))
		return false;

	$arr = explode(".", $path);
	$class = $arr[sizeof($arr)-1];  // 클래스 이름 

	if ($class == "*") {            // 클래스 이름이 * (모든것) 이면 

    // 해당 디렉토리를 구해서 그 안의 php 파일은 모두 include한다. 
		$dir = str_replace(".", "/", $path);  
		$dir = str_replace("/*", "", $dir);

		if (is_dir(LIB.$dir)) {
			if ($d = opendir(LIB.$dir)) {
				while (($file = readdir($d)) !== false) {
					if ($file == "." || $file == ".." || strpos($file, ".php") === FALSE) {
					    continue;
					} else {
					    include_once LIB.$dir."/".$file;
					}
				}
 			   closedir($d);
			}
		 }
	}  else {

		$path = str_replace(".", "/", $path);
		include_once LIB.$path.".php";
	}

}
?>