<?php
// (c-file-style: "gnu")
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:   
// $Id: w2dclass.php,v 1.30 2005/08/10 06:54:40 gryu Exp $

include_once('w2d_transform.php');

function get_fileref($linktarget, &$transformer)
{			
	if(isset($transformer->Params['ImageDir']))
	{
		$pathinfo = pathinfo($linktarget);
		$linktarget="{$transformer->Params['ImageDir']}/{$pathinfo['basename']}";
	}
	return $linktarget;
}

class WikiToDocBook 
{
	var $Transform;
	var $TopLevelElementName;
	var $IncludeXmlDeclaration;
	function WikiToDocBook (
		$aDocInfo  =  array ( 
		'TopLevelName' => 'article', 
				'IncludeXmlDeclaration'=>true,
				'FirstSection' => 'section' )
	) 
	{
		global  $AllowedProtocols;
		
		$this->TopLevelElementName = $aDocInfo['TopLevelName'];
	 	$this->IncludeXmlDeclaration = $aDocInfo['IncludeXmlDeclaration'];
	 	$this->IncludeDtdDeclaration = $aDocInfo['IncludeDtdDeclaration'];
	 	$this->DtdPath = $aDocInfo['DtdPath'];

	 	$this->Transform = new Wiki2DocBookTransform;
	 	$this->Transform->Params['FirstSectionName'] = $aDocInfo['FirstSection'];
	 	$this->Transform->Params['IndentChar'] = "\t";
		$this->Transform->Params['indent'] = '';
		$this->Transform->Params['Info'] = '';
		$this->Transform->Params['TopLevelTitle'] = split_pagename($aDocInfo['PageName']);
		$this->Transform->Params['UnclosedSections'] = 0;
		$this->Transform->Params['FirstSectionState'] = 'notstarted';
		$this->Transform->Params['general_block'] = array();
		$this->Transform->Params['general_block_count'] = array();
		$this->Transform->Params['footnotes'] = array();
		if (isset($aDocInfo['ImageDir']))
			$this->Transform->Params['ImageDir'] = $aDocInfo['ImageDir'];
						
		$this->Transform->registerInline('inline_emphasis_quote');		
		$this->Transform->registerInline('inline_emphasis');
		$this->Transform->registerInline('inline_quote');		
		$this->Transform->registerInline('inline_general_inline');
		$this->Transform->registerInline('inline_doubleBracket');
		$this->Transform->registerInline('inline_footnote');
		$this->Transform->registerInline('inline_bracketlinks');
		$this->Transform->registerInline('inline_rawurl');
		$this->Transform->registerInline('inline_wikiname');
		
		$this->Transform->register('!', 'block_section');
		$this->Transform->register('_', 'block_section');		
		$this->Transform->register('*', 'block_itemizedlist');
		$this->Transform->register('#', 'block_orderedlist');
		$this->Transform->register(';', 'block_variablelist');		
		$this->Transform->register(' ', 'block_preformat1');
		$this->Transform->register('{', 'block_preformat2');
		$this->Transform->register('<', 'block_verbatim');
		$this->Transform->register('|', 'block_table');
		$this->Transform->register('[', 'block_bracket');
		$this->Transform->register('(', 'block_general_start');
		$this->Transform->register(')', 'block_general_end');
		$this->Transform->register('%', 'block_ignore');
		$this->Transform->register('@', 'metadata');		
		$this->Transform->register('-', 'horizontal_line');
		
	}
	function convert(&$lines)
	{
		global $encoding;
		if (is_string($lines))
			 $lines = preg_split('/[ \t\r]*\n/', $lines);
 	
		$html = $this->Transform->do_transform( '', $lines) ;

		if (is_array($this->Transform->Params['Info']) )
			$Options = parse_metadata($this->Transform->Params['Info']);

		if (isset($Options['DocType']) )
			$this->TopLevelElementName = $Options['DocType'];

		if (isset($Options['DocHeader']) )
		{
			$this->IncludeXmlDeclaration = $Options['DocHeader']['IncludeXmlDeclaration'];
			$this->IncludeDtdDeclaration = $Options['DocHeader']['IncludeDtdDeclaration'];
			$this->DtdPath = $Options['DocHeader']['DtdPath'];
		}
		
 		if ( $this->IncludeXmlDeclaration) 
 		{
 			$top = "<?xml version=\"1.0\" encoding=\"$encoding\"?>\n";

			if ( $this->IncludeDtdDeclaration)
				$top .= "<!DOCTYPE {$this->TopLevelElementName} {$this->DtdPath}>\n";
		}
				
		$top .=  "\n<{$this->TopLevelElementName} lang=\"ko\"";

		if (isset($this->Transform->Params['TopLevelId']))
			$top .= " id=\"{$this->Transform->Params['TopLevelId']}\">\n";
		else 
			$top .= ">\n";
/* TODO
title  ġ Ȯ.

set, book, article title ~info .
 ܴ ~info .
partintro, colophon ~info .

book ::=
((title,subtitle?,titleabbrev?)?,
 bookinfo?,
 (dedication|toc|lot|glossary|bibliography|preface|chapter|
  reference|part|article|appendix|index|setindex|colophon)*)

article ::=
((title,subtitle?,titleabbrev?)?,
 articleinfo?,tocchap?,lot*,
 ...

set ::=
((title,subtitle?,titleabbrev?)?,
 setinfo?,toc?,
 (set|book)+,
 setindex?)
 
chapter ::=
(beginpage?,chapterinfo?,
 (title,subtitle?,titleabbrev?),
 (toc|lot|index|glossary|bibliography)*,
 tocchap?,
 ...

preface ::=
(beginpage?,prefaceinfo?,
 (title,subtitle?,titleabbrev?),
 (toc|lot|index|glossary|bibliography)*,
 tocchap?,
 
part ::=
(beginpage?,partinfo?,
 (title,subtitle?,titleabbrev?),
 partintro?,
 (appendix|chapter|toc|lot|index|glossary|bibliography|article|
  preface|refentry|reference)+)

colophon ::=
((title,subtitle?,titleabbrev?)?,
 (calloutlist|glosslist|itemizedlist|orderedlist|segmentedlist|
  simplelist|variablelist|caution|important|note|tip|warning|
  literallayout|programlisting|programlistingco|screen|screenco|
  screenshot|formalpara|para|simpara|blockquote)+)

partintro ::=
((title,subtitle?,titleabbrev?)?,

*/
		if (isset($Options['Info']) )
		{
			$top .= "\n<{$this->TopLevelElementName}info>\n";
			$top .= $Options['Info'];
			$top .= "</{$this->TopLevelElementName}info>\n";
		}

		$top .= "<title>{$this->Transform->Params['TopLevelTitle']}</title>\n";
		return $top . $html . "\n</{$this->TopLevelElementName}>\n";
	}
}

function inline_doubleBracket($line, &$transformer)
{
	if ( preg_match_all(
 "/(\[)(\[.+\])/U", $line, $match, PREG_SET_ORDER ) > 0 )
 	{
 		foreach($match as $pair)
 		{
			$line = str_replace($pair[0], 
				$transformer->addToken($pair[2])
  				, $line);
  		}
 	}
 	return $line;
} 

function inline_footnote($line, &$transformer)
{
	global $FieldSeparator;
	if ( preg_match_all(
 "/\[([0-9]+)\]/U", $line, $matches, PREG_SET_ORDER ) > 0 )
 	{
		foreach($matches as $pair)
		{
			$num = $pair[1];
			$link = '<footnote>'.$num.'</footnote>';
			$line = str_replace($pair[0],
   				$FieldSeparator.'footnote'.$num.$FieldSeparator
   				,$line);
		}
 	}
 	return $line;
}

function inline_bracketlinks($line, &$transformer) 
{
	global $InlineImages;	
	if ( preg_match_all(
 "/\[(.+)\]/U", $line, $match, PREG_SET_ORDER ) > 0 )
 	{
 		foreach($match as $pair)
 		{
 			preg_match("/([^|]+)(\|)?([^|]+)?/", $pair[1], $matches);
 			
 			if (isset($matches[3])) 
 			{
				// [ũؽƮ | ũ ] 
				$linkTarget = trim($matches[3]);
				$linkText = trim($matches[1]);
			}
			else
			{
				// [ũ  ] 
				$linkTarget = trim($matches[1]);
				$linkText = '';
			}

			if ( ( preg_match("/($InlineImages)$/i", $linkTarget, $m)) )
			{
				$linkTarget = get_fileref($linkTarget, $transformer);
				$line = str_replace($pair[0], 
					$transformer->addToken(
				"<inlinemediaobject><imageobject><imagedata fileref=\"$linkTarget\" format=\"" . strtoupper($m[1]). '" /></imageobject></inlinemediaobject>')
   						, $line);
			}
			
			else if ( preg_match("/^#(.*)/", $linkTarget, $matches) )
			//  ũ
			{
				if ($linkText == '') $linkText = $matches[1];
				$line = str_replace($pair[0], 
   						$transformer->addToken('<link linkend="'. $matches[1]. '">'. $linkText. '</link>')
   						, $line);
			}
			else
			{
				if ($linkText == '') $linkText = $linkTarget;
				$line = str_replace($pair[0], 
   						$transformer->addToken('<ulink url="'. $linkTarget. '">'. $linkText. '</ulink>') 
   						,$line);

   			};
 		}
 	}
 	
 	return $line;
}

function inline_rawurl($line, &$transformer) 
{
	global $AllowedProtocols;
	if ( preg_match_all("/!?\b($AllowedProtocols):[^\s<>\[\]\"'()]*[^\s<>\[\]\"'(),.?]/",
 		$line, $matches) > 0 )
 	{
 		foreach($matches[0] as $pair)
 		{
 		  //$pair=str_replace('&amp;', '&', $pair); 			
                    $pos = strpos($line, $pair);
   		  $line = substr($line, 0, $pos) .  $transformer->addToken('<ulink url="'. $pair . '">'. $pair . '</ulink>') .
 		        substr($line, $pos + strlen($pair));
 		}
 	}
	return $line;
}

function inline_wikiname($line, &$transformer) 
{
	global $WikiNameRegexp;
	return  preg_replace(
 "@([~!]?)($WikiNameRegexp)@", 
   "\\2", $line );
}

function inline_emphasis_quote($line, &$transformer)
{
	$line = preg_replace("|(''''')(.*?)(''''')|", '<emphasis><quote>\2</quote></emphasis>', $line);
	return $line;
}

function inline_emphasis($line, &$transformer) 
{
	$line = preg_replace("|(''')(.*?)(''')|", '<emphasis>\2</emphasis>', $line);
	return $line;
}

function inline_quote($line, &$transformer)
{
	$line = preg_replace("|('')(.*?)('')|", '<quote>\2</quote>', $line);
	return $line;
}
/* ܼ ζ ±׵. {{tagname content }}  .  ...(ܼ ġȯ ).
{{keycap F1}} => <keycap>F1</keycap>
*/
function inline_general_inline($line, &$transformer)
{
	$line = preg_replace( "|{{([[:alnum:]]+) (.*?)}}|" , '<\1>\2</\1>' , $line);
	return $line;
}

function sublist(&$lines, $startChar, $level, &$transformer)
{
	$baseIndent = $transformer->Params['indent'];

	$line = current($lines);
	
	if ($startChar == '*' ) 
		$tagName = 'itemizedlist';
	else if ($startChar == '#' )
		$tagName = 'orderedlist';
	else 
		die("unknown list  in function sublist()\n<pre>$line</pre>");
	
	$Indent = $baseIndent . $transformer->maketabs($level - 1);
	$html = "$Indent<$tagName>\n";

	$isFirst = true;
	
	while ( (substr($line, $level - 1, 1) == $startChar ) && 
		(preg_match("/^([\#\*\;]+)/", $line, $matches))
	)
	{

		$numtabs = strlen($matches[1]);

		if ($numtabs > $level)
		{
			$newStartChar = substr($line, $numtabs - 1, 1);
			$html .= sublist($lines, $newStartChar, $numtabs, $transformer);
		}

		if ($numtabs == $level)
		{
			if (!$isFirst)
			{
				$html .= "$Indent</listitem>\n";
			}
			else
				$isFirst = false;
			$line = substr($line, $level);
			$html .= $Indent. '<listitem><para>'. trim($transformer->formatInline($line) ).  "</para>\n";
		
		}
		if ( $numtabs < $level) 
			break ;
		if (! ($line = next($lines) ) )
			break;

	}

	prev($lines);
	$html .= "$Indent</listitem>\n$Indent</$tagName>\n";
	return $html;
}

function block_itemizedlist(&$lines, &$transformer)
{
	$html = sublist($lines, '*', 1, $transformer);
	return $html;
}

function block_orderedlist(&$lines, &$transformer)
{
	$html = sublist($lines, '#', 1, $transformer) ;
	return $html;
}

function block_variablelist(&$lines,  &$transformer)
{
	$line =current( $lines );
	$Indent = $transformer->Params['indent'];
	
	$html = "$Indent<variablelist>\n";
	if (!(preg_match("/^(;+\s*)(.*?):(.*$)/", $line, $matches)) )
		return '';
	while (preg_match("/^(;+\s*)(.*?):(.*$)/", $line, $matches))
	{
		$html .= $Indent. '<varlistentry><term>' 
				. trim($transformer->formatInline($matches[2]) )
				." </term>\n";

		$html .= $Indent. '<listitem><para>' 
			. trim($transformer->formatInline($matches[3]) ) 
			." </para>\n$Indent</listitem>\n$Indent</varlistentry>\n";

		
		if (! ($line = next($lines) ) )
			break;
	}
	prev($lines);
	$html .= "$Indent</variablelist>\n";
	return $html;
}

function block_section(&$lines, &$transformer)
{
	$line = current($lines);
	$prevSectionLevel = $transformer->Params['prevSectionLevel'];
	$currLevel = 0;
	if (preg_match("/^(!{1,4})[^!]/", $line, $whichheading))
	{
		$currLevel  = 5 - strlen( $whichheading[1] ); // !!!! -> 1, !!! -> 2, ... ! -> 4
		$line =  preg_replace('/^!+/', '', $line);
	}
	else if (preg_match("/^(\_!+)[^!]/", $line, $whichheading))
	{
		$currLevel  = strlen( $whichheading[1] ) + 3; // _! -> 5, _!! -> 6, etc....
		$line =  preg_replace("/^(\_!+)[^!]/", "", $line);
	}
	
	if ($currLevel > 0)
	{
		$html = '';
		while ( $prevSectionLevel >= $currLevel )
		{
			if ( ($prevSectionLevel == 2) && ($transformer->Params['FirstSectionState'] == 'opened') )
			{
				$html .= "\n" . $transformer->maketabs($prevSectionLevel - 2)
					 . '</'. $transformer->Params['FirstSectionName'] . ">\n";
				$transformer->Params['FirstSectionState'] == 'done';
			}
			else
				$html .= "\n" . $transformer->maketabs($prevSectionLevel - 2) ."</section>\n";

			$prevSectionLevel--;
			$transformer->Params['UnclosedSections'] -= 1;
		}
		
		$prevSectionLevel = $currLevel;
		$transformer->Params['indent'] = $transformer->maketabs($currLevel - 2);
		$TitleAndId = parseTitleLine($line);
		if ( !empty($TitleAndId['ID']) )
		{
			$SectionTag = "\n". $transformer->Params['indent']. "<section id=\"{$TitleAndId['ID']}\">";
			$line = $TitleAndId['Title'];
			if ( $currLevel == 1)
			{
				$transformer->Params['TopLevelId'] = $TitleAndId['ID'];
			}
		}
		else
		{
			$transformer->Params['indent'] = $transformer->maketabs($currLevel-2);
			$SectionTag = "\n". $transformer->Params['indent']. "<section>";
		}
		
		if ( ($currLevel == 2) && ($transformer->Params['FirstSectionState'] == 'notstarted') )
		{
			$SectionTag = str_replace('<section', '<'. $transformer->Params['FirstSectionName'], $SectionTag);
			$transformer->Params['FirstSectionState'] = 'opened';
		}
		
		$line = htmlspecialchars(trim($line));
		if ($currLevel > 1) 
		{
			$html .= $SectionTag;
			$line = $html.  '<title>'. $line . "</title>\n\n";
			$transformer->Params['UnclosedSections'] += 1;
		}
		else if ($currLevel == 1)
		{
			$transformer->Params['TopLevelTitle'] = trim($line);
			$line = '';
			next($lines);
		}
		$transformer->Params['prevSectionLevel'] = $prevSectionLevel;

	}
	return  $line;
}

function block_preformat1(&$lines, &$transformer)
{
	$html =$transformer->Params['indent'] ."<programlisting>\n";

	while (list($dummy, $line) =each($lines) )
	{
	
		if (substr($line, 0, 1) == ' ' or strlen($line) == 0)
			$html .= htmlspecialchars($line)."\n";
		else
			break;
				
	};
	prev($lines);
	prev($lines);
	return $html . $transformer->Params['indent'] ."</programlisting>\n";
}

function block_preformat2(&$lines, &$transformer)
{
	$html = '';
	$line = current($lines);
	if (preg_match('/^{{{/', $line)) {
		$tagname = trim( substr( $line, 3) );
		if ( $tagname == '') $tagname = 'programlisting';
		$html = $transformer->Params['indent'] ."<$tagname>\n";
		next($lines);
		while (list($dummy, $line) =each($lines) ) 
		{
			if (preg_match('/^}}}/', $line) )
				break;
			else
				$html .= htmlspecialchars($line) . "\n";
		}

		$html .= $transformer->Params['indent'] ."</$tagname>\n";
		prev($lines);
	}
	return $html;
}

function block_general_start(&$lines, &$transformer)
{
	$html = '';
	$line = current($lines);
	if ( preg_match('#\(\(\(([a-zA-Z0-9]+)(\s*)(.*)#', $line, $match) )
	{
		$indent = $transformer->Params['indent'];
		$transformer->Params['general_block'][] = $match[1];
		$html = "$indent<{$match[1]}";
		if ($match[3] != '' )
		{
			$TitleAndId = parseTitleLine($match[3]);
			if ( !empty($TitleAndId['ID']) )
		 	{
		 		$html .= ' id="'.$TitleAndId['ID'] . '">';
		 		$match[3] = trim($TitleAndId['Title']);
		 	}
		 	else
		 		$html .= '>';
		 		
		 	$html .= "<title>$match[3]</title>";
		 }
		 else 
		 	$html .= '>';
		 $html .= "\n";
	}
	return $html;
}

function block_general_end(&$lines, &$transformer)
{
	$html = '';
	$line = current($lines);
	if ( preg_match('#\)\)\)#', $line) )
	{
		$indent = $transformer->Params['indent'];
		$closing = array_pop($transformer->Params['general_block']);
		$html = "$indent</{$closing}>\n";
	}
	return $html;
}
function block_verbatim(&$lines, &$transformer)
{
	$html = '';
	$line = current($lines);
	if (trim($line) == '<<<') {
		next($lines);
		while( list($dummy, $line) =each($lines)  )
		{
			if (trim($line) == '>>>' ) 
				break;
			$html .= $line . "\n";
		} 
		prev($lines);
	}

	return $html;
}

function block_table(&$lines, &$transformer)
{
	$line = current($lines);
	$title = '';
	$indent = $transformer->Params['indent'];
	$moreindent = $indent . $transformer->Params['IndentChar'];
	$tabletagname = 'informaltable';
	$attr = 'frame="all"';
	if (substr($line, 0, 2) == '|!' )
	{
		$tabletagname = 'table';
		$title = '<title>';
		$TitleAndId = parseTitleLine(substr($line, 2));
		if ( !empty($TitleAndId['ID']) )
			$attr .= ' id="'. $TitleAndId['ID'] . '"';
		$title .= $transformer->formatInline(trim($TitleAndId['Title'])). "</title>\n";
		$line = next($lines);
	}
	$html = $indent. "<$tabletagname $attr>$title\n";
	$entries = '';
	$thead = '';
	$tfoot = '';
	$cols = 0;
	
	while(substr($line, 0, 1) == '|' )
	{	
		$line = $transformer->formatInline($line);
		$rowmode = '';
		if (substr($line, 0, 2) == '|{' )
		{
			$rowmode = 'thead';
			$line = '|'. substr($line, 2);
		}
		if (substr($line, 0, 2) == '|}' )
		{
			$rowmode = 'tfoot';
			$line = '|'.substr($line, 2);
		}
			
		$row = '';
		$lastcols = 0;
		while (preg_match('/^(\|+)(v*)([<>^]?)([^|]*)/', $line, $m))
		{
			$line = substr($line, strlen($m[0]));
			$td = array();
		
			if (strlen($m[1]) > 1)
			{
				$td['namest'] = 'col' . ($lastcols + 1);
				$td['nameend'] = 'col'. ($lastcols + strlen($m[1]) );
	 		}
			if (strlen($m[2]) > 0)
	 			$td['morerows'] = strlen($m[2]);
		
			if ($m[3] == '^')
	 			$td['align'] = 'center';
				
			$row .= StartTag('entry', $td);
			$row .= trim($m[4]) ;
			$row .= '</entry>';
			$lastcols++;
		}
		$cols = max($lastcols, $cols);
		assert(empty($line));
		if ($rowmode == 'thead')
			$thead = $moreindent . "<row>$row</row>";
		else if($rowmode == 'tfoot')
			$tfoot = $moreindent . "<row>$row</row>";
		else
			$entries .= $moreindent . "<row>$row</row>\n";
		$line = next($lines);
	}
	$html .= $indent. "<tgroup cols=\"$cols\">\n";
	
	for ($i = 0; $i < $cols; $i++)
	{
		$html .= $indent . '<colspec colname="col'.($i+1). "\"/>\n";
	}
	if ($thead != '')
		$html .= $indent. "<thead>\n$thead\n" .
		$indent. "</thead>\n";
	if ($tfoot != '')
		$html .= $indent. "<tfoot>\n$tfoot\n". $indent. "</tfoot>\n";
		
	$html .= $indent. "<tbody>\n$entries". $indent.  "</tbody>\n";
	$html .= $indent. "</tgroup>\n". $indent. "</$tabletagname>\n";
	
	return $html;
}

function block_bracket(&$lines, &$transformer)
{
	global $InlineImages;
	$line = current($lines);
	$indent = $transformer->Params['indent'];
	$moreindent = $indent . $transformer->Params['IndentChar'];
	$html = '';
	if ( preg_match( '#\[([^\[]+)\](.*)#', $line, $match) )
	{
  		if (preg_match( "#($InlineImages)#", $match[1], $m) )
  		{
			$fileref=get_fileref($match[1], $transformer);

 			$html =  "$indent<mediaobject>\n$indent<imageobject>
$moreindent<imagedata fileref=\"$fileref\" format=\"" . strtoupper($m[1]). "\" />
$indent</imageobject>
";
			$caption = trim($match[2]);
			if( $caption != '' )
			{
				$html .= "$indent<caption><para>". $transformer->formatInline($caption) . "</para></caption>\n";
			}
			$html .= "$indent</mediaobject>\n";
		}
		else if ( is_numeric($match[1]) ) // footnote
		{
			$footnote_num = trim($match[1]);
			$footnote_content = $transformer->formatInline(trim($match[2]));
			$transformer->Params['footnotes'][$footnote_num] 
				= "<para>\n$footnote_content\n</para>";
			$html = "\n";
		}
	}
	return $html;
}

function block_ignore(&$lines, &$transformer)
{
	$line = current($lines);
	if ( rtrim($line) == '%%TOC%%' )
		return '<!-- ' . _T('toc') . " -->\n";
	else
		return '';
}

function horizontal_line(&$lines, &$transformer)
{

	if ( preg_match("#^----+$#", current($lines), $match) )
	{
		return "<!-- hr -->\n";
	}
	else
		return '';

}

function parse_person_info($str)
{
	$parts = explode(';', $str);

	$name = explode(' ', $parts[0]);
	$result = '<surname>'. $name[0] . '</surname>';

	if (isset($name[1]))
		$result .= '<firstname>'.$name[1]. "</firstname>\n";

	if (isset($parts[1]))
	{
		$result .= "\t<affiliation>
 	<address><email>$parts[1]</email>
	</address>
	</affiliation>\n";
	}
	return $result; 
}

function parse_revision_info($str)
{
	$result ="\t<revision>\n";
	$parts = explode(';', $str);
	if (isset($parts[0]) )
		$result .= "\t<revnumber>". trim($parts[0]). "</revnumber>\n";
	if (isset($parts[1]) )
		$result .= "\t<date>". trim($parts[1]). "</date>\n";
	if (isset($parts[2]) )
		$result .= "\t<authorinitials>". trim($parts[2]). "</authorinitials>\n";
	if (isset($parts[3]) )
		$result .= "\t<revremark>". trim($parts[3]). "</revremark>\n";
	return $result . "\t</revision>\n\n";
		
}	


function parse_header($str)
{
	global $DefaultDTD;
	
	$result = array();
	$parts = explode(';', $str);
	$result['IncludeXmlDeclaration'] = false;
	$result['IncludeDtdDeclaration'] = false;
	$result['DtdPath'] = $DefaultDTD;
	foreach($parts as $val)
	{
		if (strtolower(trim($val)) == 'xml' )
		{
			$result['IncludeXmlDeclaration'] = true;
		}
		else if (strtolower(trim($val)) == 'dtd' )
		{
			$result['IncludeXmlDeclaration'] = true; // DTD Ѵٸ 翬 XML  ϴ  
			$result['IncludeDtdDeclaration'] = true;
		}
		else if (trim($val) != '')
			$result['DtdPath'] = trim($val);
	}
	return $result;

}
function parse_metadata(&$meta)
{
	$Options = array();
	$authors = '';
	$revisions = '';
	$result = '';
	foreach( $meta as $info)
	{
		$type = key($info);
		$val = $info[$type];
		switch ($type)
		{
			case 'author':
				$authors .= "\t<author>\n\t" . parse_person_info($val) 
					. "\t</author>\n\n";
				break;
			case 'translator':
				$authors .= "\t<othercredit role=\"translator\">\n\t"
					. parse_person_info($val) 
					. "\t</othercredit>\n\n";
				break;
			case 'editor':
				$authors .= "\t<editor>\n\t"
					. parse_person_info($val) 
					. "\t</editor>\n\n";
				break;
			case 'rev':
				$revisions .= parse_revision_info($val);
				break;
			case 'type':
				$Options['DocType'] = trim($val);
				break;
			case 'header':
				$Options['DocHeader'] = parse_header($val);
				break;
		}
	}
	if ($authors != '')
		$result .= "<authorgroup>\n" . $authors . "</authorgroup>\n\n";
		
	if ($revisions != '')
		$result .= "<revhistory>\n" . $revisions . "</revhistory>\n\n";
		
	$Options['Info'] = $result;
	return $Options;
}

function metadata(&$lines, &$transformer)
{
	$result = ' ';
	$line = current($lines);
	
	if ( preg_match("#^\@([^\s]+)\s+(.*)#", $line, $match) )
	{
		if ( $match[1] == '//' )
			$result = '<!-- '. str_replace('--', ' -', $match[2]) . " -->\n";
		else
			$transformer->Params['Info'][] = array($match[1] => $match[2]);
	}
	return $result;

}

?>
