<?php // -*-php-*-
rcs_id('$Id: LikePages.php,v 1.2 2004/03/25 08:15:44 gryu Exp $');

require_once('lib/TextSearchQuery.php');

/**
 */
class WikiPlugin_LikePages
extends WikiPlugin
{
	var $name = 'LikePages';
	
	function getDefaultArguments() {
		// FIXME: how to exclude multiple pages?
		return array('page'		=> false,
			 'prefix'		=> false,
			 'suffix'		=> false,
			 'exclude'		=> false,
			 'noheader'		=> false
		 );
	}

	function run($dbi, $argstr, $request) {
		$args = $this->getArgs($argstr, $request);
		extract($args);
		if (empty($page) && empty($prefix) && empty($suffix))
			return '';

		$html = '';
		if ($prefix) {
			$suffix = false;
			if (!$noheader)
				$html .= QElement('p', sprintf(_T('pages_start_with'),  
					  $prefix));
		}
		elseif ($suffix) {
			if (!$noheader)
				$html .= QElement('p', sprintf(_T('pages_end_with'),  
					  $suffix));
		}
		elseif ($page) {
			$words = explode(" ", split_pagename($page));
			assert($words);
			$prefix = $words[0];
			list($suffix) = array_reverse($words);
			$exclude = $page;

			$fs = _T('like_pages');
			if (!$noheader)
				$html .= Element('p', sprintf(htmlspecialchars($fs), LinkWikiWord($page)));
		}

		// Search for pages containing either the suffix or the prefix.
		$search = array();
		if (!empty($prefix)) {
			$search[] = '(p.pagename LIKE ' . $this->_quote($prefix . '%') .')'; //gryu*
			$match[] = '^' . preg_quote($prefix, '/');
		}
		if (!empty($suffix)) {
			$search[] = '(p.pagename LIKE ' . $this->_quote('%'. $suffix). ')';
			$match[] = preg_quote($suffix, '/') . '$';
		}
		$page_tbl = $dbi->_backend->_table_names['page_tbl'];
		$nonempty_tbl = $dbi->_backend->_table_names['nonempty_tbl'];
		$query = "SELECT p.pagename FROM $page_tbl p INNER JOIN $nonempty_tbl n ON p.id = n.id WHERE " . join(' OR ', $search);
		$result = mysql_query($query);
		$lines = array();		
		while ($line = mysql_fetch_array($result)) {          
			if ($line[0] != $exclude )
				$lines[] = Element('li', LinkWikiWord($line[0]));						
		}

		if ($lines)	
			$html .= Element('ul', join("\n", $lines));
		else
			$html .= '<ul><li>' . _T('none') . '</li></ul>';
		
		return $html;
	}

	function _quote($str) {
		return "'" . str_replace("'", "''", $str) . "'";
	}
};
		
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:   
?>
