<?php
include "lib/stdlib.php";
//include "lib/logger.php";
require_once('lib/Request.php');
require_once("lib/WikiUser.php");
require_once('lib/WikiDB.php');

function is_utf8($string) { // from http://kr.php.net/mb_detect_encoding
  
   // From http://w3.org/International/questions/qa-forms-utf-8.html
   return preg_match('%^(?:
         [\x09\x0A\x0D\x20-\x7E]            # ASCII
       | [\xC2-\xDF][\x80-\xBF]            # non-overlong 2-byte
       |  \xE0[\xA0-\xBF][\x80-\xBF]        # excluding overlongs
       | [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}  # straight 3-byte
       |  \xED[\x80-\x9F][\x80-\xBF]        # excluding surrogates
       |  \xF0[\x90-\xBF][\x80-\xBF]{2}    # planes 1-3
       | [\xF1-\xF3][\x80-\xBF]{3}          # planes 4-15
       |  \xF4[\x80-\x8F][\x80-\xBF]{2}    # plane 16
   )*$%xs', $string);
  
} 

function convert_to_correct_encoding($p)
{
	global $encoding;

	if (!function_exists('iconv')) return $p; // iconv  ȯ ǹ.
	$p_is_utf8 = is_utf8($p);

	if(strtolower($encoding)=='utf-8')
	{
		if(!$p_is_utf8)
			return @iconv("EUC-KR", "UTF-8", $p);
		else return $p;
	}

	if(strtolower($encoding)=='euc-kr')
	{
		if($p_is_utf8)
			return @iconv("UTF-8", "EUC-KR", $p);
		else return $p;
	}
	return $p;
}

function deduce_pagename ($request) {
	$p = HOME_PAGE;
	if ($request->getArg('pagename'))
		$p =  $request->getArg('pagename');
	else
	if (USE_PATH_INFO) {
		$pathinfo = $request->get('PATH_INFO');
		if (ereg('^' . PATH_INFO_PREFIX . '(..*)$', $pathinfo, $m))
			$p = $m[1];
	}
	else
	{
		$query_string = $request->get('QUERY_STRING');
		if (preg_match('/^[^&=]+$/', $query_string))
		$p = urldecode($query_string);
	}
	$p=preg_replace('/\&$/', '', $p);
	return convert_to_correct_encoding($p);
}

function is_safe_action ($action) {
	if (! ZIPDUMP_AUTH and ($action == 'zip'))
		return true;
	return in_array ( $action, array('browse',
		 'info', 'diff', 'search',
		 'edit', 'save',
		 'login', 'logout', 'html',
		 'setprefs', 'random', 'docbook', 'docbookxml', 'js') );
}

function get_auth_mode ($action) {
	switch ($action) {
	case 'logout':
		return  'LOGOUT';
	case 'login':
		return 'LOGIN';
	default:
		if (is_safe_action($action))
			return 'ANON_OK';
		else
			return 'REQUIRE_AUTH';
	}
}

function main ($request) {


	if (USE_PATH_INFO && ! $request->get('PATH_INFO')
		&& ! preg_match(',/$,', $request->get('REDIRECT_URL'))) {
		$request->redirect(SERVER_URL
				. preg_replace('/(\?|$)/', '/\1',
				$request->get('REQUEST_URI'),
										  1));
		exit;
	}

	$request->setArg('pagename', deduce_pagename($request));
	global $pagename;               // FIXME: can we make this non-global?
	$pagename = $request->getArg('pagename');
	
	$action = $request->getArg('action');
	if (!$action)
		$action = 'browse';

	global $user;               // FIXME: can we make this non-global?
	$user = new WikiUser($request, get_auth_mode($action));
	//FIXME:
	//if ($user->is_authenticated())
	//  $LogEntry->user = $user->id();

	// All requests require the database
	global $dbi;                // FIXME: can we keep this non-global?
	$dbi = WikiDB::open($GLOBALS['DBParams']);
	
	if ( $action == 'browse' && $request->getArg('pagename') == HOME_PAGE ) {
		// 'DoyoWiki'   ó  ϰ ⺻  εմϴ.
		if ( ! $dbi->isWikiPage('DoyoWiki') ) {
			include_once("lib/loadsave.php");
			SetupWiki($dbi);
			ExitWiki();
		}
	}

	// FIXME: I think this is redundant.
	if (!is_safe_action($action))
		$user->must_be_admin($action);

	if (isset($DisabledActions) && in_array($action, $DisabledActions))
		ExitWiki(sprintf(gettext(" Ű %s ׼  ֽϴ."), $action));
   
	// Enable the output of most of the warning messages.
	// The warnings will screw up zip files and setpref though.
	if ($action != 'zip' && $action != 'setprefs') {
		global $ErrorManager;
		$ErrorManager->setPostponedErrorMask(E_NOTICE|E_USER_NOTICE);
	}

	switch ($action) {
	case 'edit':
		//$request->compress_output();
		include "lib/editpage.php";
		editPage($dbi, $request);
		break;

	case 'search':
		//$request->compress_output();
		if ($request->getArg('searchtype') == 'full') {
			include "lib/fullsearch.php";
		}
		else {
			include "lib/search.php";
		}
		break;
	  
	case 'save':
		//$request->compress_output();
		include "lib/savepage.php";
		savePage($dbi, $request);
		break;
	case 'info':
		//$request->compress_output();
		include "lib/pageinfo.php";
		break;
	case 'diff':
		//$request->compress_output();
		include_once "lib/diff.php";
		showDiff($dbi, $request);
		break;
	  
	case 'zip':
		include_once("lib/loadsave.php");
		MakeWikiZip($dbi, $request);
		// I don't think it hurts to add cruft at the end of the zip file.
		echo "\n========================================================\n";
		echo "DoyoWiki " . DOYOWIKI_VERSION . " source:\n$GLOBALS[RCS_IDS]\n";
		break;

	case 'upload':
		include_once("lib/loadsave.php");
		LoadPostFile($dbi, $request);
		break;
   
	case 'dumpserial':
		include_once("lib/loadsave.php");
		DumpToDir($dbi, $request);
		break;

	case 'loadfile':
		include_once("lib/loadsave.php");
		LoadFileOrDir($dbi, $request);
		break;

	case 'remove':
		include 'admin/removepage.php';
		break;
	
	case 'lock':
	case 'unlock':
		$user->must_be_admin("lock or unlock pages");
		$page = $dbi->getPage($request->getArg('pagename'));
		$page->set('locked', $action == 'lock');

		//$request->compress_output();
		include_once("lib/display.php");
		displayPage($dbi, $request);
		break;

	case 'setprefs':
		$prefs = $user->getPreferences();
		$edit_area_width = $request->getArg('edit_area_width');
		$edit_area_height = $request->getArg('edit_area_height');
		if ($edit_area_width)
			$prefs['edit_area.width'] = $edit_area_width;
		if ($edit_area_height)
			$prefs['edit_area.height'] = $edit_area_height;
		$user->setPreferences($prefs);
		$ErrorManager->setPostponedErrorMask(E_ALL & ~E_NOTICE);

		//$request->compress_output();
		include_once("lib/display.php");
		displayPage($dbi, $request);
		break;

	case 'random':
		list($pagename) = $dbi->_backend->GetRandomWikiPageNames(1);
		$request->setArg('pagename', $pagename);

	case 'browse':
	case 'login':
	case 'logout':
		//$request->compress_output();
		include_once("lib/display.php");
		displayPage($dbi, $request);
		break;
	case 'docbook':
	case 'docbookxml':
		include_once("lib/output_docbook.php");
		outputDocBook($dbi, $request);
		break;

	case 'js':
		include_once("lib/output_javascript.php");
		outputJavaScript($dbi, $request);
		break;

	default:
		echo QElement('p', sprintf(_T("Wrong action: '%s'"), urlencode($action)));
		break;
	}
	ExitWiki();
}
$includeBaseUrl = false;
$request = new Request;

main($request);


// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:   
?>
