// MyFindPoint.cpp: implementation of the CMyFindPoint class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MyFindPoint.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMyFindPoint::CMyFindPoint()
{
	g_LocalFPS = 0;
	g_mouse_point_font = new CvFont;
	g_time_font = new CvFont;
	g_PreImage = NULL;

	//////////////////////////////////////////////////////////////////////////
	// Font
	cvInitFont(g_mouse_point_font, CV_FONT_HERSHEY_SIMPLEX, 0.3f, 0.3f, 0, 1);
	cvInitFont(g_time_font, CV_FONT_HERSHEY_TRIPLEX, 0.5f, 0.5f, 0, 1);

	m_iSelect_First_Num = 0;
	m_iSelect_Second_Num = 0;

	m_Check_Point_Exist = FALSE;
	m_bDrawCheck = FALSE;
	m_PenWidth = 1;
	m_Color = RGB(0,0,0);

	m_Info_String = "";

	DIFF_POINT_LENGTH = 100;			//  ̵ ִ Ÿ
	FPS_PER_SECOND = 3;			// ð   .
	DIFF_LIMIT_PIX_NUM_MIN = 1;		// ȼ ũ.MAX
	DIFF_LIMIT_PIX_NUM_MAX = 500;	// ȼ ũ.MIN

	m_Event_Start_Time = GetCurrentTime();

	m_pResultImage = NULL;

	m_DiffLimitPixNum = 0;
	m_DiffPoint = 0;
}

CMyFindPoint::~CMyFindPoint()
{

}



//////////////////////////////////////////////////////////////////////////////////
// (ġ) ã
// pImage:   ̹
// pt: ġ   
// return value:  ġ ã TRUE, ã  FALSE
BOOL CMyFindPoint::FindPointer(IplImage* pImage, POINT& pt)
{
	//////////////////////////////////////////////////////////////////////////
	//  ֱ  . ī޶   ٸ.
	cvSmooth(pImage,pImage);
	//	/TEST 
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	// resize image
	
	IplImage *pSmall_Img = cvCreateImage(cvSize(320,240),8,3);	// color + small
	IplImage *pGray_Img = cvCreateImage(cvSize(320,240),8,1);	// gray
	IplImage *pSub_Img = cvCreateImage(cvSize(320,240),8,1);	// sub + gray
	
	
	cvResize(pImage,pSmall_Img);
	cvCvtColor(pSmall_Img,pGray_Img,CV_RGB2GRAY);

	//  ̹  
	if(g_PreImage == NULL)
	{
		g_PreImage = (IplImage *)cvClone(pGray_Img);
	}

	cvSub(pGray_Img,g_PreImage,pSub_Img);

	float resizing_value = (float)(pImage->width) / (float)(pSub_Img->width);

	//////////////////////////////////////////////////////////////////////////
	// Convert GrayImage

	int Max_Y = 0;

	int diff_point = 0;

	m_DiffLimitPixNum = 0;

	for(int y = 0; y < pSub_Img->height; y++)
	{
		for(int x = 0; x < pSub_Img->width; x++)
		{
			int Y = (unsigned char)pSub_Img->imageData[(y * pSub_Img->width)+x];

			if(Max_Y < Y)
			{
				Max_Y = Y;
				pt.x = (int)((float)x * resizing_value);
				pt.y = (int)((float)y * resizing_value);

				diff_point+=Y;
			}

			if(Y > 10)		//  ȭ Ѱ...( ī޶ ɿ ... )
			{
				m_DiffLimitPixNum++;
			}
		}
	}

	/*	// ׽Ʈ ̹ ( ȼ ȼ  ̹ )

	cvNamedWindow("pSub_Img");
	cvShowImage("pSub_Img",pSub_Img);
	  
	cvNamedWindow("preimage");
	cvShowImage("preimage",g_PreImage);

	cvNamedWindow("pGray_Img");
	cvShowImage("pGray_Img",pGray_Img);
		*/

	//////////////////////////////////////////////////////////////////////////
	// Ʋ ȼ  .
	
	m_DiffPoint = diff_point;

	char temp[1024];
	sprintf(temp,"Diff Light : %d",diff_point);	
//    cvPutText(pImage, temp, cvPoint(10, 90), g_time_font, CV_RGB(255,0,0));

	if( 
		m_DiffLimitPixNum < DIFF_LIMIT_PIX_NUM_MIN ||
		m_DiffLimitPixNum > DIFF_LIMIT_PIX_NUM_MAX)
	{
		//////////////////////////////////////////////////////////////////////////
		// ڷḦ ʱȭ  .
		g_draw_point.clear();
		v_point.clear();
		
		if(g_PreImage != NULL)
		{
			cvReleaseImage(&g_PreImage);
			g_PreImage = NULL;
		}
		g_PreImage = (IplImage *)cvClone(pGray_Img);
		
		cvReleaseImage(&pSub_Img);
		cvReleaseImage(&pSmall_Img);
		cvReleaseImage(&pGray_Img);
		
		return FALSE;
	}
	//
	//////////////////////////////////////////////////////////////////////////

	if( 0 >= pt.x || pt.x >= pImage->width || 0 >= pt.y || pt.y >= pImage->height )
	{
		//////////////////////////////////////////////////////////////////////////
		// Ʈ ã  ڷ ʱȭ
		g_draw_point.clear();
		v_point.clear();
		
		if(g_PreImage != NULL)
		{
			cvReleaseImage(&g_PreImage);
			g_PreImage = NULL;
		}	
		g_PreImage = (IplImage *)cvClone(pGray_Img);
		
		cvReleaseImage(&pSub_Img);
		cvReleaseImage(&pSmall_Img);
		cvReleaseImage(&pGray_Img);

		return FALSE;	
	}
	
	//////////////////////////////////////////////////////////////////////////
	//
	// ִ  Ʈ κ üũ!
	// ʴ 15 .
	// 1ʵ  ̹ ̿ Ʈ .
	//  Ʈ .
	//
	//////////////////////////////////////////////////////////////////////////

	//   ̹ .
	if(g_PreImage != NULL)
	{
		cvReleaseImage(&g_PreImage);
	}
	g_PreImage = NULL;
	g_PreImage = (IplImage *)cvClone(pGray_Img);

	cvReleaseImage(&pSub_Img);
	cvReleaseImage(&pSmall_Img);
	cvReleaseImage(&pGray_Img);
	
	return TRUE;
}



float CMyFindPoint::GetTwoPointLength(CvPoint p1,CvPoint p2)
{
	return sqrt((float)((float)(p1.x - p2.x)*(float)(p1.x - p2.x)) + 
		(float)((float)(p1.y - p2.y)*(float)(p1.y - p2.y)));
}

void CMyFindPoint::DrawLine_AppWnd(IplImage *pImage, COLORREF color,int Line_Scale)
{
	if(g_draw_point.size() == 0)
		return;
	//////////////////////////////////////////////////////////////////////////
	// *  ̹ ׸
	
	vector<POINT>::iterator it = g_draw_point.begin();
	POINT tmp;
	tmp.x = it->x;
	tmp.y = it->y;
	it++;
	while(it != g_draw_point.end())
	{
		//////////////////////////////////////////////////////////////////////////
		//   ȼ  Ÿ .
		if(GetTwoPointLength(cvPoint(tmp.x,tmp.y),cvPoint(it->x,it->y)) < DIFF_POINT_LENGTH)
			cvLine(pImage,cvPoint(tmp.x,tmp.y),cvPoint(it->x,it->y),CV_RGB(255,0,0),Line_Scale);
		tmp.x = it->x;
		tmp.y = it->y;

		it++;
	}
	//
	//////////////////////////////////////////////////////////////////////////
	
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//	* ȭ鿡 ׸.

	RECT rect;
	HWND hWnd =	::GetDesktopWindow();
	::GetClientRect(hWnd,&rect);

	float dep_x = (float)pImage->width / (float)rect.right;
	float dep_y = (float)pImage->height / (float)rect.bottom;

	HDC dc;
	dc = (HDC)::GetWindowDC(hWnd);

	HPEN MyPen = CreatePen(PS_SOLID, Line_Scale, color);
	HPEN OldPen = (HPEN)SelectObject(dc, MyPen);

//	InvalidateRect(GetWindow(hWnd,GW_OWNER),&rect,FALSE);		// üȭ .

	/*
	SelectObject(hdc, OldPen);
	DeleteObject(MyPen);
	EndPaint(hWnd,&ps);
*/

	//////////////////////////////////////////////////////////////////////////
	// Draw
	if(g_draw_point.size() == 0)
		return;
	//////////////////////////////////////////////////////////////////////////
	// * Test Draw
	
	it = g_draw_point.begin();
	tmp.x = it->x;
	tmp.y = it->y;
	it++;
	while(it != g_draw_point.end())
	{
		//////////////////////////////////////////////////////////////////////////
		//   ȼ  Ÿ .
		if(GetTwoPointLength(cvPoint(tmp.x,tmp.y),cvPoint(it->x,it->y)) < DIFF_POINT_LENGTH)
		{
			MoveToEx(dc,tmp.x/ dep_x,(tmp.y/ dep_y),NULL);
			LineTo(dc,it->x/ dep_x,(it->y/ dep_y));
		}
		tmp.x = it->x;
		tmp.y = it->y;

		it++;
	}
	//
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////

	::ReleaseDC(hWnd,dc);
}

void CMyFindPoint::Mouse_Move(POINT pt, IplImage *pImage)
{
	RECT rect;
	HWND hWnd =	::GetDesktopWindow();
	::GetClientRect(hWnd,&rect);

	float dep_x = (float)pImage->width / (float)rect.right;
	float dep_y = (float)pImage->height / (float)rect.bottom;

	POINT window_pt;
	window_pt.x = (pt.x / dep_x);
	window_pt.y = (pt.y / dep_y);

	SetCursorPos(window_pt.x,window_pt.y);
	
}

POINT CMyFindPoint::GetRealLazerPoint(POINT &point, IplImage *image)
{
	int SavePointNum = 5;

	if(g_LocalFPS != 0)
		SavePointNum = (int)((float)g_LocalFPS/(float)FPS_PER_SECOND);	// ʴ /x ŭ Ϳ .
	else
		SavePointNum = 5;

	POINT returnPoint;	// return Point
	returnPoint.x = 0;
	returnPoint.y = 0;

	// Ʈ  ڷḦ ʱȭ մϴ.
	if( point.y < 0  || 480 < point.y || point.x < 0 || 640 < point.x)
	{
		v_point.clear();
		returnPoint.x = 0;
		returnPoint.y = 0;
		return returnPoint;
	}

	v_point.push_back(point);	//  Ʈ .
	if(v_point.size() > SavePointNum)		//  Ʈ϶ մϴ.
	{
		v_point.erase(v_point.begin());

		vector<POINT>::iterator it = v_point.begin();
		
		while(it != v_point.end())
		{
			returnPoint.x += it->x;
			returnPoint.y += it->y;
			it++;
		}
		if(v_point.size() != 0)
		{
			returnPoint.x /= v_point.size();	//  Ʈ ġ  .
			returnPoint.y /= v_point.size();
		}
		
	}
	else	//  Ʈ 5 ̸϶...
	{
		vector<POINT>::iterator it = v_point.begin();
		
		while(it != v_point.end())
		{
			returnPoint.x += it->x;
			returnPoint.y += it->y;
			it++;
		}	
		returnPoint.x /= v_point.size();		//   Ʈ ո .
		returnPoint.y /= v_point.size();
	}
	return returnPoint;
}

void CMyFindPoint::Check_Time(IplImage *pImage)		//  ð üũ.
{
	//////////////////////////////////////////////////////////////////////////
	// * static  .
	static int framecount = 0;	//  īƮ
	static double time_check_present = GetCurrentTime();
	static double this_time = GetCurrentTime();		// ʴ  īƮ
	//
	//////////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////////
	//	* ð üũ
	
	char temp[1024];
	framecount++;
	if(GetCurrentTime() - this_time > 1000)
	{
		this_time = GetCurrentTime();
		g_LocalFPS = framecount;
		framecount = 0;
	}
	sprintf(temp,"FPS : %d",g_LocalFPS);	
 //   cvPutText(pImage, temp, cvPoint(10, 10), g_time_font, CV_RGB(255,0,0));

	sprintf(temp,"SEC : %f",(float)(GetCurrentTime() - time_check_present));
	time_check_present = GetCurrentTime();
//	cvPutText(pImage, temp, cvPoint(10, 30), g_time_font, CV_RGB(255,0,0));
	//
	//////////////////////////////////////////////////////////////////////////
}

//////////////////////////////////////////////////////////////////////////////////
// ڸũ ǥ
// pImage:   ̹
// dot:  ũ  ġ
void CMyFindPoint::MarkCross(IplImage* pImage, POINT dot)
{
		
//	int i, j, index;
	int length = 5;

	cvLine(pImage,
		cvPoint(dot.x - length , dot.y - length),
		cvPoint(dot.x + length , dot.y + length),CV_RGB(0,255,0),1);
	cvLine(pImage,
		cvPoint(dot.x + length , dot.y - length),
		cvPoint(dot.x - length , dot.y + length),CV_RGB(0,255,0),1);


	// 
	/*
	for(j = dot.y-length; j <= dot.y+length; j++)
	{
		if(j < 0 || j >= SH) continue;
		index = j*SW;
		*(pImage->imageData + 3*(index+dot.x)+0) = 0;
		*(pImage->imageData + 3*(index+dot.x)+1) = (char)255;
		*(pImage->imageData + 3*(index+dot.x)+2) = 0;
	}
	// 
	index = dot.y*SW;
	for(i = dot.x-length; i <= dot.x+length; i++)
	{
		if(i < 0 || i >= SW) continue;
		*(pImage->imageData + 3*(index+i)+0) = 0;
		*(pImage->imageData + 3*(index+i)+1) = (char)255;
		*(pImage->imageData + 3*(index+i)+2) = 0;
	}
	*/
}

void CMyFindPoint::PrintNoFind(IplImage *pImage)
{
	char temp[1024];
	sprintf(temp,"Lazer Pointer - Don't Find!!",g_LocalFPS);	
    //cvPutText(pImage, temp, cvPoint(10, 50), g_time_font, CV_RGB(255,0,0));
}

void CMyFindPoint::PrintFind(IplImage *pImage)
{
	char temp[1024];
	sprintf(temp,"Lazer Pointer - Find!!",g_LocalFPS);	
//    cvPutText(pImage, temp, cvPoint(10, 70), g_time_font, CV_RGB(255,0,0));
}

void CMyFindPoint::CVPROnFrame(IplImage* pImage)	
{
	IplImage *tempimage = (IplImage *)cvCloneImage(pImage);
	POINT dot = {-1, -1};

	m_FinalSelect_Num = 0;

	//////////////////////////////////////////////////////////////////////
	// (ġ) ã..ã FALSE .
	if(FindPointer(tempimage, dot) == FALSE)
	{
		m_Check_Point_Exist = FALSE;
		// ͸  ã  ð .
		m_ButtonUpTime = GetCurrentTime();
		m_ButtonUp_Point = m_ButtonDown_Point;
		m_iSelect_First_Num = m_iSelect_Second_Num;

		//////////////////////////////////////////////////////////////////////////
		// ͸ ã  - ȭ .
		PrintNoFind(tempimage);
		
		//////////////////////////////////////////////////////////////////////////
		// Draw Line
		if(m_bDrawCheck == TRUE)
			DrawLine_AppWnd(tempimage,m_Color,m_PenWidth);

		m_bEvent_Point = FALSE;	// Ͱ ޴  ö TRUE

		
	}
	else
	{
		m_Check_Point_Exist = TRUE;
		//////////////////////////////////////////////////////////////////////////
		//  ã ǥ.
		PrintFind(tempimage);

		//////////////////////////////////////////////////////////////////////////
		// ͸ Ϳ ְ ׸.

		RECT rect;
		HWND hWnd =	::GetDesktopWindow();
		::GetClientRect(hWnd,&rect);
		
		POINT pt = GetRealLazerPoint(dot, tempimage);

		m_RealPoint = pt;

		POINT re_pt;
		re_pt.x = rect.right - pt.x;
		re_pt.y = rect.bottom - pt.y;
		g_draw_point.push_back(pt);
		
		//////////////////////////////////////////////////////////////////////////
		// Draw Line
		if(m_bDrawCheck == TRUE)
		{
			DrawLine_AppWnd(tempimage,m_Color,m_PenWidth);
		}

		//////////////////////////////////////////////////////////////////////////
		// Mouse Move
		if(MOUSE_MOVE)
			Mouse_Move(dot,tempimage);

		//////////////////////////////////////////////////////////////////////
		// ڸũ
		MarkCross(tempimage, pt);
		
		//////////////////////////////////////////////////////////////////////
		// ̺Ʈó
		m_bEvent_Point = Get_Check_Btn_Into_Position(tempimage,pt);
		if(m_bEvent_Point == TRUE)
		{
			m_iSelect_Second_Num = Get_Event_Number(tempimage, pt);
			
			// ͸ ã  ð .
			m_ButtonDownTime = GetCurrentTime();
			m_ButtonDown_Point = dot;
			
			//////////////////////////////////////////////////////////////////////////
			// *  Ʈ  100̻ 1000Ϸ Ѵ.
			// * Ŭ  Ŭ  ư  ƾ Ѵ.
			double diff_time = fabs(m_ButtonDownTime - m_ButtonUpTime);
			if(m_iSelect_Second_Num == m_iSelect_First_Num && 100 < diff_time && diff_time < 500)
			{	// Ŭ    Ŭ Ҷ ð 100~500
				char temp[1024];
				sprintf(temp,"Select Number :  %d",m_iSelect_Second_Num);	
				//cvPutText(tempimage, temp, cvPoint(10, 150), g_time_font, CV_RGB(255,255,0));
				
				// õ ̺Ʈ ȣ
				if((GetCurrentTime() - m_Event_Start_Time) > 1000)
				{
					m_Event_Start_Time = GetCurrentTime();
					Play_Event(m_iSelect_Second_Num);
				}
				
				
				m_FinalSelect_Num = m_iSelect_Second_Num;
			}
		}
	}
	char temp[1024];
	sprintf(temp,"Select Number :  %.0f %.0f %d %d",
		m_ButtonDownTime,m_ButtonUpTime,m_iSelect_First_Num,m_iSelect_Second_Num);	
//	cvPutText(tempimage, temp, cvPoint(10, 170), g_time_font, CV_RGB(255,255,0));
	
	//////////////////////////////////////////////////////////////////////////
	// ð üũ
	Check_Time(tempimage);

	if(OUTPUT_TEST_IMAGE)
	{
		//////////////////////////////////////////////////////////////////////////
		// ׽Ʈ ̹ 
		cvNamedWindow("FindPoint",0);
		cvShowImage("FindPoint",tempimage);	
		//
		//////////////////////////////////////////////////////////////////////////	
	}
	m_pResultImage = (IplImage *)cvCloneImage(tempimage);
 	
	cvReleaseImage(&tempimage);
}

BOOL CMyFindPoint::Get_Check_Btn_Into_Position(IplImage *image, POINT pt)
{
	int width = 320;
	int height = 240;

	if(width - (float)width * 0.15f < pt.x && pt.x < width &&
		(float)height * 0.2f < pt.y && pt.y < (float)height * 0.8f)
	{
		char temp[1024];
		sprintf(temp,"INTO TRUE",g_LocalFPS);	
//		cvPutText(image, temp, cvPoint(10, 110), g_time_font, CV_RGB(255,0,0));
		return TRUE;
	}
	else
	{
		char temp[1024];
		sprintf(temp,"INTO FALSE",g_LocalFPS);	
//		cvPutText(image, temp, cvPoint(10, 110), g_time_font, CV_RGB(255,0,0));
		return FALSE;
	}
}

int CMyFindPoint::Get_Event_Number(IplImage *image, POINT pt)
{
	int height = 240;
	float btn_height = 240.0f/14.0f * 0.6f;
	float btn_top = 240.0f * 0.2f;

	char temp[1024];
	sprintf(temp,"INTO FALSE",g_LocalFPS);
	
	if((int)(btn_height*(1+0)) + btn_top < pt.y && pt.y < (int)(btn_height*(1+1)) + btn_top )	// 1 ̺Ʈ
	{
		sprintf(temp,"Event 1",g_LocalFPS);
		cvPutText(image, temp, cvPoint(10, 200), g_time_font, CV_RGB(255,0,0));
		return 1;
	}
	if((int)(btn_height*(1+1)) + btn_top  < pt.y && pt.y < (int)(btn_height*(1+2)) + btn_top )	// 1 ̺Ʈ
	{
		sprintf(temp,"Event 2",g_LocalFPS);
		cvPutText(image, temp, cvPoint(10, 200), g_time_font, CV_RGB(255,0,0));
		return 2;
	}
	if((int)(btn_height*(1+2)) + btn_top  < pt.y && pt.y < (int)(btn_height*(1+3)) + btn_top )	// 1 ̺Ʈ
	{
		sprintf(temp,"Event 3",g_LocalFPS);
		cvPutText(image, temp, cvPoint(10, 200), g_time_font, CV_RGB(255,0,0));
		return 3;
	}
	if((int)(btn_height*(1+3)) + btn_top  < pt.y && pt.y < (int)(btn_height*(1+4)) + btn_top )	// 1 ̺Ʈ
	{
		sprintf(temp,"Event 4",g_LocalFPS);
		cvPutText(image, temp, cvPoint(10, 200), g_time_font, CV_RGB(255,0,0));
		return 4;
	}
	if((int)(btn_height*(1+4)) + btn_top  < pt.y && pt.y < (int)(btn_height*(1+5)) + btn_top )	// 1 ̺Ʈ
	{
		sprintf(temp,"Event 5",g_LocalFPS);
		cvPutText(image, temp, cvPoint(10, 200), g_time_font, CV_RGB(255,0,0));
		return 5;
	}
	if((int)(btn_height*(1+5)) + btn_top  < pt.y && pt.y < (int)(btn_height*(1+6)) + btn_top )	// 1 ̺Ʈ
	{
		sprintf(temp,"Event 6",g_LocalFPS);
		cvPutText(image, temp, cvPoint(10, 200), g_time_font, CV_RGB(255,0,0));
		return 6;
	}
	if((int)(btn_height*(1+6)) + btn_top  < pt.y && pt.y < (int)(btn_height*(1+7)) + btn_top )	// 1 ̺Ʈ
	{
		sprintf(temp,"Event 7",g_LocalFPS);
		cvPutText(image, temp, cvPoint(10, 200), g_time_font, CV_RGB(255,0,0));
		return 7;
	}
	if((int)(btn_height*(1+7)) + btn_top  < pt.y && pt.y < (int)(btn_height*(1+8)) + btn_top )	// 1 ̺Ʈ
	{
		sprintf(temp,"Event 8",g_LocalFPS);
		cvPutText(image, temp, cvPoint(10, 200), g_time_font, CV_RGB(255,0,0));
		return 8;
	}
	if((int)(btn_height*(1+8)) + btn_top  < pt.y && pt.y < (int)(btn_height*(1+9)) + btn_top )	// 1 ̺Ʈ
	{
		sprintf(temp,"Event 9",g_LocalFPS);
		cvPutText(image, temp, cvPoint(10, 200), g_time_font, CV_RGB(255,0,0));
		return 9;
	}
	if((int)(btn_height*(1+9)) + btn_top  < pt.y && pt.y < (int)(btn_height*(1+10)) + btn_top )	// 1 ̺Ʈ
	{
		sprintf(temp,"Event 10",g_LocalFPS);
		cvPutText(image, temp, cvPoint(10, 200), g_time_font, CV_RGB(255,0,0));
		return 10;
	}
	if((int)(btn_height*(1+10)) + btn_top  < pt.y && pt.y < (int)(btn_height*(1+11)) + btn_top )	// 1 ̺Ʈ
	{
		sprintf(temp,"Event 11",g_LocalFPS);
		cvPutText(image, temp, cvPoint(10, 200), g_time_font, CV_RGB(255,0,0));
		return 11;
	}
	if((int)(btn_height*(1+11)) + btn_top  < pt.y && pt.y < (int)(btn_height*(1+12)) + btn_top )	// 1 ̺Ʈ
	{
		sprintf(temp,"Event 12",g_LocalFPS);
		cvPutText(image, temp, cvPoint(10, 200), g_time_font, CV_RGB(255,0,0));
		return 12;
	}

	return 0;
}

void CMyFindPoint::Play_Event(int EventNumber)
{	
	switch(EventNumber)
	{
	case 1:
		// Edit Box
//		m_pMyViewDlg->EditBox_InputString("Point Into Edit Box");	
		break;
	case 2:
		// Draw
		if(m_bDrawCheck == TRUE)
		{
			m_bDrawCheck = FALSE;
		}
		else
		{
			m_bDrawCheck = TRUE;
		}
		break;
	case 3:
		// PenWidth1
		m_PenWidth = 1;
		break;
	case 4:
		// PenWidth2
		m_PenWidth = 3;
		break;
	case 5:
		// Red
		m_Color = RGB(255,0,0);
		break;
	case 6:
		// Blue
		m_Color = RGB(0,0,255);
		break;
	case 7:
		// white
		m_Color = RGB(255,255,255);
		break;
	case 8:
		// Black
		m_Color = RGB(0,0,0);
		break;
	case 9:
		// Eraser
		m_BackgroundController.Background_Eraser();
		break;
	case 10:
		// PageUp
		keybd_event(VK_PRIOR, MapVirtualKey(VK_PRIOR,0), 0, 0);	// keydown
		Sleep(50);
		keybd_event(VK_PRIOR, MapVirtualKey(VK_PRIOR,0), KEYEVENTF_KEYUP, 0);
		break;
	case 11:
		// PageDown
		
		keybd_event(VK_NEXT, MapVirtualKey(VK_NEXT,0), 0, 0);	// keydown
		Sleep(50);
		keybd_event(VK_NEXT, MapVirtualKey(VK_NEXT,0), KEYEVENTF_KEYUP, 0);
		break;
	case 12:
		// 
		m_BackgroundController.Background_Eraser();
		exit(1);
		break;
	}

	Set_EditBox_Info();
}

void CMyFindPoint::Set_EditBox_Info()
{
	CString bDraw_str, Color_str, PenWidth_str;
	if(m_bDrawCheck == TRUE)
	{
		bDraw_str.Format("Draw!");
	}
	else
	{
		bDraw_str.Format("No Draw!");
	}

	//////////////////////////////////////////////////////////////////////////

	if(m_PenWidth == 1)
	{
		PenWidth_str.Format("");
	}
	else
	{
		PenWidth_str.Format("β");
	}

	//////////////////////////////////////////////////////////////////////////
	
	if(m_Color == RGB(255,0,0))
	{
		Color_str.Format("");
	}
	else if(m_Color == RGB(0,0,255))
	{
		Color_str.Format("Ķ");
	}
	else if(m_Color == RGB(255,255,255))
	{
		Color_str.Format("");
	}
	else if(m_Color == RGB(0,0,0))
	{
		Color_str.Format("");
	}
	
	m_Info_String.Format("%s - %s - %s",bDraw_str,PenWidth_str,Color_str);
	
}
