// MyCalibrate.cpp: implementation of the CMyCalibrate class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MyCalibrate.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMyCalibrate::CMyCalibrate()
{
	m_pMainImage = NULL;
	m_pDeleteAreaImage = NULL;
	m_pMousePadImage = NULL;
	m_pResultImage = NULL;
	m_pRectangleLineImage = NULL;

	CENTER_POINT_LIGHT = 50;		//    
}

CMyCalibrate::~CMyCalibrate()
{
	if(m_pDeleteAreaImage != NULL)
		cvReleaseImage(&m_pDeleteAreaImage);
	if(m_pMousePadImage != NULL)
		cvReleaseImage(&m_pMousePadImage);
}



void CMyCalibrate::Save_MousePad_OutArea()
{

	if(m_pMainImage == NULL)
		return;

	// ü 
	IplImage *pTempImage = cvCreateImage(cvGetSize(m_pMainImage),8,3);
	IplImage *pYCbCrImage = cvCreateImage(cvGetSize(m_pMainImage),8,3);
	IplImage *pEdgeImage = cvCreateImage(cvGetSize(m_pMainImage),8,1);
	IplImage *pGrayImage = cvCreateImage(cvGetSize(m_pMainImage),8,1);

	// ̹ μ
	cvCvtColor(m_pMainImage,pYCbCrImage,CV_RGB2YCrCb);
	cvCvtColor(m_pMainImage,pEdgeImage,CV_RGB2GRAY);
	cvSmooth(pEdgeImage,pEdgeImage,CV_MEDIAN,3);

	//////////////////////////////////////////////////////////////////////////
	// TEST OUTPUT
//	cvNamedWindow("Gray");
//	cvShowImage("Gray",pEdgeImage);
	//
	/////////////////////////////////////////////////////////////////////////

	cvCanny(pEdgeImage,pEdgeImage,100,100);
	cvDilate(pEdgeImage,pEdgeImage,NULL,1);
	cvNot(pEdgeImage,pEdgeImage);
	// YCbCr Color  .
	int Y = (uchar)(pYCbCrImage->imageData[pYCbCrImage->widthStep * pYCbCrImage->height/2 + pYCbCrImage->width/2*3+0]);
	int Cb = (uchar)(pYCbCrImage->imageData[pYCbCrImage->widthStep * pYCbCrImage->height/2 + pYCbCrImage->width/2*3+1]);
	int Cr = (uchar)(pYCbCrImage->imageData[pYCbCrImage->widthStep * pYCbCrImage->height/2 + pYCbCrImage->width/2*3+2]);

	// Make 'pTempImage'
	cvFillImage(pTempImage,0x000000);
	for(int i = 0;i<pYCbCrImage->height;i++)
	{
		for(int j = 0;j<pYCbCrImage->widthStep;j+=3)
		{
			int y = (uchar)(pYCbCrImage->imageData[i*pYCbCrImage->widthStep+j+0]);
			int cb = (uchar)(pYCbCrImage->imageData[i*pYCbCrImage->widthStep+j+1]);
			int cr = (uchar)(pYCbCrImage->imageData[i*pYCbCrImage->widthStep+j+2]);

			if(abs(Y-y) < 80 && abs(Cb-cb) < 15 && abs(Cr-cr) < 15)
			{
				pTempImage->imageData[i*pYCbCrImage->widthStep+j+0] = (uchar)255;
				pTempImage->imageData[i*pYCbCrImage->widthStep+j+1] = (uchar)255;
				pTempImage->imageData[i*pYCbCrImage->widthStep+j+2] = (uchar)255;
			}
		}
	}
	
	cvCvtColor(pTempImage,pGrayImage,CV_RGB2GRAY);

	//////////////////////////////////////////////////////////////////////////
	// TEST OUTPUT
//	cvNamedWindow("YCbCr Color  ");
//	cvShowImage("YCbCr Color  ",pGrayImage);
	//
	//////////////////////////////////////////////////////////////////////////

	/////////////////////////////////////////////////////////////////////////
	// pTempImage and pGrayImage = pGrayImage
	cvAnd(pGrayImage,pEdgeImage,pGrayImage);
/*	
	//////////////////////////////////////////////////////////////////////////
	// Check OUTPUT
	cvNamedWindow("EdgeImage");
	cvShowImage("EdgeImage",pEdgeImage);
	cvNamedWindow("ColorAreaImage & EdgeImage");
	cvShowImage("ColorAreaImage & EdgeImage",pGrayImage);
	//
	//////////////////////////////////////////////////////////////////////////
*/
	
	

	cvReleaseImage(&pEdgeImage);
	cvReleaseImage(&pYCbCrImage);
	cvReleaseImage(&pTempImage);

	Get_MousePad_Area_Contour(pGrayImage);

	cvReleaseImage(&pGrayImage);

	
}

void CMyCalibrate::Save_MousePad_OutArea2()
{

	if(m_pMainImage == NULL)
		return;

	// ü 
	IplImage *pTempImage = cvCreateImage(cvGetSize(m_pMainImage),8,1);
	IplImage *pEdgeImage = cvCreateImage(cvGetSize(m_pMainImage),8,1);
	IplImage *pGrayImage = cvCreateImage(cvGetSize(m_pMainImage),8,1);

	// ̹ μ
	
	cvCvtColor(m_pMainImage,pGrayImage,CV_RGB2GRAY);
	cvCopyImage(pGrayImage,pEdgeImage);
	cvSmooth(pEdgeImage,pEdgeImage,CV_MEDIAN,3);

	cvCanny(pEdgeImage,pEdgeImage,100,100);
	cvDilate(pEdgeImage,pEdgeImage,NULL,1);
	cvNot(pEdgeImage,pEdgeImage);
	// YCbCr Color  .

	int gray = (uchar)pGrayImage->imageData[(pGrayImage->height/2*pGrayImage->width)+pGrayImage->width/2];
	
	cvFillImage(pTempImage,0x000000);

	for(int y = 0;y<pTempImage->height;y++)
	{
		for(int x = 0;x<pTempImage->width;x++)
		{
			if(abs((int)((unsigned char)(pGrayImage->imageData[(y*pTempImage->width)+x])) - gray) < CENTER_POINT_LIGHT)
			{
				pTempImage->imageData[(y*pTempImage->width)+x] = (unsigned char)255;
			}
		}
	}

	/////////////////////////////////////////////////////////////////////////
	// pTempImage and pGrayImage = pGrayImage
	cvAnd(pTempImage,pEdgeImage,pGrayImage);

		// And  Ȯ ̹.
/*
	cvNamedWindow("CutImage");
	cvShowImage("CutImage",pGrayImage);

	cvNamedWindow("TmpImage");
	cvShowImage("TmpImage",pTempImage);

	cvNamedWindow("EdgeImage");
	cvShowImage("EdgeImage",pEdgeImage);
	*/

		// ߸  ̹.
	
/*	*/
//	m_Screen_Result->MainImageCopy(pGrayImage);
//	m_Screen_Result->Invalidate(TRUE);

	Get_MousePad_Area_Contour(pGrayImage);

	cvReleaseImage(&pEdgeImage);
	cvReleaseImage(&pTempImage);
	cvReleaseImage(&pGrayImage);	
}

void CMyCalibrate::Get_MousePad_Area_Contour(IplImage *pGrayImage)
{
	IplImage *pTempImage = cvCreateImage(cvGetSize(m_pMainImage),8,3);
	cvFillImage(pTempImage,0xffffff);
	CvSeq* contour = 0;
	CvMemStorage* storage = cvCreateMemStorage(0);
	cvFindContours( pGrayImage, storage, &contour, sizeof(CvContour), CV_RETR_LIST,CV_CHAIN_APPROX_SIMPLE);

	double save_len = 0;
	for(; contour != 0; contour = contour->h_next) //this is 
	{
		double block = cvContourArea(contour,CV_WHOLE_SEQ);	//  ϱ.

		if(block < save_len)
			save_len = block;
	}

	cvReleaseMemStorage( &storage ); 
	storage = cvCreateMemStorage(0);

	cvFindContours( pGrayImage, storage, &contour, sizeof(CvContour), CV_RETR_LIST,CV_CHAIN_APPROX_NONE);

	for(; contour != 0; contour = contour->h_next) //this is 
	{
		double block = cvContourArea(contour,CV_WHOLE_SEQ);	//  ϱ.

		if(block == save_len)
		{
			cvDrawContours( pTempImage, contour, CV_RGB(0,0,0), CV_RGB(0,0,0), -1, -1, 8 );
		}
	}

	cvNot(pTempImage,pTempImage);
	//////////////////////////////////////////////////////////////////////////
	// Check OUTPUT
//	cvNamedWindow(" ̹");
//	cvShowImage(" ̹",pTempImage);
	//
	//////////////////////////////////////////////////////////////////////////

	if(m_pDeleteAreaImage != NULL)
		cvReleaseImage(&m_pDeleteAreaImage);
	
	m_pDeleteAreaImage = (IplImage *)cvClone(pTempImage);
	
//	cvNamedWindow("Cutting ̹");
//	cvShowImage("Cutting ̹",m_pDeleteAreaImage);

	Find_CornerPoint(m_pDeleteAreaImage);
	
//	FindHand();

	cvReleaseMemStorage( &storage );
	cvReleaseImage(&pTempImage);
}

void CMyCalibrate::FindHand()
{
	if(m_pMousePadImage != NULL)
	{
		cvReleaseImage(&m_pMousePadImage);
	}
	m_pMousePadImage = cvCreateImage(cvGetSize(m_pMainImage),8,3);
	cvAnd(m_pMainImage,m_pDeleteAreaImage,m_pMousePadImage);
}


void CMyCalibrate::Find_CornerPoint(IplImage *pConerFindImage)
{
	//////////////////////////////////////////////////////////////////////////
	//
	if(m_pRectangleLineImage != NULL)
	{
		cvReleaseImage(&m_pRectangleLineImage);
		m_pRectangleLineImage = cvCreateImage(cvGetSize(pConerFindImage),8,1);
	}
	else
	{
		m_pRectangleLineImage = cvCreateImage(cvGetSize(pConerFindImage),8,1);
	}
	
	cvCvtColor(pConerFindImage,m_pRectangleLineImage,CV_RGB2GRAY);

	cvCanny(m_pRectangleLineImage,m_pRectangleLineImage,100,100);

//	cvNamedWindow("Corner");
//  	cvShowImage("Corner",m_pRectangleLineImage);

	CvMemStorage *storage = cvCreateMemStorage(0);
	CvSeq *lines = cvHoughLines2( m_pRectangleLineImage, storage, CV_HOUGH_PROBABILISTIC, 1, CV_PI/180, 30, 10, 10);
	cvFillImage(m_pRectangleLineImage,0x000000);
	int m_linedect = lines->total;

	MyCheckLine *Check_Line = new MyCheckLine[m_linedect];

	for(int i = 0; i < lines->total; i++ )	//  ߰ߵ μ
	{
		CvPoint* line = (CvPoint*)cvGetSeqElem(lines,i);
		cvLine( m_pRectangleLineImage, line[0], line[1], CV_RGB(50,50,50), 1 );

		Check_Line[i].line1= line[0];
		Check_Line[i].line2= line[1];
		
		if(line[1].x == line[0].x)
		{
			Check_Line[i].x_eq = TRUE;
		}
		else
		{
			Check_Line[i].x_eq = FALSE;						
			if(line[1].y == line[0].y)
			{
//				Check_Line[i].p_m = TRUE;
				Check_Line[i].d = 0;
			}
			else
			{
				if((line[1].x < line[0].x && line[1].y < line[0].y) ||
					(line[1].x > line[0].x && line[1].y > line[0].y))
				{
					Check_Line[i].d = fabs((float)(line[1].y - line[0].y)/(float)(line[1].x - line[0].x));
				}
				else
				{
					Check_Line[i].d = -fabs((float)(line[1].y - line[0].y)/(float)(line[1].x - line[0].x));
				}
			}
		}
		
	}
	DrawCornerPoint(m_pRectangleLineImage,Check_Line,m_linedect);

			// 簢   ̹.
//	cvNamedWindow("Line");
//	cvShowImage("Line",m_pRectangleLineImage);
	
	//////////////////////////////////////////////////////////////////////////
//	m_Screen_Line->MainImageCopy(m_pRectangleLineImage);
//	m_Screen_Line->Invalidate(TRUE);
	//////////////////////////////////////////////////////////////////////////

	cvReleaseMemStorage(&storage);
	//
	//////////////////////////////////////////////////////////////////////////
}

void CMyCalibrate::DrawCornerPoint(IplImage *image, MyCheckLine *Check_Line,int count)
{
	// vector  POINT .
	vector<CPoint> Check_Point;

	//////////////////////////////////////////////////////////////////////////
	//	*  .
	for(int i = 0;i<count-1;i++)
	{
		for(int j = i;j<count;j++)
		{
			if(!(fabs(Check_Line[i].d - Check_Line[j].d) < 1.0 || i == j) &&
				!(fabs(Check_Line[i].d) > 10 && fabs(Check_Line[j].d) > 10))
			{
				float x,y;
				if(Check_Line[i].x_eq == TRUE)
				{
					x = (float)(Check_Line[i].line1.x);
					y = ((float)Check_Line[j].d*
						(x - (float)Check_Line[j].line1.x)+(float)Check_Line[j].line1.y);
				}
				else if(Check_Line[j].x_eq == TRUE)
				{
					x = (float)(Check_Line[j].line1.x);
					y = ((float)Check_Line[i].d *
						(x - (float)Check_Line[i].line1.x)+(float)Check_Line[i].line1.y);
				}
				else
				{
					x = (float)(((float)-Check_Line[i].d * (float)Check_Line[i].line1.x) + 
						((float)Check_Line[j].d * (float)Check_Line[j].line1.x)
						+(float)Check_Line[i].line1.y - (float)Check_Line[j].line1.y)
						/((float)Check_Line[j].d - (float)Check_Line[i].d);
					
					y = ((float)Check_Line[i].d * 
						(x - (float)Check_Line[i].line1.x)+(float)Check_Line[i].line1.y);
				}

				// Check_Point vector  .
				if( 0 < x && x < m_pMainImage->width && 0 < y && y < m_pMainImage->height)
				{
					CPoint point;
					point.x = x;
					point.y = y;
					Check_Point.push_back(point);
				}
			}
		}
	}
	//
	//////////////////////////////////////////////////////////////////////////
	
	//////////////////////////////////////////////////////////////////////////
	//	* 簢 4Point .

	m_Result_Point.clear();		// ʱȭ.

	vector<CPoint>::iterator it;
	it = Check_Point.begin();
	while(it != Check_Point.end())
	{
		BOOL bCheck = TRUE;
		vector<CPoint>::iterator p;
		p = m_Result_Point.begin();
		while(p != m_Result_Point.end())
		{
			if(it != p && sqrt(((p->x - it->x)*(p->x - it->x))+((p->y - it->y)*(p->y - it->y))) < 20)
			{
				bCheck = FALSE;
			}
			p++;
		}
		if(bCheck == TRUE)
		{
			m_Result_Point.push_back(*it);
		}

		it++;
	}
	
	
	GetPoint_Pad_Rect();
	DrawMousePad(image);
	//
	//////////////////////////////////////////////////////////////////////////
}

void CMyCalibrate::GetPoint_Pad_Rect()
{
	CPoint tmp_point;
	for(int i = 0;i<m_Result_Point.size();i++)
	{
		for(int j = i;j<m_Result_Point.size();j++)
		{
			if(m_Result_Point[i].y > m_Result_Point[j].y)
			{
				// * ȯ
				tmp_point = m_Result_Point[j];
				m_Result_Point[j] = m_Result_Point[i];
				m_Result_Point[i] = tmp_point;
			}
		}
	}

	for(int p = 0;p<4;p+=2)
	{
		if(m_Result_Point[p].x > m_Result_Point[p+1].x)
		{
			// * ȯ
			tmp_point = m_Result_Point[p+1];
			m_Result_Point[p+1] = m_Result_Point[p];
			m_Result_Point[p] = tmp_point;
		}
	}
}

void CMyCalibrate::DrawMousePad(IplImage *image)
{
	// Draw MousePad
	if(m_Result_Point.size() == 4)
	{
		for(int i = 0;i<m_Result_Point.size();i++)
		{
			int color = (int)((float)i/4.0f*205.0f+50);

			CPoint point = m_Result_Point[i];
			cvRectangle(image,cvPoint(point.x-3,point.y-3),cvPoint(point.x+3,point.y+3),CV_RGB(200,200,200),1);
			if(i > 0)
			{
				cvLine(image,
					cvPoint(m_Result_Point[i-1].x,m_Result_Point[i-1].y),
					cvPoint(m_Result_Point[i].x,m_Result_Point[i].y),
					CV_RGB(color,color,color),1);
			}
		}
	}
}
CvPoint CMyCalibrate::GetPoint_2Point(CPoint p1, CPoint p2, int num)
{
	//////////////////////////////////////////////////////////////////////////
	//
	CvPoint point;
	point = cvPoint(
		p1.x+((float)abs(p1.x - p2.x)/(float)(m_pMainImage->width)*(float)num),
		p1.y+((float)abs(p1.y - p2.y)/(float)(m_pMainImage->height)*(float)num));
	//
	//////////////////////////////////////////////////////////////////////////
	return point;
}

CvPoint CMyCalibrate::GetPadPixPoint(CvPoint po_1, CvPoint po_2, CvPoint po_3, CvPoint po_4)
{
	CvPoint returnPoint;
	
	double li_1,li_2;
	bool x_eq_1,x_eq_2;

	//////////////////////////////////////////////////////////////////////////
	//
	if(po_1.x == po_2.x)
	{
		x_eq_1 = TRUE;
	}
	else
	{
		x_eq_1 = FALSE;						
		if(po_1.y == po_2.y)
		{
			li_1 = 0;
		}
		else
		{
			if((po_2.x < po_1.x && po_2.y < po_1.y) ||
				(po_2.x > po_1.x && po_2.y > po_1.y))
			{
				li_1 = fabs((float)(po_2.y - po_1.y)/(float)(po_2.x - po_1.x));
			}
			else
			{
				li_1 = -fabs((float)(po_2.y - po_1.y)/(float)(po_2.x - po_1.x));
			}
		}
	}
	//
	//////////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////////
	//
	if(po_4.x == po_3.x)
	{
		x_eq_2 = TRUE;
	}
	else
	{
		x_eq_2 = FALSE;						
		if(po_4.y == po_3.y)
		{
			li_2 = 0;
		}
		else
		{
			if((po_4.x < po_3.x && po_4.y < po_3.y) ||
				(po_4.x > po_3.x && po_4.y > po_3.y))
			{
				li_2 = fabs((float)(po_4.y - po_3.y)/(float)(po_4.x - po_3.x));
			}
			else
			{
				li_2 = -fabs((float)(po_4.y - po_3.y)/(float)(po_4.x - po_3.x));
			}
		}
	}
	//
	//////////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////////
	//
		
		float x,y;
		if(li_1 == TRUE)
		{
			x = (float)(po_1.x);
			y = ((float)li_2*(x - (float)po_3.x)+(float)po_3.y);
		}
		else if(x_eq_2 == TRUE)
		{
			x = (float)(po_3.x);
			y = ((float)li_1 *(x - (float)po_1.x)+(float)po_1.y);
		}
		else
		{
			x = (float)(((float)-li_1 * (float)po_1.x) + 
				((float)li_2 * (float)po_3.x)
				+(float)po_1.y - (float)po_3.y)
				/((float)li_2 - (float)li_1);
			
			y = ((float)li_1 * (x - (float)po_1.x)+(float)po_1.y);
		}
		
		// Point .

		returnPoint.x = x;
		returnPoint.y = y;		
					
	//
	//////////////////////////////////////////////////////////////////////////

	return returnPoint;
}

BOOL CMyCalibrate::GetbFind4Point()
{
	if(m_Result_Point.size() == 4)
	{
		return TRUE;
	}
	else 
		return FALSE;
}


void CMyCalibrate::Calibration() 
{
	static int time_count = 0;
	static double time_start = GetCurrentTime();

	double t1 = GetCurrentTime();
	

	double result_arr[9];

	CvPoint2D32f src[4];
	CvPoint2D32f dst[4];

	src[0].x = 0;
	src[0].y = 0;

	src[1].x = m_pMainImage->width;
	src[1].y = 0;

	src[2].x = 0;
	src[2].y = m_pMainImage->height;

	src[3].x = m_pMainImage->width;
	src[3].y = m_pMainImage->height;

	dst[0].x = (float)m_Result_Point[0].x;
	dst[0].y = (float)m_Result_Point[0].y;

	dst[1].x = (float)m_Result_Point[1].x;
	dst[1].y = (float)m_Result_Point[1].y;

	dst[2].x = (float)m_Result_Point[2].x;
	dst[2].y = (float)m_Result_Point[2].y;

	dst[3].x = (float)m_Result_Point[3].x;
	dst[3].y = (float)m_Result_Point[3].y;

	CvMat result_mat = cvMat(3,3,CV_64FC1,(void *)result_arr);
	CvMat *result_mat2;
	result_mat2 = cvGetPerspectiveTransform(dst,src,&result_mat);

	if(m_pResultImage != NULL)
	{
		cvReleaseImage(&m_pResultImage);
		m_pResultImage = cvCreateImage(cvGetSize(m_pMainImage),8,3);
	}
	else
	{
		m_pResultImage = cvCreateImage(cvGetSize(m_pMainImage),8,3);
	}

	cvFillImage(m_pResultImage,0xffffff);

	if(m_pResultImage != NULL)
	{
		cvReleaseImage(&m_pResultImage);
		m_pResultImage = cvCreateImage(cvGetSize(m_pMainImage),8,3);
	}

	cvWarpPerspective( m_pMainImage, m_pResultImage, &result_mat);

	// Calibration  ̹
/*
	cvNamedWindow("main");
	cvShowImage("main",m_pMainImage);

	cvNamedWindow("result");
	cvShowImage("result",m_pResultImage);
	
	m_Screen_Result->MainImageCopy(m_pResultImage);
	m_Screen_Result->Invalidate(TRUE);
*//*
	m_FindPoint.CVPROnFrame(m_pResultImage);
	
	double t2 = GetCurrentTime();
	
	time_count++;

	if((GetCurrentTime() - time_start) > 1000)
	{
		CString str;
		str.Format(" ð : %.0f   FPS : %d",t2 - t1,time_count);
		m_Edit_Play_Time = str;
		UpdateData(FALSE);
		
		// ð  ʱȭ
		time_count = 0;
		time_start = GetCurrentTime();
		//
	}
	*/
}

void CMyCalibrate::Reset()
{
	m_Result_Point.clear();	
}
