package com.mybada.docbook.docbook_helper.gui;

import com.mybada.docbook.docbook_helper.model.FileSelector;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.File;

public class FileSelectorPanel extends JPanel implements FileSelector {
	private JTextField xmlSrcTextField;
	private JTextField xslSrcTextField;
	private JTextField outputTextField;

	private File srcXmlFile = new File("C:\\");
	private File srcXslFile = new File("C:\\");
	private File outputFile = new File("C:\\");

	private JButton xmlSrcFindButton = new JButton("...");
	private JButton xslSrcFindButton = new JButton("...");
	private JButton outputFindButton = new JButton("...");

	public File getSrcXmlFile() {
		return srcXmlFile;
	}
	public File getSrcXslFile() {
		return srcXslFile;
	}
	public File getOutputFile() {
		return outputFile;
	}

	public FileSelectorPanel() {
		setLayout(new GridLayout(3, 1));
				
		JPanel xmlSrcPanel = new JPanel(new BorderLayout());
		JPanel xslSrcPanel = new JPanel(new BorderLayout());
		JPanel outputPanel = new JPanel(new BorderLayout());

		JLabel xmlSrcLabel = new JLabel("XML source file:");
		JLabel xslSrcLabel = new JLabel("XSL source file:");
		JLabel outputLabel = new JLabel("Output file:");

		int textFieldCols = 30;
		xmlSrcTextField = new JTextField(textFieldCols);
		xslSrcTextField = new JTextField(textFieldCols);
		outputTextField = new JTextField(textFieldCols);
		
		xmlSrcFindButton.addActionListener(new OpenL());
		xslSrcFindButton.addActionListener(new OpenL());
		outputFindButton.addActionListener(new OpenL());
		JPanel xmlTextFieldButtonPanel = new JPanel();
		xmlTextFieldButtonPanel.add(xmlSrcTextField);
		xmlTextFieldButtonPanel.add(xmlSrcFindButton);
		JPanel xslTextFieldButtonPanel = new JPanel();
		xslTextFieldButtonPanel.add(xslSrcTextField);
		xslTextFieldButtonPanel.add(xslSrcFindButton);
		JPanel outputTextFieldButtonPanel = new JPanel();
		outputTextFieldButtonPanel.add(outputTextField);
		outputTextFieldButtonPanel.add(outputFindButton);
		
		xmlSrcPanel.add(xmlSrcLabel, BorderLayout.NORTH);
		xmlSrcPanel.add(xmlTextFieldButtonPanel);
		xslSrcPanel.add(xslSrcLabel, BorderLayout.NORTH);
		xslSrcPanel.add(xslTextFieldButtonPanel);
		outputPanel.add(outputLabel, BorderLayout.NORTH);
		outputPanel.add(outputTextFieldButtonPanel);

		add(xmlSrcPanel);
		add(xslSrcPanel);
		add(outputPanel);
	}

	class OpenL implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			JFileChooser c = new JFileChooser();
			int rVal = c.showOpenDialog(FileSelectorPanel.this);
			
			if (rVal == JFileChooser.APPROVE_OPTION) {
				Object source = e.getSource();
				JTextField sourceField = null;
				
				if (source == xmlSrcFindButton) {
					sourceField = xmlSrcTextField;
					srcXmlFile = c.getSelectedFile();	

				}
				else if (source == xslSrcFindButton) {
					sourceField = xslSrcTextField;
					srcXslFile = c.getSelectedFile();
				}
				else {
					sourceField = outputTextField;
					outputFile = c.getSelectedFile();
				}

				sourceField.setText(
					c.getCurrentDirectory().toString() + "\\" +
					c.getSelectedFile().getName());
			}
		}
	}
}