<?php
// $Id: new_transform.php,v 1.3 2004/01/07 04:19:03 gryu Exp $

require_once('lib/WikiPlugin.php');

//   stdlib.php, transform.php ο ̴  ...
$AllowedProtocols = "http|https|mailto|ftp|news|gopher";
$InlineImages = "png|jpg|gif|eps|tiff";

include_once('lib/w2h_transform.php');

class TableOfContents
{
	var $RawList;
	var $Count;
	var $isOn;
	function TableOfContents()
	{
		$this->RawList = array();
		$this->Count = 0;
		$this->isOn = false;
	}
}

class WikiToHtml
{
	var $Transform;
	var $TopLevelElementName;
	var $IncludeXmlDeclaration;
	var $FirstSectionName;
	function WikiToHtml (
		$aDocInfo  =  array (
		'TopLevelName' => 'article',
				'IncludeXmlDeclaration'=>true,
				'IncudeDtd' => true,
				'SectionMode' => 'asc',
				'FirstSection' => 'section' )
	)
	{
		global  $AllowedProtocols;

	 	$this->Transform = new WikiToHtmlTransform($aDocInfo);
		$this->Transform->Params['IndentChar'] = '';
		$this->Transform->Params['indent'] = '';
		$this->Transform->Params['Info'] = '';
		$this->Transform->Params['general_block'] = array();
		$this->Transform->Params['general_block_count'] = array();
		$this->Transform->Params['FirstSectionState'] = 'notstarted';
		$this->Transform->Params['Toc'] = new TableOfContents;
		$this->Transform->Params['numbering_elements'] = array();
		$this->Transform->registerInline('w2h_plugin');
		$this->Transform->registerInline('w2h_inline_emphasis_quote');
		$this->Transform->registerInline('w2h_inline_emphasis');
		$this->Transform->registerInline('w2h_inline_doubleBracket');
		$this->Transform->registerInline('w2h_inline_bracketlinks');
		$this->Transform->registerInline('w2h_inline_quote');
		$this->Transform->registerInline('w2h_inline_general_inline');
		$this->Transform->registerInline('w2h_inline_rawurl');
		//$this->Transform->registerInline('w2h_inline_interwikilinks');
		$this->Transform->registerInline('w2h_inline_wikilinks');

		$this->Transform->register('!', 'w2h_block_section');
		$this->Transform->register('_', 'w2h_block_section');
		$this->Transform->register('*', 'w2h_block_itemizedlist');
		$this->Transform->register('#', 'w2h_block_orderedlist');
		$this->Transform->register(';', 'w2h_block_variablelist');
		$this->Transform->register(' ', 'w2h_block_preformat1');
		$this->Transform->register('{', 'w2h_block_preformat2');
		$this->Transform->register('<', 'w2h_block_verbatim');
		$this->Transform->register('|', 'w2h_block_table');
		$this->Transform->register('[', 'w2h_block_image');
		$this->Transform->register('(', 'w2h_block_general_start');
		$this->Transform->register(')', 'w2h_block_general_end');
		$this->Transform->register('-', 'w2h_horizontal_line');
		$this->Transform->register('@', 'w2h_metadata');
		$this->Transform->register('%', 'w2h_table_of_contents');
	}
	function convert($lines)
	{
		if (is_string($lines))
			 $lines = preg_split('/[ \t\r]*\n/', trim($lines));

		$html = $this->Transform->do_transform( '', $lines) ;

		return $html;
	}
}

function w2h_inline_doubleBracket($line, &$transformer)
{
	if ( preg_match_all(
 "/(\[)(\[.+\])/U", $line, $match, PREG_SET_ORDER ) > 0 )
 	{
 		foreach($match as $pair)
 		{
			$line = str_replace($pair[0],
				$transformer->addToken($pair[2])
  				, $line);
  		}
 	}
 	return $line;
}
function w2h_inline_bracketlinks($line, &$transformer)
{
	global $InlineImages;
	if ( preg_match_all(
 "/\[(.+)\]/U", $line, $matches, PREG_SET_ORDER ) > 0 )
 	{
 		foreach($matches as $pair)
 		{
 			preg_match("/([^|]+)(\|)?([^|]+)?/", $pair[1], $match);

 			if (isset($match[3]))
 			{
				// [ũؽƮ | ũ ] 
				$linkTarget = trim($match[3]);
				$linkText = trim($match[1]);
			}
			else
			{
				// [ũ  ] 
				$linkTarget = trim($match[1]);
				$linkText = '';
			}

			if ( preg_match("/^#(.*)/", $linkTarget, $match) )
			//  ũ
			{
				if ($linkText == '') $linkText = $match[1];
				$line = str_replace($pair[0],
   						$transformer->addToken('<a href="#'. $match[1]. '">'. $linkText. '</a>')
   						, $line);
			}
			else
			{
				$link = ParseAndLink($pair[0]);
				$line = str_replace($pair[0],
   						$transformer->addToken($link['link'])
   						,$line);

   			};
 		}
 	}

 	return $line;
}

function w2h_inline_interwikilinks($line, &$transformer)
{

	global $WikiNameRegexp, $InterWikiLinkRegexp;
	if ( preg_match_all("@$InterWikiLinkRegexp:$WikiNameRegexp@",
 		$line, $matches, PREG_SET_ORDER ) > 0 )
 	{
 		foreach($matches as $pair)
 		{
			$line = str_replace($pair[0],
				$transformer->addToken(LinkInterWikiLink($pair[0]))
				, $line);
 		}
 	}

 	return $line;
}
function w2h_inline_wikilinks($line, &$transformer)
{

	global $WikiNameRegexp;
	if ( preg_match_all("@[~!]?$WikiNameRegexp@",
 		$line, $matches, PREG_SET_ORDER ) > 0 )
 	{
 		foreach($matches as $pair)
 		{
 			if ($pair[0][0] == '~' || $pair[0][0] == "!")
			{
   				$line = preg_replace('#'.$pair[0] . '#',
   					  $transformer->addToken(substr($pair[0], 1) )
   						, $line, 1);
			}
   			else
   			{
				$line = preg_replace('#'.$pair[0] . '#',
   					$transformer->addToken(LinkWikiWord($pair[0]))
   						, $line, 1);
   			}
 		}
 	}

 	return $line;
}

function w2h_inline_rawurl($line, &$transformer)
{
	global $AllowedProtocols;
	if ( preg_match_all("/!?\b($AllowedProtocols):[^\s<>\[\]\"'()]*[^\s<>\[\]\"'(),.?]/",
 		$line, $matches) > 0 )
 	{
 		foreach($matches[0] as $pair)
 		{
 		    $pos = strpos($line, $pair);
 		    $line = substr($line, 0, $pos) .  $transformer->addToken('<a href="'. $pair . '">'. $pair . '</a>') .
 		        substr($line, $pos + strlen($pair));
 		}
 	}
	return $line;
}

function w2h_plugin($line, &$transformer) {
	 // FIXME: is this good syntax?
	 global $dbi, $request;      // FIXME: make these non-global?
	$line = strtr($line, array_flip(get_html_translation_table(HTML_ENTITIES)));
	$line = preg_replace("/&#([0-9]+);/me", "chr('\\1')", $line);

	 if (preg_match('/^<\?plugin(-form)?\s.*\?>\s*$/', $line)) {
		  $loader = new WikiPluginLoader;
		  return $transformer->addToken($loader->expandPI($line, $dbi, $request) );
	 }
	 else
	    return $line;
}

function w2h_inline_emphasis_quote($line, &$transformer)
{
	while ( preg_match("|(''''')(.*?)(''''')|", $line, $match ) )
	    $line = str_replace($match[0], $transformer->addToken('<em>') . 
	    	''. $match[2]. '' . 
	    	$transformer->addToken('</em>'), $line);
	return $line;
}

function w2h_inline_emphasis($line, &$transformer)
{
	while ( preg_match("|(''')(.*?)(''')|", $line, $match) )
	{
	    $line = str_replace($match[0], $transformer->addToken('<em>') . $match[2] . $transformer->addToken('</em>'), $line);
	}
	return $line;
}

function w2h_inline_quote($line, &$transformer)
{
	while ( preg_match("|('')(.*?)('')|", $line, $match ) )
	     $line = str_replace($match[0], '"'. $match[2]. '"', $line);
	return $line;
}

/* ܼ ζ ±׵. {{tagname content }}  .  ...(ܼ ġȯ ).
{{keycap F1}} => <keycap>F1</keycap>
*/
function w2h_inline_general_inline($line, &$transformer)
{
	while ( preg_match('|{{([[:alnum:]]+) (.*?)}}|' , $line, $match ) )
	{
	     $line = str_replace($match[0], $transformer->addToken(
	       '<span class="'. $match[1] . '">' . $match[2] . '</span>'), $line);
	}
	return $line;
}

function w2h_sublist(&$lines, $startChar, $level, &$transformer)
{
	$baseIndent = $transformer->Params['indent'];

	$line = current($lines);

	if ($startChar == '*' )
		$tagName = 'ul';
	else if ($startChar == '#' )
		$tagName = 'ol';
	else
		die("unknown list  in function w2h_sublist()\n<pre>$line</pre>");

	$Indent = $baseIndent . $transformer->maketabs($level - 1);
	$html = "$Indent<$tagName>\n";

	$isFirst = true;

	while ( (substr($line, $level - 1, 1) == $startChar ) &&
		(preg_match("/^([\#\*\;]+)/", $line, $matches))
	)
	{

		$numtabs = strlen($matches[1]);

		if ($numtabs > $level)
		{
			$newStartChar = substr($line, $numtabs - 1, 1);
			$html .= w2h_sublist($lines, $newStartChar, $numtabs, $transformer);
		}

		if ($numtabs == $level)
		{
			if (!$isFirst)
			{
				$html .= "$Indent</li>\n";
			}
			else
				$isFirst = false;
			$line = substr($line, $level);
			$html .= $Indent. '<li>'. trim($transformer->formatInline($line) ).  "\n";

		}
		if ( $numtabs < $level)
			break ;
		if (! ($line = next($lines) ) )
			break;

	}

	prev($lines);
	$html .= "$Indent</li>\n$Indent</$tagName>\n";
	return $html;
}

function w2h_block_itemizedlist(&$lines, &$transformer)
{
	$html = w2h_sublist($lines, '*', 1, $transformer);
	return $html;
}

function w2h_block_orderedlist(&$lines, &$transformer)
{
	$html = w2h_sublist($lines, '#', 1, $transformer) ;
	return $html;
}

function w2h_block_variablelist(&$lines,  &$transformer)
{
	$line =current( $lines );
	$Indent = $transformer->Params['indent'];

	$html = "$Indent<dl>\n";
	if (!(preg_match("/^(;+)(.*?):(.*$)/", $line, $matches)) )
		return '';
	while (preg_match("/^(;+)(.*?):(.*$)/", $line, $matches))
	{
		$numtabs = strlen($matches[1]);


		$html .= $Indent. '<dt>'
			. trim($transformer->formatInline($matches[2]) )
			." </dt>\n";

		$html .= $Indent. '<dd><p>'
			. trim($transformer->formatInline($matches[3]) )
			." </p>\n$Indent</dd>\n";

		if (! ($line = next($lines) ) )
			break;
	}
	prev($lines);

	$html .= "$Indent</dl>\n";
	return $html;
}

function w2h_block_section(&$lines, &$transformer)
{
	$line = current($lines);
	$currLevel = 0;
	if (preg_match("/^(!{1,4})[^!]/", $line, $whichheading))
	{
		$currLevel  = 5 - strlen( $whichheading[1] ); // !!!! -> 1, !!! -> 2, ... ! -> 4
		$line =  preg_replace('/^!+/', '', $line);
	}
	else if (preg_match("/^(\_!+)[^!]/", $line, $whichheading))
	{
		$currLevel  = strlen( $whichheading[1] ) + 3; // _! -> 5, _!! -> 6, etc....
		$line =  preg_replace("/^(\_!+)[^!]/", "", $line);
	}

	if ($currLevel > 0)
	{
		$html = '';
		$TitleAndId = parseTitleLine($line);
		if ( !empty($TitleAndId['ID']) )
				{
			$SectionTag = "\n". $transformer->Params['indent']. "<h$currLevel id=\"{$TitleAndId['ID']}\">";
			$line = $TitleAndId['Title'];
		}
		else
		{
			$transformer->Params['indent'] = $transformer->maketabs($currLevel-2);
			$SectionTag = "\n". $transformer->Params['indent']. "<h$currLevel>";
		}
		if ( $transformer->Params['Toc']->isOn == true )
		{
			$toc = &$transformer->Params['Toc'];
			$toc->Count += 1;
			$toc->RawList[] = str_repeat('#', $currLevel) . "[$line|#header{$toc->Count}]";
			$html = '<a name="header' . $toc->Count . '"></a>';
		}
		$html .= $SectionTag;

		$line = htmlspecialchars(trim($line));
		$line = $html.  $line . "</h$currLevel>\n\n";
	}
	return  $line;
}

function w2h_block_preformat1(&$lines, &$transformer)
{

	$html =$transformer->Params['indent'] ."<pre>\n";

	while (list($dummy, $line) =each($lines) )
	{

			if (substr($line, 0, 1) == ' ' && trim($line) != '' )
				$html .= htmlspecialchars($line) . "\n";
			else
				break;

	}
	prev($lines);

	return $html . $transformer->Params['indent'] ."</pre>\n";
}

function w2h_block_preformat2(&$lines, &$transformer)
{
	$line = current($lines);
	$html = '';
	if (preg_match('/^{{{/', $line)) {
		$html = "<pre>\n";
		next($lines);
		while (list($dummy, $line) =each($lines) )
		{
			if (preg_match('/^}}}/', $line) )
				break;
			else
				$html .= htmlspecialchars($line) . "\n";
		}

		$html .= "</pre>\n";
		prev($lines);
	}
	return $html;
}

function w2h_block_verbatim(&$lines, &$transformer)
{
	$html = '';
	$line = current($lines);
	if (trim($line) == '<<<') {
		next($lines);
		while( list($dummy, $line) =each($lines)  )
		{
			if (trim($line) == '>>>' )
				break;
			$html .= htmlspecialchars($line) . "\n";
		}
		$html = "<pre>\n$html</pre>\n";
		prev($lines);
	}

	return $html;
}



function w2h_block_table(&$lines, &$transformer)
{
	$line = current($lines);
	$html = '';
	$indent = $transformer->Params['indent'];
	$moreindent = $indent . $transformer->Params['IndentChar'];
	$attr = 'border="3" rules="all" frame="hsides" cellspacing="0" cellpadding="2"';
	if (substr($line, 0, 2) == '|!' )
	{
		$TitleAndId = parseTitleLine(substr($line, 2));
		if ( !empty($TitleAndId['ID']) )
			$html .= '<a name="'. $TitleAndId['ID'] . '"></a>';
		$html .= '<b>' . $transformer->formatInline($TitleAndId['Title']). "</b><br />\n";
		$line = next($lines);
	}

	$html .= "<table $attr>\n";
	$entries = '';
	$thead = '';
	$tfoot = '';
	$rows = 0;
	$cols = 0;

	while(substr($line, 0, 1) == '|' )
	{
		$line = $transformer->formatInline($line);
		$rowmode = '';
		if (substr($line, 0, 2) == '|{' )
		{
			$rowmode = 'thead';
			$line = '|'. substr($line, 2);
		}
		if (substr($line, 0, 2) == '|}' )
		{
			$rowmode = 'tfoot';
			$line = '|'.substr($line, 2);
		}

		$row = '';
		$lastcols = 0;
		$celltag = 'td';
		if ( $rowmode == 'thead' || $rowmode == 'tfoot' )
			$celltag = 'th';
		while (preg_match('/^(\|+)(v*)([\<\>\^]?)([^|]*)/', $line, $m))
		{
		   	$line = substr($line, strlen($m[0]));
		   	$td = array();
		   
		   	if (strlen($m[1]) > 1)
		   		$td['colspan'] = strlen($m[1]);
		   	if (strlen($m[2]) > 0)
		   		$td['rowspan'] = strlen($m[2]) + 1;

			if ($m[3] == '^')
	 			$td['align'] = 'center';
			else
				$td['align'] = 'left';
			$row .= StartTag($celltag, $td);
			$row .= trim($m[4]) ;
			$row .= "</$celltag>";
			$lastcols++;
		}
		$cols = max($lastcols, $cols);
		assert(empty($line));
		$entries .= $moreindent . "<tr>$row </tr>\n";
		$rows++;
		$line = next($lines);
	}
	$html .= "$entries \n</table>\n";

	return $html;
}

function w2h_block_image(&$lines, &$transformer)
{
	global $InlineImages;
	$line = current($lines);

	$html = '';
	if ( preg_match( '#\[([^\[]+)\](.*)#', $line, $match) )
	{
  		if (preg_match( "#($InlineImages)#", $match[1], $m) )
  		{
 			$html =  "<img src=\"$match[1]\" />\n";
			$caption = trim($match[2]);
			if( $caption != '' )
			{
				$html .= '<p>'. $transformer->formatInline($caption) . "</p>\n";
			}
		}
	}
	return $html;
}

function w2h_block_general_start(&$lines, &$transformer)
{
	global $tagnames;
	$html = '';
	$line = current($lines);
	if ( preg_match('#\(\(\(([a-zA-Z0-9]+)(\s*)(.*)#', $line, $match) )
	{
		$name = strtolower(trim($match[1]) );
		$orig_name = $name;
		if (isset($tagnames[$name]) )
			$name = $tagnames[$name];
			
		if(! isset($transformer->Params['general_block_count'][$name]) )
			$transformer->Params['general_block_count'][$name] = 0;

		$transformer->Params['general_block_count'][$name]++;

		$html .= '<span class="blockname">';
		if(in_array($orig_name, $transformer->Params['numbering_elements']))
			$html .= '[' . $name . 
				$transformer->Params['general_block_count'][$name] . '] ';
		else if ( $match[3] == '')
 			$html .= '[' . $name . '] ';

		if ($match[3] != '' )
		{
		 	$TitleAndId = parseTitleLine($match[3]);
			if ( !empty($TitleAndId['ID']) )
		 	{
		 		$html .= '<a name="'.$TitleAndId['ID'] . '"></a>';
		 		$match[3] = trim($TitleAndId['Title']);
		 	}

		 	$html .= "$match[3]";
		}
		
		$html .= "</span><br/>\n";
		$html .= '<div class="genblock">';		  	
		$transformer->Params['general_block'][] = $match[1];
		$html .= "\n";
	}
	return $html;
}

function w2h_block_general_end(&$lines, &$transformer)
{
	$html = '';
	$line = current($lines);
	if ( preg_match('#\)\)\)#', $line) && count($transformer->Params['general_block']) > 0 )
	{
		$html = "</div>\n";
		array_pop($transformer->Params['general_block']);
	}
	return $html;
}

function w2h_table_of_contents(&$lines, &$transformer)
{
	global $FieldSeparator;
	$line = current($lines);
	if ( rtrim($line) == '%%TOC%%' )
	{
		$transformer->Params['Toc']->isOn = true;
		return $FieldSeparator.'TOC'.$FieldSeparator;
	}
	else
		return '';
}
function w2h_horizontal_line(&$lines, &$transformer)
{

	if ( preg_match("#^----+$#", current($lines), $match) )
	{
		return "<hr />";
	}
	else
		return '';

}

function w2h_parse_person_info($str)
{
	$parts = explode(';', $str);

	$name = explode(' ', $parts[0]);
	$result = '<surname>'. $name[0] . '</surname>';

	if (isset($name[1]))
		$result .= '<firstname>'.$name[1]. "</firstname>\n";

	if (isset($parts[1]))
	{
		$result .= "\t<affiliation>
 	<address><email>$parts[1]</email>
	</address>
	</affiliation>\n";
	}
	return $result;
}

function w2h_parse_revision_info($str)
{
	$result ="\t<revision>\n";
	$parts = explode(';', $str);
	if (isset($parts[0]) )
		$result .= "\t<revnumber>$parts[0]</revnumber>\n";
	if (isset($parts[1]) )
		$result .= "\t<date>$parts[1]</date>\n";
	if (isset($parts[2]) )
		$result .= "\t<authorinitial>$parts[2]</authorinitial>\n";
	if (isset($parts[3]) )
		$result .= "\t<revremark>$parts[3]</revremark>\n";
	return $result . "\t</revision>\n\n";

}

function w2h_metadata(&$lines, &$transformer)
{
	$result = ' ';
	$line = current($lines);
	if ( preg_match("#^\@([^\s]+)\s+(.*)#", $line, $match) )
	{
		
		if ( $match[1] == '//' )
			$result = '<div class="comment">' . $transformer->formatInline($match[2]) . "</div>\n";
		elseif ( $match[1] == 'ȣ' )
			$transformer->Params['numbering_elements'] = preg_split('/[,;\s]+/', $match[2]);
		else
			$result = $line . "<br />\n";
	}

	return $result;
}

function do_transform(&$lines)
{
	$Converter = new WikiToHtml();
	return $Converter->convert(&$lines);
}

?>