unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Menus, OleCtrls, SHDocVw_TLB, EmbeddedWB,
  psvPHP, ExtCtrls, RichEditHighlight;

type
  TfrmMain = class(TForm)
    psvPHP: TpsvPHP;
    PageControl: TPageControl;
    WikiView: TTabSheet;
    HTMLView: TTabSheet;
    WebBrowser: TEmbeddedWB;
    DocBookView: TTabSheet;
    btnUpdate: TButton;
    richWiki: TRichEdit;
    MainMenu1: TMainMenu;
    mmoFile: TMenuItem;
    OpenDialog: TOpenDialog;
    SaveDialog1: TSaveDialog;
    ReplaceDialog1: TReplaceDialog;
    mmoOpen: TMenuItem;
    mmoNew: TMenuItem;
    mmoSave: TMenuItem;
    mmoSaveAs: TMenuItem;
    mmoQuit: TMenuItem;
    richDocBook: TRichEdit;
    DocBookXML: TTabSheet;
    WbXML: TEmbeddedWB;
    procedure mmoCloseClick(Sender: TObject);
    procedure PageControlChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure richWikiChange(Sender: TObject);
    procedure btnUpdateClick(Sender: TObject);
    procedure mmoQuitClick(Sender: TObject);
    procedure mmoOpenClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;
  WikiTextChanged : Boolean;
  TempHtmlFilePath : String;
  TempXmlFilePath : String;
implementation

{$R *.dfm}

procedure TfrmMain.mmoCloseClick(Sender: TObject);
begin
    WebBrowser.Stop;
    frmMain.Close;
end;

procedure TfrmMain.PageControlChange(Sender: TObject);

begin
    if WikiTextChanged then
    begin
        btnUpdateClick(Sender);
        WikiTextChanged := false;
    end;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
    WikiTextChanged := true;
    TempHtmlFilePath := ExtractFilePath(Application.Exename) + 'temp.html';
    TempXmlFilePath := ExtractFilePath(Application.Exename) + 'temp.xml';    
    PageControl.ActivePageIndex := 0;
end;

procedure TfrmMain.richWikiChange(Sender: TObject);
begin
    WikiTextChanged := true;
end;

procedure TfrmMain.btnUpdateClick(Sender: TObject);
var
    Lines : TStringList;
    strTemp : String;
begin

    psvPHP.FileName := ExtractFilePath(Application.Exename) + 'scripts\\html.php';
    strTemp := StringReplace(richWiki.Text,
            '&', '__amp__', [rfReplaceAll, rfIgnoreCase]);
    psvPHP.Variables.Items[0].Value := strTemp;

    Lines := TStringList.Create;
    Lines.Text := psvPHP.Execute;
    Lines.SaveToFile(TempHtmlFilePath);

    WebBrowser.Navigate(TempHtmlFilePath);

    psvPHP.FileName := ExtractFilePath(Application.Exename) + 'scripts\\docbook.php';
    psvPHP.Variables.Items[0].Value := strTemp;
    richDocBook.Clear;
    strTemp := psvPHP.Execute;
    richDocBook.Text := strTemp;
    Lines.Text := strTemp;
    Lines.SaveToFile(TempXmlFilePath);
    WbXML.Navigate(TempXmlFilePath);
    Lines.Free;
end;



procedure TfrmMain.mmoQuitClick(Sender: TObject);
begin
    WebBrowser.Stop;
    frmMain.Close;
end;

procedure TfrmMain.mmoOpenClick(Sender: TObject);

begin
    if(OpenDialog.Execute ) then
        richWiki.Lines.LoadFromFile( OpenDialog.FileName );


end;

end.
