<?php
// (c-file-style: "gnu")
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:   
// $Id: w2dclass.php,v 1.1 2003/08/01 11:05:00 gryu Exp $

//   stdlib.php, transform.php ο ̴  ...
$AllowedProtocols = "http|https|mailto|ftp|news|gopher";
$InlineImages = "png|jpg|jpeg|gif|eps|tiff";
$prevSectionLevel = 0;

include_once('w2d_transform.php');

class WikiToDocBook 
{
	var $Transform;
	var $TopLevelElementName;
	var $IncludeXmlDeclaration;
	function WikiToDocBook (
		$aDocInfo  =  array ( 
		'TopLevelName' => 'article', 
				'IncludeXmlDeclaration'=>true,
				'FirstSection' => 'section' )
	) 
	{
		global  $AllowedProtocols;
		
		$this->TopLevelElementName = $aDocInfo['TopLevelName'];
	 	$this->IncludeXmlDeclaration = $aDocInfo['IncludeXmlDeclaration'];
	 	$this->IncludeDtdDeclaration = $aDocInfo['IncludeDtdDeclaration'];
	 	$this->DtdPath = $aDocInfo['DtdPath'];

	 	$this->Transform = new Wiki2DocBookTransform;
	 	$this->Transform->Params['FirstSectionName'] = $aDocInfo['FirstSection'];
	 	$this->Transform->Params['IndentChar'] = "\t";
		$this->Transform->Params['indent'] = '';
		$this->Transform->Params['Info'] = '';
		$this->Transform->Params['TopLevelTitle'] = '';
		$this->Transform->Params['UnclosedSections'] = 0;
		$this->Transform->Params['FirstSectionState'] = 'notstarted';
		$this->Transform->registerInline('inline_emphasis_quote');		
		$this->Transform->registerInline('inline_emphasis');
		$this->Transform->registerInline('inline_quote');		
		$this->Transform->registerInline('inline_general_inline');
		$this->Transform->registerInline('inline_doubleBracket');
		$this->Transform->registerInline('inline_bracketlinks');
		$this->Transform->registerInline('inline_rawurl');
		$this->Transform->registerInline('inline_wikiname');
		
		$this->Transform->register('!', 'block_section');
		$this->Transform->register('_', 'block_section');		
		$this->Transform->register('*', 'block_itemizedlist');
		$this->Transform->register('#', 'block_orderedlist');
		$this->Transform->register(';', 'block_variablelist');		
		$this->Transform->register(' ', 'block_preformat1');
		$this->Transform->register('{', 'block_preformat2');
		$this->Transform->register('<', 'block_verbatim');
		$this->Transform->register('|', 'block_table');
		$this->Transform->register('[', 'block_image');
		$this->Transform->register('(', 'block_general_start');
		$this->Transform->register(')', 'block_general_end');
		$this->Transform->register('%', 'block_ignore');
		$this->Transform->register('@', 'metadata');		
		
	}
	function convert($lines)
	{
		if (is_string($lines))
			 $lines = preg_split('/[ \t\r]*\n/', $lines);
 	
		$html = $this->Transform->do_transform( '', $lines) ;

		if (is_array($this->Transform->Params['Info']) )
			$Options = parse_metadata($this->Transform->Params['Info']);

		if (isset($Options['DocType']) )
			$this->TopLevelElementName = $Options['DocType'];

		if (isset($Options['DocHeader']) )
		{
			$this->IncludeXmlDeclaration = $Options['DocHeader']['IncludeXmlDeclaration'];
			$this->IncludeDtdDeclaration = $Options['DocHeader']['IncludeDtdDeclaration'];
			$this->DtdPath = $Options['DocHeader']['DtdPath'];
		}
		
 		if ( $this->IncludeXmlDeclaration) 
 		{
 			$top = "<?xml version=\"1.0\" encoding=\"euc-kr\"?>\n";

			if ( $this->IncludeDtdDeclaration)
				$top .= "<!DOCTYPE {$this->TopLevelElementName} {$this->DtdPath}>\n";
		}
				
		$top .=  "\n<{$this->TopLevelElementName} lang=\"ko\"";

		if (isset($this->Transform->Params['TopLevelId']))
			$top .= " id=\"{$this->Transform->Params['TopLevelId']}\">\n";
		else 
			$top .= ">\n";
		$top .= "\n<{$this->TopLevelElementName}info>\n";
		
		if ( $this->Transform->Params['TopLevelTitle'] != '' )
			$top .= "<title>{$this->Transform->Params['TopLevelTitle']}</title>\n";
	
		if (isset($Options['Info']) )
			$top .= $Options['Info'];

		$top .= "</{$this->TopLevelElementName}info>\n";
		return $top . $html . "\n</{$this->TopLevelElementName}>\n";
	}
}

function inline_doubleBracket($line, &$transformer)
{
	if ( preg_match_all(
 "/(\[)(\[.+\])/U", $line, $match, PREG_SET_ORDER ) > 0 )
 	{
 		foreach($match as $pair)
 		{
			$line = str_replace($pair[0], 
				$transformer->addToken($pair[2])
  				, $line);
  		}
 	}
 	return $line;
} 

function inline_bracketlinks($line, &$transformer) 
{
	global $InlineImages;	
	if ( preg_match_all(
 "/\[(.+)\]/U", $line, $match, PREG_SET_ORDER ) > 0 )
 	{
 		foreach($match as $pair)
 		{
 			preg_match("/([^|]+)(\|)?([^|]+)?/", $pair[1], $matches);
 			
 			if (isset($matches[3])) 
 			{
				// [ũؽƮ | ũ ] 
				$linkTarget = trim($matches[3]);
				$linkText = trim($matches[1]);
			}
			else
			{
				// [ũ  ] 
				$linkTarget = trim($matches[1]);
				$linkText = '';
			}

			if ( ( preg_match("/($InlineImages)$/i", $linkTarget)) )
			{
				$line = str_replace($pair[0], 
					$transformer->addToken(
				'<inlinemediaobject><imageobject><imagedata fileref="'. $linkTarget . '" /></imageobject></inlinemediaobject>')
   						, $line);
			}
			
			else if ( preg_match("/^#(.*)/", $linkTarget, $matches) )
			//  ũ
			{
				if ($linkText == '') $linkText = $matches[1];
				$line = str_replace($pair[0], 
   						$transformer->addToken('<link linkend="'. $matches[1]. '">'. $linkText. '</link>')
   						, $line);
			}
			else
			{
				if ($linkText == '') $linkText = $linkTarget;
				$line = str_replace($pair[0], 
   						$transformer->addToken('<ulink url="'. $linkTarget. '">'. $linkText. '</ulink>') 
   						,$line);

   			};
 		}
 	}
 	
 	return $line;
}

function inline_rawurl($line, &$transformer) 
{
	global $AllowedProtocols;
	if ( preg_match_all("/!?\b($AllowedProtocols):[^\s<>\[\]\"'()]*[^\s<>\[\]\"'(),.?]/",
 		$line, $matches) > 0 )
 	{
 		foreach($matches[0] as $pair)
 		{
 		  //$pair=str_replace('&amp;', '&', $pair); 			
                    $pos = strpos($line, $pair);
   		  $line = substr($line, 0, $pos) .  $transformer->addToken('<ulink url="'. $pair . '">'. $pair . '</ulink>') .
 		        substr($line, $pos + strlen($pair));
 		}
 	}
	return $line;
}

function inline_wikiname($line, &$transformer) 
{
	global $WikiNameRegexp;
	return  preg_replace(
 "@([~!]?)($WikiNameRegexp)@", 
   "\\2", $line );
}

function inline_emphasis_quote($line, &$transformer)
{
	$line = preg_replace("|(''''')(.*?)(''''')|", '<emphasis><quote>\2</quote></emphasis>', $line);
	return $line;
}

function inline_emphasis($line, &$transformer) 
{
	$line = preg_replace("|(''')(.*?)(''')|", '<emphasis>\2</emphasis>', $line);
	return $line;
}

function inline_quote($line, &$transformer)
{
	$line = preg_replace("|('')(.*?)('')|", '<quote>\2</quote>', $line);
	return $line;
}
/* ܼ ζ ±׵. {{tagname content }}  .  ...(ܼ ġȯ ).
{{keycap F1}} => <keycap>F1</keycap>
*/
function inline_general_inline($line, &$transformer)
{
	$line = preg_replace( "|{{([[:alnum:]]+) (.*?)}}|" , '<\1>\2</\1>' , $line);
	return $line;
}

function sublist(&$lines, $startChar, $level, &$transformer)
{
	$baseIndent = $transformer->Params['indent'];

	$line = current($lines);
	
	if ($startChar == '*' ) 
		$tagName = 'itemizedlist';
	else if ($startChar == '#' )
		$tagName = 'orderedlist';
	else 
		die("unknown list  in function sublist()\n<pre>$line</pre>");
	
	$Indent = $baseIndent . $transformer->maketabs($level - 1);
	$html = "$Indent<$tagName>\n";

	$isFirst = true;
	
	while ( (substr($line, $level - 1, 1) == $startChar ) && 
		(preg_match("/^([\#\*\;]+)/", $line, $matches))
	)
	{

		$numtabs = strlen($matches[1]);

		if ($numtabs > $level)
		{
			$newStartChar = substr($line, $numtabs - 1, 1);
			$html .= sublist($lines, $newStartChar, $numtabs, $transformer);
		}

		if ($numtabs == $level)
		{
			if (!$isFirst)
			{
				$html .= "$Indent</listitem>\n";
			}
			else
				$isFirst = false;
			$line = substr($line, $level);
			$html .= $Indent. '<listitem><para>'. trim($transformer->formatInline($line) ).  "</para>\n";
		
		}
		if ( $numtabs < $level) 
			break ;
		if (! ($line = next($lines) ) )
			break;

	}

	prev($lines);
	$html .= "$Indent</listitem>\n$Indent</$tagName>\n";
	return $html;
}

function block_itemizedlist(&$lines, &$transformer)
{
	$html = sublist($lines, '*', 1, $transformer);
	return $html;
}

function block_orderedlist(&$lines, &$transformer)
{
	$html = sublist($lines, '#', 1, $transformer) ;
	return $html;
}

function block_variablelist(&$lines,  &$transformer)
{
	$line =current( $lines );
	$Indent = $transformer->Params['indent'];
	
	$html = "$Indent<variablelist>\n";
	if (!(preg_match("/^(;+\s*)(.*?):(.*$)/", $line, $matches)) )
		return '';
	while (preg_match("/^(;+\s*)(.*?):(.*$)/", $line, $matches))
	{
		$numtabs = strlen($matches[1]);
 		
		if(trim($matches[2]))
			$html .= $Indent. '<varlistentry><term>' 
				. trim($transformer->formatInline($matches[2]) )
				." </term>\n";

		$html .= $Indent. '<listitem><para>' 
			. trim($transformer->formatInline($matches[3]) ) 
			." </para>\n$Indent</listitem>\n$Indent</varlistentry>\n";

		
		if (! ($line = next($lines) ) )
			break;
	}
	prev($lines);
	$html .= "$Indent</variablelist>\n";
	return $html;
}

function block_section(&$lines, &$transformer)
{
	$line = current($lines);
	$prevSectionLevel = $transformer->Params['prevSectionLevel'];
	$currLevel = 0;
	if (preg_match("/^(!{1,4})[^!]/", $line, $whichheading))
	{
		$currLevel  = 5 - strlen( $whichheading[1] ); // !!!! -> 1, !!! -> 2, ... ! -> 4
		$line =  preg_replace('/^!+/', '', $line);
	}
	else if (preg_match("/^(\_!+)[^!]/", $line, $whichheading))
	{
		$currLevel  = strlen( $whichheading[1] ) + 3; // _! -> 5, _!! -> 6, etc....
		$line =  preg_replace("/^(\_!+)[^!]/", "", $line);
	}
	
	if ($currLevel > 0)
	{
		$html = '';
		while ( $prevSectionLevel >= $currLevel )
		{
			if ( ($prevSectionLevel == 2) && ($transformer->Params['FirstSectionState'] == 'opened') )
			{
				$html .= "\n" . $transformer->maketabs($prevSectionLevel - 2)
					 . '</'. $transformer->Params['FirstSectionName'] . ">\n";
				$transformer->Params['FirstSectionState'] == 'done';
			}
			else
				$html .= "\n" . $transformer->maketabs($prevSectionLevel - 2) ."</section>\n";

			$prevSectionLevel--;
			$transformer->Params['UnclosedSections'] -= 1;
		}
		
		$prevSectionLevel = $currLevel;
		$transformer->Params['indent'] = $transformer->maketabs($currLevel - 2);
		if( preg_match("/(.*)::(.*)::(\s*)$/", $line, $match) )
		{
			$SectionTag = "\n". $transformer->Params['indent']. "<section id=\"$match[2]\">";
			$line = $match[1];
			if ( $currLevel == 1)
			{
				$transformer->Params['TopLevelId'] = $match[2];
			}
		}
		else
		{
			$transformer->Params['indent'] = $transformer->maketabs($currLevel-2);
			$SectionTag = "\n". $transformer->Params['indent']. "<section>";
		}
		
		if ( ($currLevel == 2) && ($transformer->Params['FirstSectionState'] == 'notstarted') )
		{
			$SectionTag = str_replace('<section', '<'. $transformer->Params['FirstSectionName'], $SectionTag);
			$transformer->Params['FirstSectionState'] = 'opened';
		}
		
		$line = htmlspecialchars(trim($line));
		if ($currLevel > 1) 
		{
			$html .= $SectionTag;
			$line = $html.  '<title>'. $line . "</title>\n\n";
			$transformer->Params['UnclosedSections'] += 1;
		}
		else if ($currLevel == 1)
		{
			$transformer->Params['TopLevelTitle'] = trim($line);
			$line = '';
			next($lines);
		}
		$transformer->Params['prevSectionLevel'] = $prevSectionLevel;

	}
	return  $line;
}

function block_preformat1(&$lines, &$transformer)
{
	$html =$transformer->Params['indent'] ."<programlisting>\n";

	while (list($dummy, $line) =each($lines) )
	{
	
			if (substr($line, 0, 1) != ' ')
				break;
			else
				$html .= htmlspecialchars($line) . "\n";
				
	};
	prev($lines);

	return $html . $transformer->Params['indent'] ."</programlisting>\n";
}

function block_preformat2(&$lines, &$transformer)
{
	$html = '';
	$line = current($lines);
	if (preg_match('/^{{{/', $line)) {
		$tagname = trim( substr( $line, 3) );
		if ( $tagname == '') $tagname = 'programlisting';
		$html = $transformer->Params['indent'] ."<$tagname>\n";
		next($lines);
		while (list($dummy, $line) =each($lines) ) 
		{
			if (preg_match('/^}}}/', $line) )
				break;
			else
				$html .= htmlspecialchars($line) . "\n";
		}

		$html .= $transformer->Params['indent'] ."</$tagname>\n";
		prev($lines);
	}
	return $html;
}

function block_general_start(&$lines, &$transformer)
{
	$html = '';
	$line = current($lines);
	if ( preg_match('#\(\(\(([a-zA-Z0-9]+)(\s*)(.*)#', $line, $match) )
	{
		$indent = $transformer->Params['indent'];
		$transformer->Params['general_block'] = $match[1];
		$html = "$indent<{$match[1]}";
		if ($match[3] != '' )
		{
		 	if ( preg_match('#(.*)::(.*)::#', $match[3], $m) )
		 	{
		 		$html .= ' id="'.$m[2] . '">';
		 		$match[3] = trim($m[1]);
		 	}
		 	else
		 		$html .= '>';
		 		
		 	$html .= "<title>$match[3]</title>";
		 }
		 else 
		 	$html .= '>';
		 $html .= "\n";
	}
	return $html;
}

function block_general_end(&$lines, &$transformer)
{
	$html = '';
	$line = current($lines);
	if ( preg_match('#\)\)\)#', $line) )
	{
		$indent = $transformer->Params['indent'];
		$html = "$indent</{$transformer->Params['general_block']}>\n";
	}
	return $html;
}
function block_verbatim(&$lines, &$transformer)
{
	$html = '';
	$line = current($lines);
	if (trim($line) == '<<<') {
		next($lines);
		while( list($dummy, $line) =each($lines)  )
		{
			if (trim($line) == '>>>' ) 
				break;
			$html .= $line . "\n";
		} 
		prev($lines);
	}

	return $html;
}

function block_table(&$lines, &$transformer)
{
	$line = current($lines);
	$title = '';
	$indent = $transformer->Params['indent'];
	$moreindent = $indent . $transformer->Params['IndentChar'];
	$tabletagname = 'informaltable';
	if (substr($line, 0, 2) == '|!' )
	{
		$tabletagname = 'table';
		$title = '<title>' . $transformer->formatInline(substr($line, 2)). "</title>\n";
		$line = next($lines);
	}
	$html = $indent. "<$tabletagname frame='all'>$title\n";
	$entries = '';
	$thead = '';
	$tfoot = '';
	$cols = 0;
	
	while(substr($line, 0, 1) == '|' )
	{	
		$line = $transformer->formatInline($line);
		$rowmode = '';
		if (substr($line, 0, 2) == '|{' )
		{
			$rowmode = 'thead';
			$line = '|'. substr($line, 2);
		}
		if (substr($line, 0, 2) == '|}' )
		{
			$rowmode = 'tfoot';
			$line = '|'.substr($line, 2);
		}
			
		$row = '';
		$lastcols = 0;
		while (preg_match('/^(\|+)(v*)([<>^]?)([^|]*)/', $line, $m))
		{
			$line = substr($line, strlen($m[0]));
			$td = array();
		
			if (strlen($m[1]) > 1)
	 			$td['colspan'] = strlen($m[1]);
			if (strlen($m[2]) > 0)
	 			$td['morerows'] = strlen($m[2]) + 1;
		
			if ($m[3] == '^')
	 			$td['align'] = 'center';
			else if ($m[3] == '>')
	 			$td['align'] = 'right';
			else
	 			$td['align'] = 'left';
		
			$row .= '<entry> ';
			$row .= trim($m[4]) ;
			$row .= '</entry>';
			$lastcols++;
		}
		$cols = max($lastcols, $cols);
		assert(empty($line));
		if ($rowmode == 'thead')
			$thead = $moreindent . "<row>$row </row>";
		else if($rowmode == 'tfoot')
			$tfoot = $moreindent . "<row>$row </row>";
		else
			$entries .= $moreindent . "<row>$row </row>\n";
		$line = next($lines);
	}
	$html .= $indent. "<tgroup cols='$cols'>\n";
	if ($thead != '')
		$html .= $indent. "<thead>\n$thead\n" .
		$indent. "</thead>\n";
	if ($tfoot != '')
		$html .= $indent. "<tfoot>\n$tfoot\n". $indent. "</tfoot>\n";
		
	$html .= $indent. "<tbody>\n$entries". $indent.  "</tbody>\n";
	$html .= $indent. "</tgroup>\n". $indent. "</$tabletagname>\n";
	
	return $html;
}

function block_image(&$lines, &$transformer)
{
	global $InlineImages;
	$line = current($lines);
	$indent = $transformer->Params['indent'];
	$moreindent = $indent . $transformer->Params['IndentChar'];
	$html = '';
	if ( preg_match( '#\[(.*)\]#', $line, $match) )
	{
  		if (preg_match( "#($InlineImages)#", $match[0], $m) )
  		{
 			$html =  "$indent<mediaobject>\n$indent<imageobject>
$moreindent<imagedata fileref=\"". $match[1] . '" format="' . strtoupper($m[1]). "\" />
$indent</imageobject>
$indent</mediaobject>
";
		}
	}
	return $html;
}

function block_ignore(&$lines, &$transformer)
{
	$line = current($lines);
	if ( rtrim($line) == '%%TOC%%' )
		return "<!--  -->\n";
	else
		return '';
}
function parse_person_info($str)
{
	$parts = explode(';', $str);

	$name = explode(' ', $parts[0]);
	$result = '<surname>'. $name[0] . '</surname>';

	if (isset($name[1]))
		$result .= '<firstname>'.$name[1]. "</firstname>\n";

	if (isset($parts[1]))
	{
		$result .= "\t<affiliation>
 	<address><email>$parts[1]</email>
	</address>
	</affiliation>\n";
	}
	return $result; 
}

function parse_revision_info($str)
{
	$result ="\t<revision>\n";
	$parts = explode(';', $str);
	if (isset($parts[0]) )
		$result .= "\t<revnumber>". trim($parts[0]). "</revnumber>\n";
	if (isset($parts[1]) )
		$result .= "\t<date>". trim($parts[1]). "</date>\n";
	if (isset($parts[2]) )
		$result .= "\t<authorinitials>". trim($parts[2]). "</authorinitials>\n";
	if (isset($parts[3]) )
		$result .= "\t<revremark>". trim($parts[3]). "</revremark>\n";
	return $result . "\t</revision>\n\n";
		
}	


function parse_header($str)
{
	$result = array();
	$parts = explode(';', $str);
	$result['IncludeXmlDeclaration'] = false;
	$result['IncludeDtdDeclaration'] = false;
	$result['DtdPath'] = 'PUBLIC "-//OASIS//DTD DocBook XML V4.2//EN" "http://www.oasis-open.org/docbook/xml/4.2/docbookx.dtd"';
	foreach($parts as $val)
	{
		if (strtolower(trim($val)) == 'xml' )
		{
			$result['IncludeXmlDeclaration'] = true;
		}
		else if (strtolower(trim($val)) == 'dtd' )
		{
			$result['IncludeXmlDeclaration'] = true; // DTD Ѵٸ 翬 XML  ϴ  
			$result['IncludeDtdDeclaration'] = true;
		}
		else if (trim($val) != '')
			$result['DtdPath'] = trim($val);
	}
	return $result;

}
function parse_metadata(&$meta)
{
	$Options = array();
	$authors = '';
	$revisions = '';
	$result = '';
	foreach( $meta as $info)
	{
		$type = key($info);
		$val = $info[$type];
		switch ($type)
		{
			case '۾':
				$authors .= "\t<author>\n\t" . parse_person_info($val) 
					. "\t</author>\n\n";
				break;
			case 'ű':
				$authors .= "\t<othercredit role=\"translator\">\n\t"
					. parse_person_info($val) 
					. "\t</othercredit>\n\n";
				break;
			case '':
				$authors .= "\t<editor>\n\t"
					. parse_person_info($val) 
					. "\t</editor>\n\n";
				break;
			case 'ħ':
				$revisions .= parse_revision_info($val);
				break;
			case '':
				$Options['DocType'] = trim($val);
				break;
			case '':
				$Options['DocHeader'] = parse_header($val);
				break;
		}
	}
	if ($authors != '')
		$result .= "<authorgroup>\n" . $authors . "</authorgroup>\n\n";
		
	if ($revisions != '')
		$result .= "<revhistory>\n" . $revisions . "</revhistory>\n\n";
		
	$Options['Info'] = $result;
	return $Options;
}

function metadata(&$lines, &$transformer)
{
	$result = ' ';
	$line = current($lines);
	
	if ( preg_match("#^\@([^\s]+)\s+(.*)#", $line, $match) )
	{
		if ( $match[1] == '//' )
			$result = '<!-- '. str_replace('--', ' -', $match[2]) . " -->\n";
		else
			$transformer->Params['Info'][] = array($match[1] => $match[2]);
	}
	return $result;

}

?>