/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.PrintStream;
import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public final class Closure
extends SequenceValue {
    private Expression expression;
    private XPathContextMajor savedXPathContext;
    private ArrayList reservoir = new ArrayList(50);
    private int state;
    private int depth = 0;
    private static final int UNREAD = 0;
    private static final int MAYBE_MORE = 1;
    private static final int ALL_READ = 3;
    private static final int BUSY = 4;
    SequenceIterator inputIterator;

    private Closure() {
    }

    public static Value make(Expression expression, XPathContext xPathContext) throws XPathException {
        Value[] valueArray;
        Expression expression2;
        Object object;
        if (expression instanceof TailExpression && (object = ((TailExpression)(expression2 = (TailExpression)expression)).getBaseExpression()) instanceof VariableReference && (object = ExpressionTool.lazyEvaluate((Expression)object, xPathContext)) instanceof SequenceExtent) {
            return new SequenceExtent((SequenceExtent)object, ((TailExpression)expression2).getStart() - 1, ((SequenceExtent)object).getLength() - ((TailExpression)expression2).getStart() + 1);
        }
        expression2 = new Closure();
        ((Closure)expression2).expression = expression;
        ((Closure)expression2).savedXPathContext = xPathContext.newContext();
        ((Closure)expression2).savedXPathContext.setOriginatingConstructType(2063);
        object = xPathContext.getStackFrame();
        Value[] valueArray2 = ((StackFrame)object).getStackFrameValues();
        if (valueArray2 != null) {
            valueArray = new Value[valueArray2.length];
            int n = 0;
            while (n < valueArray2.length) {
                if (valueArray2[n] instanceof Closure) {
                    int n2 = ((Closure)valueArray2[n]).depth;
                    if (n2 >= 10) {
                        valueArray2[n] = ExpressionTool.eagerEvaluate(valueArray2[n], xPathContext);
                    } else if (n2 + 1 > ((Closure)expression2).depth) {
                        ((Closure)expression2).depth = n2 + 1;
                    }
                }
                valueArray[n] = valueArray2[n];
                ++n;
            }
            ((Closure)expression2).savedXPathContext.setStackFrame(((StackFrame)object).getStackFrameMap(), valueArray);
        }
        if ((valueArray = xPathContext.getCurrentIterator()) != null) {
            Item item = valueArray.current();
            ((Closure)expression2).savedXPathContext.setCurrentIterator(SingletonIterator.makeIterator(item));
        }
        ((Closure)expression2).state = 0;
        return expression2;
    }

    public ItemType getItemType() {
        return this.expression.getItemType();
    }

    public int getCardinality() {
        return this.expression.getCardinality();
    }

    public int getSpecialProperties() {
        return this.expression.getSpecialProperties();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this.iterate(xPathContext).next();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        switch (this.state) {
            case 0: {
                this.state = 4;
                this.inputIterator = this.expression.iterate(this.savedXPathContext);
                this.state = 1;
                return new ProgressiveIterator();
            }
            case 1: {
                return new ProgressiveIterator();
            }
            case 3: {
                return new ListIterator(this.reservoir);
            }
            case 4: {
                throw new DynamicError("Attempt to access a lazily-evaluated variable while it is being evaluated");
            }
        }
        throw new IllegalStateException("Unknown iterator state");
    }

    public Item itemAt(int n) throws XPathException {
        if (n < this.reservoir.size()) {
            return (Item)this.reservoir.get(n);
        }
        return super.itemAt(n);
    }

    public Object convertToJava(Class clazz, Configuration configuration, XPathContext xPathContext) throws XPathException {
        Value value = ExpressionTool.eagerEvaluate(this, null);
        return value.convertToJava(clazz, configuration, xPathContext);
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "Closure of expression:");
        this.expression.display(n + 1, namePool, printStream);
    }

    public final class ProgressiveIterator
    implements SequenceIterator {
        int position = -1;

        public Item next() throws XPathException {
            if (++this.position < Closure.this.reservoir.size()) {
                return (Item)Closure.this.reservoir.get(this.position);
            }
            Item item = Closure.this.inputIterator.next();
            if (item == null) {
                Closure.this.state = 3;
                --this.position;
                return null;
            }
            this.position = Closure.this.reservoir.size();
            Closure.this.reservoir.add(item);
            Closure.this.state = 1;
            return item;
        }

        public Item current() {
            return (Item)Closure.this.reservoir.get(this.position);
        }

        public int position() {
            return this.position + 1;
        }

        public SequenceIterator getAnother() {
            return new ProgressiveIterator();
        }
    }
}

