/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.util.ArrayList;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AbstractNode;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.tinytree.TinyAttributeImpl;
import net.sf.saxon.tinytree.TinyCommentImpl;
import net.sf.saxon.tinytree.TinyElementImpl;
import net.sf.saxon.tinytree.TinyNamespaceImpl;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyParentNodeImpl;
import net.sf.saxon.tinytree.TinyProcInstImpl;
import net.sf.saxon.tinytree.TinyTextImpl;
import net.sf.saxon.tree.LineNumberMap;
import net.sf.saxon.tree.SystemIdMap;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xpath.XPathException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class TinyDocumentImpl
extends TinyParentNodeImpl
implements DocumentInfo,
Document {
    private HashMap idTable = null;
    private Configuration config;
    private int documentNumber;
    private HashMap elementList = null;
    private boolean usesNamespaces = false;
    private HashMap entityTable = null;
    protected int rootNode = 0;
    protected char[] charBuffer;
    protected int charBufferLength = 0;
    protected StringBuffer commentBuffer = null;
    protected int numberOfNodes = 0;
    protected byte[] nodeKind;
    protected short[] depth;
    protected int[] next;
    protected int[] alpha;
    protected int[] beta;
    protected int[] nameCode;
    protected int[] prior = null;
    private int[] typeCodeArray = null;
    protected int numberOfAttributes = 0;
    protected int[] attParent;
    protected int[] attCode;
    protected CharSequence[] attValue;
    private int[] attTypeCode;
    protected int numberOfNamespaces = 0;
    protected int[] namespaceParent;
    protected int[] namespaceCode;
    private LineNumberMap lineNumberMap;
    private SystemIdMap systemIdMap = null;
    private int IDtype;

    public TinyDocumentImpl() {
        this(4000, 100, 20, 4000);
    }

    public TinyDocumentImpl(int n, int n2, int n3, int n4) {
        this.nodeNr = 0;
        this.document = this;
        this.nodeKind = new byte[n];
        this.depth = new short[n];
        this.next = new int[n];
        this.alpha = new int[n];
        this.beta = new int[n];
        this.nameCode = new int[n];
        this.numberOfAttributes = 0;
        this.attParent = new int[n2];
        this.attCode = new int[n2];
        this.attValue = new String[n2];
        this.numberOfNamespaces = 0;
        this.namespaceParent = new int[n3];
        this.namespaceCode = new int[n3];
        this.charBuffer = new char[n4];
        this.charBufferLength = 0;
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        NamePool namePool = configuration.getNamePool();
        this.addNamespace(0, namePool.getNamespaceCode("xml", "http://www.w3.org/XML/1998/namespace"));
        this.documentNumber = namePool.allocateDocumentNumber(this);
        this.IDtype = namePool.allocate("xs", "http://www.w3.org/2001/XMLSchema", "ID") & 0xFFFFF;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    void ensureNodeCapacity() {
        if (this.nodeKind.length < this.numberOfNodes + 1) {
            int n = this.numberOfNodes * 2;
            byte[] byArray = new byte[n];
            int[] nArray = new int[n];
            short[] sArray = new short[n];
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            System.arraycopy(this.nodeKind, 0, byArray, 0, this.numberOfNodes);
            System.arraycopy(this.next, 0, nArray, 0, this.numberOfNodes);
            System.arraycopy(this.depth, 0, sArray, 0, this.numberOfNodes);
            System.arraycopy(this.alpha, 0, nArray2, 0, this.numberOfNodes);
            System.arraycopy(this.beta, 0, nArray3, 0, this.numberOfNodes);
            System.arraycopy(this.nameCode, 0, nArray4, 0, this.numberOfNodes);
            this.nodeKind = byArray;
            this.next = nArray;
            this.depth = sArray;
            this.alpha = nArray2;
            this.beta = nArray3;
            this.nameCode = nArray4;
            if (this.typeCodeArray != null) {
                int[] nArray5 = new int[n];
                System.arraycopy(this.typeCodeArray, 0, nArray5, 0, this.numberOfNodes);
                this.typeCodeArray = nArray5;
            }
        }
    }

    private void ensureAttributeCapacity() {
        if (this.attParent.length < this.numberOfAttributes + 1) {
            int n = this.numberOfAttributes * 2;
            if (n == 0) {
                n = 10;
            }
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            String[] stringArray = new String[n];
            System.arraycopy(this.attParent, 0, nArray, 0, this.numberOfAttributes);
            System.arraycopy(this.attCode, 0, nArray2, 0, this.numberOfAttributes);
            System.arraycopy(this.attValue, 0, stringArray, 0, this.numberOfAttributes);
            this.attParent = nArray;
            this.attCode = nArray2;
            this.attValue = stringArray;
            if (this.attTypeCode != null) {
                int[] nArray3 = new int[n];
                System.arraycopy(this.attTypeCode, 0, nArray3, 0, this.numberOfAttributes);
                this.attTypeCode = nArray3;
            }
        }
    }

    private void ensureNamespaceCapacity() {
        if (this.namespaceParent.length < this.numberOfNamespaces + 1) {
            int n = this.numberOfNamespaces * 2;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            System.arraycopy(this.namespaceParent, 0, nArray, 0, this.numberOfNamespaces);
            System.arraycopy(this.namespaceCode, 0, nArray2, 0, this.numberOfNamespaces);
            this.namespaceParent = nArray;
            this.namespaceCode = nArray2;
        }
    }

    public void setRootNode(NodeInfo nodeInfo) {
        this.rootNode = ((TinyNodeImpl)nodeInfo).nodeNr;
    }

    int addNode(short s, int n, int n2, int n3, int n4) {
        this.ensureNodeCapacity();
        this.nodeKind[this.numberOfNodes] = (byte)s;
        this.depth[this.numberOfNodes] = (short)n;
        this.alpha[this.numberOfNodes] = n2;
        this.beta[this.numberOfNodes] = n3;
        this.nameCode[this.numberOfNodes] = n4;
        this.next[this.numberOfNodes] = -1;
        if (this.typeCodeArray != null) {
            this.typeCodeArray[this.numberOfNodes] = -1;
        }
        return this.numberOfNodes++;
    }

    void appendChars(CharSequence charSequence) {
        char[] cArray;
        while (this.charBuffer.length < this.charBufferLength + charSequence.length()) {
            cArray = new char[this.charBuffer.length * 2];
            System.arraycopy(this.charBuffer, 0, cArray, 0, this.charBufferLength);
            this.charBuffer = cArray;
        }
        if (charSequence instanceof CharSlice) {
            ((CharSlice)charSequence).copyTo(this.charBuffer, this.charBufferLength);
        } else {
            cArray = charSequence.toString().toCharArray();
            System.arraycopy(cArray, 0, this.charBuffer, this.charBufferLength, charSequence.length());
        }
        this.charBufferLength += charSequence.length();
    }

    public void condense() {
        int[] nArray;
        Object[] objectArray;
        int[] nArray2;
        Object[] objectArray2;
        int n;
        if (this.numberOfNodes * 3 < this.nodeKind.length || this.nodeKind.length - this.numberOfNodes > 20000) {
            n = this.numberOfNodes;
            objectArray2 = new byte[n];
            nArray2 = new int[n];
            objectArray = new short[n];
            nArray = new int[n];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            System.arraycopy(this.nodeKind, 0, objectArray2, 0, this.numberOfNodes);
            System.arraycopy(this.next, 0, nArray2, 0, this.numberOfNodes);
            System.arraycopy(this.depth, 0, objectArray, 0, this.numberOfNodes);
            System.arraycopy(this.alpha, 0, nArray, 0, this.numberOfNodes);
            System.arraycopy(this.beta, 0, nArray3, 0, this.numberOfNodes);
            System.arraycopy(this.nameCode, 0, nArray4, 0, this.numberOfNodes);
            this.nodeKind = objectArray2;
            this.next = nArray2;
            this.depth = objectArray;
            this.alpha = nArray;
            this.beta = nArray3;
            this.nameCode = nArray4;
        }
        if (this.numberOfAttributes * 3 < this.attParent.length || this.attParent.length - this.numberOfAttributes > 1000) {
            n = this.numberOfAttributes;
            objectArray2 = new int[n];
            nArray2 = new int[n];
            objectArray = new String[n];
            System.arraycopy(this.attParent, 0, objectArray2, 0, this.numberOfAttributes);
            System.arraycopy(this.attCode, 0, nArray2, 0, this.numberOfAttributes);
            System.arraycopy(this.attValue, 0, objectArray, 0, this.numberOfAttributes);
            this.attParent = objectArray2;
            this.attCode = nArray2;
            this.attValue = (CharSequence[])objectArray;
            if (this.attTypeCode != null) {
                nArray = new int[n];
                System.arraycopy(this.attTypeCode, 0, nArray, 0, this.numberOfAttributes);
                this.attTypeCode = nArray;
            }
        }
        if (this.numberOfNamespaces * 3 < this.namespaceParent.length) {
            n = this.numberOfNamespaces;
            objectArray2 = new int[n];
            nArray2 = new int[n];
            System.arraycopy(this.namespaceParent, 0, objectArray2, 0, this.numberOfNamespaces);
            System.arraycopy(this.namespaceCode, 0, nArray2, 0, this.numberOfNamespaces);
            this.namespaceParent = objectArray2;
            this.namespaceCode = nArray2;
        }
        if (this.charBufferLength * 3 < this.charBuffer.length || this.charBuffer.length - this.charBufferLength > 10000) {
            char[] cArray = new char[this.charBufferLength];
            System.arraycopy(this.charBuffer, 0, cArray, 0, this.charBufferLength);
            this.charBuffer = cArray;
        }
    }

    void setElementAnnotation(int n, int n2) {
        if (this.typeCodeArray == null) {
            this.typeCodeArray = new int[this.nodeKind.length];
            int n3 = 0;
            while (n3 < this.nodeKind.length) {
                this.typeCodeArray[n3] = -1;
                ++n3;
            }
        }
        this.typeCodeArray[n] = n2;
    }

    int getElementAnnotation(int n) {
        if (this.typeCodeArray == null) {
            return -1;
        }
        return this.typeCodeArray[n];
    }

    void ensurePriorIndex() {
        if (this.prior == null) {
            this.makePriorIndex();
        }
    }

    private synchronized void makePriorIndex() {
        this.prior = new int[this.numberOfNodes];
        int n = 0;
        while (n < this.numberOfNodes) {
            this.prior[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.numberOfNodes) {
            int n3 = this.next[n2];
            if (n3 > n2) {
                this.prior[n3] = n2;
            }
            ++n2;
        }
    }

    void addAttribute(int n, int n2, int n3, CharSequence charSequence, int n4) {
        this.ensureAttributeCapacity();
        this.attParent[this.numberOfAttributes] = n;
        this.attCode[this.numberOfAttributes] = n2;
        this.attValue[this.numberOfAttributes] = charSequence;
        if (n3 != -1 && this.attTypeCode == null) {
            this.attTypeCode = new int[this.attParent.length];
            int n5 = 0;
            while (n5 < this.numberOfAttributes) {
                this.attTypeCode[n5] = -1;
                ++n5;
            }
        }
        if (this.attTypeCode != null) {
            this.attTypeCode[this.numberOfAttributes] = n3;
        }
        if (this.alpha[n] == -1) {
            this.alpha[n] = this.numberOfAttributes;
        }
        if (n3 == this.IDtype || (n4 & 0x400) != 0) {
            if (XMLChar.isValidNCName(charSequence.toString())) {
                if (this.idTable == null) {
                    this.idTable = new HashMap(256);
                }
                TinyNodeImpl tinyNodeImpl = this.getNode(n);
                this.registerID(tinyNodeImpl, charSequence.toString());
            } else if (this.attTypeCode != null) {
                this.attTypeCode[this.numberOfAttributes] = 642;
            }
        }
        ++this.numberOfAttributes;
    }

    void addNamespace(int n, int n2) {
        this.usesNamespaces = true;
        this.ensureNamespaceCapacity();
        this.namespaceParent[this.numberOfNamespaces] = n;
        this.namespaceCode[this.numberOfNamespaces] = n2;
        if (this.beta[n] == -1) {
            this.beta[n] = this.numberOfNamespaces;
        }
        ++this.numberOfNamespaces;
    }

    public TinyNodeImpl getNode(int n) {
        switch ((short)this.nodeKind[n]) {
            case 9: {
                return this;
            }
            case 1: {
                return new TinyElementImpl(this, n);
            }
            case 3: {
                return new TinyTextImpl(this, n);
            }
            case 8: {
                return new TinyCommentImpl(this, n);
            }
            case 7: {
                return new TinyProcInstImpl(this, n);
            }
        }
        return null;
    }

    UntypedAtomicValue getUntypedAtomicValue(int n) {
        switch (this.nodeKind[n]) {
            case 1: 
            case 9: {
                short s = this.depth[n];
                StringBuffer stringBuffer = null;
                int n2 = n + 1;
                while (n2 < this.numberOfNodes && this.depth[n2] > s) {
                    if (this.nodeKind[n2] == 3) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(1024);
                        }
                        int n3 = this.beta[n2];
                        int n4 = this.alpha[n2];
                        stringBuffer.append(this.charBuffer, n4, n3);
                    }
                    ++n2;
                }
                if (stringBuffer == null) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                return new UntypedAtomicValue(stringBuffer);
            }
            case 3: {
                int n5 = this.alpha[n];
                int n6 = this.beta[n];
                return new UntypedAtomicValue(new String(this.charBuffer, n5, n6));
            }
            case 7: 
            case 8: {
                int n7 = this.alpha[n];
                int n8 = this.beta[n];
                if (n8 == 0) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                char[] cArray = new char[n8];
                this.commentBuffer.getChars(n7, n7 + n8, cArray, 0);
                return new UntypedAtomicValue(new String(cArray, 0, n8));
            }
        }
        throw new IllegalStateException("Unknown node kind");
    }

    public long getSequenceNumber() {
        return 0L;
    }

    TinyAttributeImpl getAttributeNode(int n) {
        return new TinyAttributeImpl(this, n);
    }

    int getAttributeAnnotation(int n) {
        if (this.attTypeCode == null) {
            return -1;
        }
        return this.attTypeCode[n];
    }

    boolean isUsingNamespaces() {
        return this.usesNamespaces;
    }

    TinyNamespaceImpl getNamespaceNode(int n) {
        return new TinyNamespaceImpl(this, n);
    }

    public void setSystemId(String string) {
        if (string == null) {
            string = "";
        }
        if (this.systemIdMap == null) {
            this.systemIdMap = new SystemIdMap();
        }
        this.systemIdMap.setSystemId(this.nodeNr, string);
    }

    public String getSystemId() {
        if (this.systemIdMap == null) {
            return null;
        }
        return this.systemIdMap.getSystemId(this.nodeNr);
    }

    public String getBaseURI() {
        return this.getSystemId();
    }

    void setSystemId(int n, String string) {
        if (string == null) {
            string = "";
        }
        if (this.systemIdMap == null) {
            this.systemIdMap = new SystemIdMap();
        }
        this.systemIdMap.setSystemId(n, string);
    }

    String getSystemId(int n) {
        if (this.systemIdMap == null) {
            return null;
        }
        return this.systemIdMap.getSystemId(n);
    }

    public void setLineNumbering() {
        this.lineNumberMap = new LineNumberMap();
        this.lineNumberMap.setLineNumber(0, 0);
    }

    void setLineNumber(int n, int n2) {
        if (this.lineNumberMap != null) {
            this.lineNumberMap.setLineNumber(n, n2);
        }
    }

    int getLineNumber(int n) {
        if (this.lineNumberMap != null) {
            return this.lineNumberMap.getLineNumber(n);
        }
        return -1;
    }

    public int getLineNumber() {
        return 0;
    }

    public final int getNodeKind() {
        return 9;
    }

    public NodeInfo getParent() {
        return null;
    }

    public NodeInfo getRoot() {
        return this.rootNode == this.nodeNr ? this : this.getNode(this.rootNode);
    }

    public DocumentInfo getDocumentRoot() {
        return this.rootNode == this.nodeNr ? this : null;
    }

    public String generateId() {
        return "d" + this.documentNumber;
    }

    AxisIterator getAllElements(int n) {
        ArrayList<TinyNodeImpl> arrayList;
        Integer n2 = new Integer(n);
        if (this.elementList == null) {
            this.elementList = new HashMap(20);
        }
        if ((arrayList = (ArrayList<TinyNodeImpl>)this.elementList.get(n2)) == null) {
            arrayList = new ArrayList<TinyNodeImpl>(this.numberOfNodes / 20);
            int n3 = 1;
            while (n3 < this.numberOfNodes) {
                if (this.nodeKind[n3] == 1 && (this.nameCode[n3] & 0xFFFFF) == n) {
                    arrayList.add(this.getNode(n3));
                }
                ++n3;
            }
            this.elementList.put(n2, arrayList);
        }
        return new ListIterator(arrayList);
    }

    private void registerID(NodeInfo nodeInfo, String string) {
        NodeInfo nodeInfo2 = (NodeInfo)this.idTable.get(string);
        if (nodeInfo2 == null) {
            this.idTable.put(string, nodeInfo);
        }
    }

    public NodeInfo selectID(String string) {
        if (this.idTable == null) {
            return null;
        }
        return (NodeInfo)this.idTable.get(string);
    }

    void setUnparsedEntity(String string, String string2, String string3) {
        if (this.entityTable == null) {
            this.entityTable = new HashMap(20);
        }
        String[] stringArray = new String[]{string2, string3};
        this.entityTable.put(string, stringArray);
    }

    public String[] getUnparsedEntity(String string) {
        if (this.entityTable == null) {
            return null;
        }
        return (String[])this.entityTable.get(string);
    }

    public String getInputEncoding() {
        return null;
    }

    public String getXmlEncoding() {
        return null;
    }

    public boolean getXmlStandalone() {
        return false;
    }

    public void setXmlStandalone(boolean bl) throws DOMException {
        AbstractNode.disallowUpdate();
    }

    public String getXmlVersion() {
        return "1.0";
    }

    public void setXmlVersion(String string) throws DOMException {
        AbstractNode.disallowUpdate();
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public void setStrictErrorChecking(boolean bl) {
        AbstractNode.disallowUpdate();
    }

    public String getDocumentURI() {
        return this.getSystemId();
    }

    public void setDocumentURI(String string) {
        AbstractNode.disallowUpdate();
    }

    public Node adoptNode(Node node) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public void normalizeDocument() {
        AbstractNode.disallowUpdate();
    }

    public Node renameNode(Node node, String string, String string2) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        NodeInfo nodeInfo;
        receiver.startDocument(0);
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            nodeInfo.copy(receiver, n, bl, n2);
        }
        receiver.endDocument();
    }

    public void diagnosticDump() {
        System.err.println("    node    type   depth    next   alpha    beta    name");
        int n = 0;
        while (n < this.numberOfNodes) {
            System.err.println(this.n8(n) + this.n8(this.nodeKind[n]) + this.n8(this.depth[n]) + this.n8(this.next[n]) + this.n8(this.alpha[n]) + this.n8(this.beta[n]) + this.n8(this.nameCode[n]));
            ++n;
        }
        System.err.println("    attr  parent    name    value");
        int n2 = 0;
        while (n2 < this.numberOfAttributes) {
            System.err.println(this.n8(n2) + this.n8(this.attParent[n2]) + this.n8(this.attCode[n2]) + "    " + this.attValue[n2]);
            ++n2;
        }
        System.err.println("      ns  parent  prefix     uri");
        int n3 = 0;
        while (n3 < this.numberOfNamespaces) {
            System.err.println(this.n8(n3) + this.n8(this.namespaceParent[n3]) + this.n8(this.namespaceCode[n3] >> 16) + this.n8(this.namespaceCode[n3] & 0xFFFF));
            ++n3;
        }
    }

    private String n8(int n) {
        String string = "        " + n;
        return string.substring(string.length() - 8);
    }

    public void showSize() {
        System.err.println("Tree size: " + this.numberOfNodes + " nodes, " + this.charBufferLength + " characters, " + this.numberOfAttributes + " attributes");
    }
}

