/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.LocalVariable;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class XSLVariable
extends XSLVariableDeclaration {
    private int state = 0;

    public void prepareAttributes() throws TransformerConfigurationException {
        if (this.state == 2) {
            return;
        }
        if (this.state == 1) {
            this.compileError("Circular reference to variable");
        }
        this.state = 1;
        super.prepareAttributes();
        this.state = 2;
    }

    public boolean isInstruction() {
        return true;
    }

    public SequenceType getRequiredType() {
        SequenceType sequenceType;
        SequenceType sequenceType2 = sequenceType = this.requiredType == null ? SequenceType.ANY_SEQUENCE : this.requiredType;
        if (this.assignable) {
            return sequenceType;
        }
        if (this.requiredType != null) {
            return this.requiredType;
        }
        if (this.select != null) {
            if (this.select instanceof EmptySequence) {
                return sequenceType;
            }
            try {
                return new SequenceType(this.select.getItemType(), this.select.getCardinality());
            }
            catch (Exception exception) {
                return sequenceType;
            }
        }
        if (this.hasChildNodes()) {
            return new SequenceType(NodeKindTest.DOCUMENT, 512);
        }
        return SequenceType.SINGLE_STRING;
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        if (this.references.size() == 0 && !this.assignable) {
            this.redundant = true;
        }
        if (!this.redundant) {
            GeneralVariable generalVariable;
            if (this.global) {
                generalVariable = new GlobalVariable();
                ((GlobalVariable)generalVariable).setExecutable(this.getExecutable());
                if (this.select instanceof ComputedExpression) {
                    ((ComputedExpression)this.select).setParentExpression(generalVariable);
                }
            } else {
                generalVariable = new LocalVariable();
            }
            this.initializeInstruction(executable, generalVariable);
            generalVariable.setVariableName(this.getVariableName());
            generalVariable.setSlotNumber(this.getSlotNumber());
            generalVariable.setRequiredType(this.getRequiredType());
            ExpressionTool.makeParentReferences(generalVariable);
            this.fixupBinding(generalVariable);
            return generalVariable;
        }
        return null;
    }
}

