/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.EmptySequence;

public final class XSLSequence
extends StyleElement {
    private Expression select;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return this.select.getItemType();
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public boolean mayContainFallback() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "select") {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        } else {
            this.reportAbsence("select");
            this.select = EmptySequence.getInstance();
        }
    }

    public void validate() throws TransformerConfigurationException {
        NodeInfo nodeInfo;
        this.checkWithinTemplate();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo instanceof XSLFallback) continue;
            this.compileError("The only child node allowed for xsl:sequence is an xsl:fallback instruction");
            break;
        }
        this.select = this.typeCheck("select", this.select);
    }

    public void markTailCalls() {
        StyleElement styleElement = this.getLastChildInstruction();
        if (styleElement != null) {
            styleElement.markTailCalls();
        } else if (this.select != null) {
            ExpressionTool.markTailFunctionCalls(this.select);
        }
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        return this.select;
    }
}

