/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.InstructionWithChildren;
import net.sf.saxon.instruct.ResultDocument;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class XSLResultDocument
extends StyleElement {
    private static final HashSet fans = new HashSet(25);
    private Expression href;
    private int format = -1;
    private int validationAction = 4;
    private SchemaType schemaType = null;
    private HashMap serializationAttributes = new HashMap();

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return null;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string5 = this.getNamePool().getClarkName(n2);
            if (string5 == "format") {
                string = attributeCollection.getValue(n).trim();
            } else if (string5 == "href") {
                string2 = attributeCollection.getValue(n).trim();
            } else if (string5 == "validation") {
                string3 = attributeCollection.getValue(n).trim();
            } else if (string5 == "type") {
                string4 = attributeCollection.getValue(n).trim();
            } else if (fans.contains(string5) || !string5.startsWith("{}")) {
                String string6 = attributeCollection.getValue(n).trim();
                Expression expression = this.makeAttributeValueTemplate(string6);
                this.serializationAttributes.put(new Integer(n2 & 0xFFFFF), expression);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string2 != null) {
            this.href = this.makeAttributeValueTemplate(string2);
        }
        if (string != null) {
            try {
                this.format = this.makeNameCode(string.trim()) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage());
            }
        }
        if (string3 == null) {
            this.validationAction = this.getContainingStylesheet().getDefaultValidation();
        } else {
            this.validationAction = Validation.getCode(string3);
            if (this.validationAction != 4 && !this.getConfiguration().isSchemaAware(10)) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed");
            }
            if (this.validationAction == -1) {
                this.compileError("Invalid value of validation attribute");
            }
        }
        if (string4 != null) {
            if (!this.getConfiguration().isSchemaAware(10)) {
                this.compileError("The type attribute is available only with a schema-aware XSLT processor");
            }
            this.schemaType = this.getSchemaType(string4);
        }
        if (string4 != null && string3 != null) {
            this.compileError("validation and type attributes are mutually exclusive");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        if (!this.getPreparedStylesheet().getConfiguration().isAllowExternalFunctions()) {
            this.compileError("xsl:result-document is disabled when extension functions are disabled");
        }
        this.href = this.typeCheck("href", this.href);
        Iterator iterator = this.serializationAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            Expression expression;
            Integer n = (Integer)iterator.next();
            Expression expression2 = (Expression)this.serializationAttributes.get(n);
            if (expression2 == (expression = this.typeCheck(this.getNamePool().getDisplayName(n), expression2))) continue;
            this.serializationAttributes.put(n, expression);
        }
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        Expression expression;
        Object object;
        Properties properties = null;
        try {
            properties = this.getPrincipalStylesheet().gatherOutputProperties(this.format);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.compileError("Named output format has not been defined");
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        Iterator iterator = this.serializationAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            object = (Integer)iterator.next();
            expression = (Expression)this.serializationAttributes.get(object);
            if (expression instanceof StringValue) {
                string = ((StringValue)expression).getStringValue();
                try {
                    ResultDocument.setSerializationProperty(properties, (Integer)object, string, this.getNamePool(), this.getStaticContext().getNamespaceResolver());
                    arrayList.add(object);
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException);
                }
                continue;
            }
            string = this.getNamePool().getLocalName((Integer)object);
            if (!string.equals("method") && !string.equals("cdata-section-elements")) continue;
            bl = true;
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            this.serializationAttributes.remove(object.next());
        }
        expression = new ResultDocument(properties, this.href, this.getBaseURI(), this.validationAction, this.schemaType, this.serializationAttributes, bl ? this.getStaticContext().getNamespaceResolver() : null);
        this.compileChildren(executable, (InstructionWithChildren)expression, true);
        ExpressionTool.makeParentReferences(expression);
        return expression;
    }

    static {
        fans.add("method");
        fans.add("output-version");
        fans.add("indent");
        fans.add("encoding");
        fans.add("media-type");
        fans.add("doctype-system");
        fans.add("doctype-public");
        fans.add("omit-xml-declaration");
        fans.add("standalone");
        fans.add("cdata-section-elements");
        fans.add("include-content-type");
        fans.add("escape-uri-attributes");
        fans.add("undeclare-namespaces");
        fans.add("{http://saxon.sf.net/}next-in-chain");
        fans.add("{http://saxon.sf.net/}character-representation");
        fans.add("{http://saxon.sf.net/}indent-spaces");
        fans.add("{http://saxon.sf.net/}byte-order-mark");
        fans.add("{http://saxon.sf.net/}require-well-formed");
    }
}

