/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.SortExpression;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.xpath.XPathException;

public class XSLPerformSort
extends StyleElement {
    Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        if (this.select == null) {
            return this.getCommonChildItemType();
        }
        return this.select.getItemType();
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "select") {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.checkSortComesFirst(true);
        if (this.select != null) {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = this.iterateAxis((byte)3);
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (nodeInfo instanceof XSLSort || nodeInfo instanceof XSLFallback) continue;
                if (nodeInfo.getNodeKind() == 3 && !Navigator.isWhite(nodeInfo.getStringValue())) {
                    this.compileError("Within xsl:perform-sort, significant text must not appear if there is a select attribute");
                    continue;
                }
                ((StyleElement)nodeInfo).compileError("Within xsl:perform-sort, child instructions are not allowed if there is a select attribute");
            }
        }
        this.select = this.typeCheck("select", this.select);
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        SortKeyDefinition[] sortKeyDefinitionArray = this.makeSortKeys();
        if (this.select != null) {
            SortExpression sortExpression = new SortExpression(this.select, sortKeyDefinitionArray);
            ExpressionTool.makeParentReferences(sortExpression);
            return sortExpression;
        }
        Block block = new Block();
        this.compileChildren(executable, block, true);
        try {
            SortExpression sortExpression = new SortExpression(block.simplify(this.getStaticContext()), sortKeyDefinitionArray);
            ExpressionTool.makeParentReferences(sortExpression);
            return sortExpression;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return null;
        }
    }
}

