/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import java.text.Collator;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.Err;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.InstructionWithChildren;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class XSLKey
extends StyleElement
implements StylesheetProcedure {
    private Pattern match;
    private Expression use;
    private String collationName;
    SlotManager stackFrameMap;

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        String string2 = null;
        String string3 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string4 = this.getNamePool().getClarkName(n2);
            if (string4 == "name") {
                string = attributeCollection.getValue(n).trim();
            } else if (string4 == "use") {
                string3 = attributeCollection.getValue(n);
            } else if (string4 == "match") {
                string2 = attributeCollection.getValue(n);
            } else if (string4 == "collation") {
                this.collationName = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        try {
            this.setObjectNameCode(this.makeNameCode(string.trim()));
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage());
        }
        if (string2 == null) {
            this.reportAbsence("match");
            string2 = "*";
        }
        this.match = this.makePattern(string2);
        if (string3 != null) {
            this.use = this.makeExpression(string3);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel(null);
        if (this.use != null) {
            if (this.hasChildNodes()) {
                this.compileError("An xsl:key element with a use attribute must be empty", "XT1205");
            }
            try {
                RoleLocator roleLocator = new RoleLocator(4, "xsl:key/use", 0);
                this.use = TypeChecker.staticTypeCheck(this.use, new SequenceType(Type.ANY_ATOMIC_TYPE, 1792), false, roleLocator, this.getStaticContext());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        } else if (!this.hasChildNodes()) {
            this.compileError("An xsl:key element must either have a use attribute or have content", "XT1205");
        }
        this.use = this.typeCheck("use", this.use);
        this.match = this.typeCheck("match", this.match);
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        Serializable serializable;
        Object object;
        Collator collator = null;
        if (this.collationName != null) {
            object = this.getPrincipalStylesheet().findCollation(this.collationName);
            if (object == null) {
                this.compileError("The collation name " + Err.wrap(this.collationName) + " is not recognized", "XT1210");
            }
            if (!(object instanceof Collator)) {
                this.compileError("The collation used for xsl:key must be a java.text.Collator", "XT1210");
            }
            collator = (Collator)object;
        }
        if (this.use == null) {
            object = new Block();
            this.compileChildren(executable, (InstructionWithChildren)object, true);
            try {
                this.use = new Atomizer(((Block)object).simplify(this.getStaticContext()));
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
            try {
                serializable = new RoleLocator(4, "xsl:key/use", 0);
                this.use = TypeChecker.staticTypeCheck(this.use, new SequenceType(Type.ANY_ATOMIC_TYPE, 1792), false, (RoleLocator)serializable, this.getStaticContext());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        this.allocateSlots(this.use);
        object = this.getPrincipalStylesheet().getKeyManager();
        serializable = new KeyDefinition(this.match, this.use, this.collationName, collator);
        ((KeyDefinition)serializable).setStackFrameMap(this.stackFrameMap);
        ((KeyDefinition)serializable).setLocation(this.getSystemId(), this.getLineNumber());
        ((Procedure)serializable).setExecutable(this.getExecutable());
        try {
            ((KeyManager)object).setKeyDefinition(this.getObjectFingerprint(), (KeyDefinition)serializable);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.compileError(transformerConfigurationException);
        }
        return null;
    }
}

