/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Choose;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionWithChildren;
import net.sf.saxon.instruct.TraceWrapper;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.xpath.XPathException;

public class XSLChoose
extends StyleElement {
    private StyleElement otherwise;
    private int numberOfWhens = 0;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            this.checkUnknownAttribute(n2);
            ++n;
        }
    }

    public void validate() throws TransformerConfigurationException {
        NodeInfo nodeInfo;
        this.checkWithinTemplate();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo instanceof XSLWhen) {
                if (this.otherwise != null) {
                    this.compileError("xsl:otherwise must come last");
                }
                ++this.numberOfWhens;
                continue;
            }
            if (nodeInfo instanceof XSLOtherwise) {
                if (this.otherwise != null) {
                    this.compileError("Only one xsl:otherwise allowed in an xsl:choose");
                    continue;
                }
                this.otherwise = (StyleElement)nodeInfo;
                continue;
            }
            if (nodeInfo.getNodeKind() == 3 && Navigator.isWhite(nodeInfo.getStringValue())) {
                this.compileError("Text node inside xsl:choose");
                continue;
            }
            this.compileError("Only xsl:when and xsl:otherwise are allowed here");
        }
        if (this.numberOfWhens == 0) {
            this.compileError("xsl:choose must contain at least one xsl:when");
        }
    }

    public void markTailCalls() {
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).markTailCalls();
        }
        return;
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        Instruction[] instructionArray;
        Expression[] expressionArray;
        int n = this.numberOfWhens + (this.otherwise == null ? 0 : 1);
        Expression[] expressionArray2 = new Expression[n];
        Expression[] expressionArray3 = new Expression[n];
        int n2 = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((expressionArray = (NodeInfo)axisIterator.next()) != null) {
            TraceWrapper traceWrapper;
            if (expressionArray instanceof XSLWhen) {
                expressionArray2[n2] = ((XSLWhen)expressionArray).getCondition();
                instructionArray = new Block();
                instructionArray.setLocationId(this.allocateLocationId(this.getSystemId(), expressionArray.getLineNumber()));
                ((XSLWhen)expressionArray).compileChildren(executable, (InstructionWithChildren)instructionArray, true);
                try {
                    expressionArray3[n2] = instructionArray.simplify(((XSLWhen)expressionArray).getStaticContext());
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException);
                }
                if (this.getConfiguration().getTraceListener() != null) {
                    traceWrapper = StyleElement.makeTraceInstruction((XSLWhen)expressionArray, expressionArray3[n2]);
                    traceWrapper.setParentExpression((Container)instructionArray);
                    expressionArray3[n2] = traceWrapper;
                }
                if (expressionArray2[n2] instanceof BooleanValue) {
                    if (((BooleanValue)expressionArray2[n2]).getBooleanValue()) {
                        n = n2 + 1;
                        break;
                    }
                    --n2;
                    --n;
                }
                ++n2;
                continue;
            }
            if (expressionArray instanceof XSLOtherwise) {
                expressionArray2[n2] = BooleanValue.TRUE;
                instructionArray = new Block();
                instructionArray.setLocationId(this.allocateLocationId(this.getSystemId(), expressionArray.getLineNumber()));
                ((XSLOtherwise)expressionArray).compileChildren(executable, (InstructionWithChildren)instructionArray, true);
                try {
                    expressionArray3[n2] = instructionArray.simplify(((XSLOtherwise)expressionArray).getStaticContext());
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException);
                }
                if (this.getConfiguration().getTraceListener() != null) {
                    traceWrapper = StyleElement.makeTraceInstruction((XSLOtherwise)expressionArray, expressionArray3[n2]);
                    traceWrapper.setParentExpression((Container)instructionArray);
                    expressionArray3[n2] = traceWrapper;
                }
                ++n2;
                continue;
            }
            new AssertionError((Object)"Expected xsl:when or xsl:otherwise");
        }
        if (expressionArray2.length != n) {
            if (n == 0) {
                return null;
            }
            if (n == 1 && expressionArray2[0] instanceof BooleanValue) {
                if (((BooleanValue)expressionArray2[0]).getBooleanValue()) {
                    return expressionArray3[0];
                }
                return null;
            }
            expressionArray = new Expression[n];
            System.arraycopy(expressionArray2, 0, expressionArray, 0, n);
            instructionArray = new Instruction[n];
            System.arraycopy(expressionArray3, 0, instructionArray, 0, n);
            expressionArray2 = expressionArray;
            expressionArray3 = instructionArray;
        }
        expressionArray = new Choose(expressionArray2, expressionArray3);
        ExpressionTool.makeParentReferences((Expression)expressionArray);
        return expressionArray;
    }
}

