/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Iterator;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.xpath.XPathException;

public class SaxonImportQuery
extends StyleElement {
    private String href;
    private String moduleURI;

    public void importModule() throws TransformerConfigurationException {
        this.prepareAttributes();
        this.loadLibraryModule();
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        if (this.href != null || this.moduleURI != null) {
            return;
        }
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string = this.getNamePool().getClarkName(n2);
            if (string == "href") {
                this.href = attributeCollection.getValue(n).trim();
            } else if (string == "namespace") {
                this.moduleURI = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
                this.moduleURI = "";
            }
            ++n;
        }
        if (this.href == null && this.moduleURI == null) {
            this.compileError("At least one of href or namespace must be specified");
            this.moduleURI = "";
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkEmpty();
        this.checkTopLevel(null);
    }

    private void loadLibraryModule() throws TransformerConfigurationException {
        if (this.href == null && this.moduleURI == null) {
            return;
        }
        try {
            XSLStylesheet xSLStylesheet = this.getPrincipalStylesheet();
            this.getExecutable().setFunctionLibrary(new ExecutableFunctionLibrary(this.getConfiguration()));
            StaticQueryContext staticQueryContext = this.loadModule(this.moduleURI, this.href);
            short s = staticQueryContext.getModuleNamespaceCode();
            NamePool namePool = this.getTargetNamePool();
            Iterator iterator = staticQueryContext.getFunctionDefinitions();
            while (iterator.hasNext()) {
                XQueryFunction xQueryFunction = (XQueryFunction)iterator.next();
                if (namePool.getURICode(xQueryFunction.getFunctionFingerprint()) != s) continue;
                xSLStylesheet.declareXQueryFunction(xQueryFunction);
            }
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
    }

    private StaticQueryContext loadModule(String string, String string2) throws XPathException {
        return StaticQueryContext.loadQueryModule(this.getConfiguration(), this.getExecutable(), this.getBaseURI(), string, string2);
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        return null;
    }
}

