/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Text;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.StaticError;

public class SaxonEntityRef
extends StyleElement {
    String nameAttribute;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string = this.getNamePool().getClarkName(n2);
            if (string == "name") {
                this.nameAttribute = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (this.nameAttribute == null) {
            this.reportAbsence("name");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.checkEmpty();
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        Text text = new Text(true);
        try {
            text.setSelect(new StringValue('&' + this.nameAttribute + ';'));
        }
        catch (StaticError staticError) {
            this.compileError(staticError);
        }
        ExpressionTool.makeParentReferences(text);
        return text;
    }
}

