/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.FixedAttribute;
import net.sf.saxon.instruct.FixedElement;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class LiteralResultElement
extends StyleElement {
    private int resultNameCode;
    private int[] attributeNames;
    private Expression[] attributeValues;
    private boolean[] attributeChecked;
    private int numberOfAttributes;
    private boolean toplevel;
    private int[] namespaceCodes;
    private AttributeSet[] attributeSets;
    private SchemaType schemaType = null;
    private int validation = 4;
    private boolean inheritNamespaces = true;

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        int n = this.attributeList.getLength();
        if (n == 0) {
            this.numberOfAttributes = 0;
        } else {
            NamePool namePool = this.getNamePool();
            this.attributeNames = new int[n];
            this.attributeValues = new Expression[n];
            this.attributeChecked = new boolean[n];
            this.numberOfAttributes = 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.attributeList.getNameCode(n2);
                short s = namePool.getURICode(n3);
                if (s == 2) {
                    int n4 = n3 & 0xFFFFF;
                    if (n4 != 233 && n4 != 230 && n4 != 229 && n4 != 235 && n4 != 228 && n4 != 232 && n4 != 234) {
                        if (n4 == 231) {
                            String string = this.attributeList.getValue(n2);
                            if (string.equals("yes")) {
                                this.inheritNamespaces = true;
                            } else if (string.equals("no")) {
                                this.inheritNamespaces = false;
                            } else {
                                this.compileError("The xsl:inherit-namespaces attribute has permitted values (yes, no)");
                            }
                        } else {
                            this.compileError("Unknown XSL attribute " + namePool.getDisplayName(n3));
                        }
                    }
                } else {
                    Expression expression;
                    this.attributeNames[this.numberOfAttributes] = n3;
                    this.attributeValues[this.numberOfAttributes] = expression = this.makeAttributeValueTemplate(this.attributeList.getValue(n2));
                    this.attributeChecked[this.numberOfAttributes] = false;
                    boolean bl = false;
                    if (expression instanceof StringValue) {
                        String string = ((StringValue)expression).getStringValue();
                        int n5 = 0;
                        while (n5 < string.length()) {
                            char c = string.charAt(n5);
                            if (c < '!' || c > '~' || c == '<' || c == '>' || c == '&' || c == '\"') {
                                bl = true;
                                break;
                            }
                            ++n5;
                        }
                        this.attributeChecked[this.numberOfAttributes] = !bl;
                    }
                    ++this.numberOfAttributes;
                }
                ++n2;
            }
            if (this.numberOfAttributes < this.attributeNames.length) {
                int[] nArray = new int[this.numberOfAttributes];
                System.arraycopy(this.attributeNames, 0, nArray, 0, this.numberOfAttributes);
                this.attributeNames = nArray;
                Expression[] expressionArray = new Expression[this.numberOfAttributes];
                System.arraycopy(this.attributeValues, 0, expressionArray, 0, this.numberOfAttributes);
                this.attributeValues = expressionArray;
                boolean[] blArray = new boolean[this.numberOfAttributes];
                System.arraycopy(this.attributeChecked, 0, blArray, 0, this.numberOfAttributes);
                this.attributeChecked = blArray;
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.toplevel = this.getParentNode() instanceof XSLStylesheet;
        this.resultNameCode = this.getNameCode();
        NamePool namePool = this.getNamePool();
        short s = namePool.getURICode(this.resultNameCode);
        if (this.toplevel) {
            if (s == 0) {
                this.compileError("Top level elements must have a non-null namespace URI");
            }
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            String string;
            String string2;
            String string3;
            boolean bl = false;
            NodeInfo nodeInfo = this.getParent();
            if (nodeInfo instanceof LiteralResultElement && ((LiteralResultElement)nodeInfo).inheritNamespaces && (this.namespaceList == null || this.namespaceList.length == 0) && s == namePool.getURICode(this.getParent().getFingerprint())) {
                bl = true;
            }
            if (bl) {
                int n5 = 0;
                while (n5 < this.attributeList.getLength()) {
                    if ((this.attributeList.getNameCode(n5) >> 20 & 0xFF) != 0) {
                        bl = false;
                        break;
                    }
                    ++n5;
                }
            }
            this.namespaceCodes = bl ? new int[0] : this.getNamespaceCodes();
            XSLStylesheet xSLStylesheet = this.getPrincipalStylesheet();
            if (xSLStylesheet.hasNamespaceAliases()) {
                int n6;
                int n7 = 0;
                while (n7 < this.namespaceCodes.length) {
                    n6 = (short)(this.namespaceCodes[n7] & 0xFFFF);
                    int n8 = xSLStylesheet.getNamespaceAlias((short)n6);
                    if (n8 != -1 && (n8 & 0xFFFF) != n6) {
                        this.namespaceCodes[n7] = n8;
                    }
                    ++n7;
                }
                n6 = xSLStylesheet.getNamespaceAlias(s);
                if ((n6 & 0xFFFF) != s) {
                    s = (short)(n6 & 0xFFFF);
                    this.resultNameCode = namePool.allocate(namePool.getPrefixFromNamespaceCode(n6), namePool.getURIFromNamespaceCode(n6), this.getLocalPart());
                }
            }
            if ((string3 = this.getAttributeValue(233)) != null) {
                this.attributeSets = this.getAttributeSets(string3, null);
            }
            if ((string2 = this.getAttributeValue(232)) != null) {
                if (!this.getConfiguration().isSchemaAware(10)) {
                    this.compileError("The xsl:type attribute is available only with a schema-aware XSLT processor");
                }
                this.schemaType = this.getSchemaType(string2);
            }
            if ((string = this.getAttributeValue(234)) != null) {
                this.validation = Validation.getCode(string);
                if (this.validation != 4 && !this.getConfiguration().isSchemaAware(10)) {
                    this.compileError("To perform validation, a schema-aware XSLT processor is needed");
                }
                if (this.validation == -1) {
                    this.compileError("Invalid value for xsl:validation. Permitted values are (strict, lax, preserve, strip)");
                }
            } else {
                this.validation = this.getContainingStylesheet().getDefaultValidation();
            }
            short[] sArray = new short[this.numberOfAttributes];
            if (this.numberOfAttributes > 0) {
                n4 = 0;
                while (n4 < this.numberOfAttributes) {
                    n2 = n3 = this.attributeNames[n4];
                    short s2 = namePool.getURICode(n3);
                    if (s2 != 0 && ((n = xSLStylesheet.getNamespaceAlias(s2)) & 0xFFFF) != s2) {
                        s2 = (short)(n & 0xFFFF);
                        n2 = namePool.allocate(namePool.getPrefixFromNamespaceCode(n), namePool.getURIFromNamespaceCode(n), this.attributeList.getLocalName(n4));
                    }
                    this.attributeNames[n4] = n2;
                    sArray[n4] = s2;
                    this.attributeValues[n4] = this.typeCheck(namePool.getDisplayName(n2), this.attributeValues[n4]);
                    ++n4;
                }
            }
            n4 = 0;
            n3 = 0;
            while (n3 < this.namespaceCodes.length) {
                n2 = (short)(this.namespaceCodes[n3] & 0xFFFF);
                if (this.isExcludedNamespace((short)n2) && !xSLStylesheet.isAliasResultNamespace((short)n2)) {
                    this.namespaceCodes[n3] = -1;
                    ++n4;
                }
                ++n3;
            }
            n2 = this.namespaceCodes.length - n4;
            int[] nArray = new int[n2];
            n2 = 0;
            n = 0;
            while (n < this.namespaceCodes.length) {
                if (this.namespaceCodes[n] != -1) {
                    nArray[n2++] = this.namespaceCodes[n];
                }
                ++n;
            }
            this.namespaceCodes = nArray;
        }
    }

    protected void validateChildren() throws TransformerConfigurationException {
        if (!this.toplevel) {
            super.validateChildren();
        }
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        if (this.toplevel) {
            return null;
        }
        FixedElement fixedElement = new FixedElement(this.resultNameCode, this.namespaceCodes, this.attributeSets, this.inheritNamespaces, this.schemaType, this.validation);
        Expression[] expressionArray = this.compileChildren(executable, fixedElement, true);
        Instruction[] instructionArray = null;
        if (this.numberOfAttributes > 0) {
            Object object;
            instructionArray = new Instruction[this.attributeNames.length];
            int n = 0;
            while (n < instructionArray.length) {
                object = new FixedAttribute(this.attributeNames[n], 4, null, -1);
                try {
                    ((FixedAttribute)object).setSelect(this.attributeValues[n]);
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException);
                }
                ((ComputedExpression)object).setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                ((ComputedExpression)object).setParentExpression(fixedElement);
                ExpressionTool.makeParentReferences((Expression)object);
                if (this.attributeChecked[n]) {
                    ((FixedAttribute)object).setNoSpecialChars();
                }
                instructionArray[n] = object;
                ++n;
            }
            object = new Expression[instructionArray.length + expressionArray.length];
            System.arraycopy(instructionArray, 0, object, 0, instructionArray.length);
            System.arraycopy(expressionArray, 0, object, instructionArray.length, expressionArray.length);
            fixedElement.setChildren((Expression[])object);
        }
        ExpressionTool.makeParentReferences(fixedElement);
        return fixedElement;
    }

    public DocumentImpl makeStylesheet(PreparedStylesheet preparedStylesheet, StyleNodeFactory styleNodeFactory) throws TransformerConfigurationException {
        NamePool namePool = this.getNamePool();
        String string = this.getPrefixForURI("http://www.w3.org/1999/XSL/Transform");
        if (string == null) {
            String string2 = this.getLocalPart().equals("stylesheet") || this.getLocalPart().equals("transform") ? (this.getPrefixForURI("http://www.w3.org/TR/WD-xsl") != null ? "Saxon is not able to process Microsoft's WD-xsl dialect" : "Namespace for stylesheet element should be http://www.w3.org/1999/XSL/Transform") : "The supplied file does not appear to be a stylesheet";
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string2);
            transformerConfigurationException.setLocator(this);
            try {
                preparedStylesheet.reportError(transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw transformerConfigurationException;
        }
        String string3 = this.getAttributeValue(235);
        if (string3 == null) {
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException("Literal Result Element As Stylesheet: xsl:version attribute is missing");
            transformerConfigurationException.setLocator(this);
            try {
                preparedStylesheet.reportError(transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw transformerConfigurationException;
        }
        try {
            TreeBuilder treeBuilder = new TreeBuilder();
            treeBuilder.setDocumentLocator(null);
            treeBuilder.setConfiguration(preparedStylesheet.getConfiguration());
            treeBuilder.setNodeFactory(styleNodeFactory);
            treeBuilder.setSystemId(this.getSystemId());
            treeBuilder.open();
            int n = 180;
            treeBuilder.startElement(n, -1, 0, 0);
            treeBuilder.namespace(2, 0);
            treeBuilder.attribute(namePool.allocate("", "", "version"), -1, string3, 0, 0);
            treeBuilder.startContent();
            int n2 = 181;
            treeBuilder.startElement(n2, -1, 0, 0);
            treeBuilder.attribute(namePool.allocate("", "", "match"), -1, "/", 0, 0);
            treeBuilder.startContent();
            treeBuilder.graftElement(this);
            treeBuilder.endElement();
            treeBuilder.endElement();
            treeBuilder.close();
            return (DocumentImpl)treeBuilder.getCurrentDocument();
        }
        catch (XPathException xPathException) {
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(xPathException);
            transformerConfigurationException.setLocator(this);
            throw transformerConfigurationException;
        }
    }

    public int getConstructType() {
        return 2006;
    }

    public int getObjectNameCode() {
        return this.resultNameCode;
    }

    public Object getProperty(String string) {
        if (string.equals("name")) {
            return this.getDisplayName();
        }
        return null;
    }
}

