/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.XPathException;

public class GroupByIterator
implements GroupIterator {
    private SequenceIterator population;
    private Expression keyExpression;
    private Comparator collator;
    private XPathContext keyContext;
    private int position = 0;
    private ArrayList groups = new ArrayList();
    private ArrayList groupKeys = new ArrayList();
    private ArrayList initialItems = new ArrayList();
    private AtomicSortComparer comparer;

    public GroupByIterator(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext, Comparator comparator) throws XPathException {
        this.population = sequenceIterator;
        this.keyExpression = expression;
        this.keyContext = xPathContext;
        this.collator = comparator;
        this.comparer = new AtomicSortComparer(comparator);
        this.buildIndexedGroups();
    }

    private void buildIndexedGroups() throws XPathException {
        Item item;
        HashMap hashMap = new HashMap();
        XPathContextMinor xPathContextMinor = this.keyContext.newMinorContext();
        xPathContextMinor.setCurrentIterator(this.population);
        xPathContextMinor.setOriginatingConstructType(2062);
        while ((item = this.population.next()) != null) {
            AtomicValue atomicValue;
            SequenceIterator sequenceIterator = this.keyExpression.iterate(xPathContextMinor);
            boolean bl = true;
            while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) {
                AtomicSortComparer.ComparisonKey comparisonKey = this.comparer.getComparisonKey(atomicValue);
                ArrayList arrayList = (ArrayList)hashMap.get(comparisonKey);
                if (arrayList == null) {
                    ArrayList<Item> arrayList2 = new ArrayList<Item>();
                    arrayList2.add(item);
                    this.groups.add(arrayList2);
                    this.groupKeys.add(atomicValue);
                    this.initialItems.add(item);
                    hashMap.put(comparisonKey, arrayList2);
                } else if (bl) {
                    arrayList.add(item);
                } else if (arrayList.get(arrayList.size() - 1) != item) {
                    arrayList.add(item);
                }
                bl = false;
            }
        }
    }

    public AtomicValue getCurrentGroupingKey() {
        return (AtomicValue)this.groupKeys.get(this.position - 1);
    }

    public SequenceIterator iterateCurrentGroup() {
        return new ListIterator((ArrayList)this.groups.get(this.position - 1));
    }

    public List getCurrentGroup() {
        return (ArrayList)this.groups.get(this.position - 1);
    }

    public Item next() throws XPathException {
        if (this.position < this.groups.size()) {
            ++this.position;
            return this.current();
        }
        return null;
    }

    public Item current() {
        return (Item)((ArrayList)this.groups.get(this.position - 1)).get(0);
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        XPathContextMinor xPathContextMinor = this.keyContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2062);
        return new GroupByIterator(this.population, this.keyExpression, xPathContextMinor, this.collator);
    }
}

