/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public class XQueryFunctionLibrary
implements FunctionLibrary {
    private Configuration config;
    private HashMap functions = new HashMap(20);
    private List unboundFunctionCalls = new ArrayList(20);
    private boolean allowForwardsReferences = false;

    public XQueryFunctionLibrary(Configuration configuration, boolean bl) {
        this.config = configuration;
        this.allowForwardsReferences = bl;
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    private NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public void setAllowForwardsReferences(boolean bl) {
        this.allowForwardsReferences = bl;
    }

    public void declareFunction(XQueryFunction xQueryFunction) throws StaticError {
        int n = xQueryFunction.getFunctionFingerprint();
        int n2 = xQueryFunction.getNumberOfArguments();
        Long l = new Long((long)n2 << (int)(32L + (long)n));
        if (this.functions.get(l) != null) {
            throw new StaticError("Duplicate definition of function " + this.getNamePool().getDisplayName(n));
        }
        this.functions.put(l, xQueryFunction);
    }

    public boolean isAvailable(int n, String string, String string2, int n2) {
        if (n2 == -1) {
            int n3 = 0;
            while (n3 < 20) {
                if (this.isAvailable(n, string, string2, n3)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        Long l = new Long((long)n2 << (int)(32L + (long)n));
        return this.functions.get(l) != null;
    }

    public Expression bind(int n, String string, String string2, Expression[] expressionArray) throws XPathException {
        int n2 = this.getNamePool().allocate("", string, string2);
        Long l = new Long((long)expressionArray.length << (int)(32L + (long)n2));
        XQueryFunction xQueryFunction = (XQueryFunction)this.functions.get(l);
        if (xQueryFunction != null) {
            UserFunctionCall userFunctionCall = new UserFunctionCall();
            userFunctionCall.setFunctionNameCode(n);
            userFunctionCall.setArguments(expressionArray);
            userFunctionCall.setStaticType(xQueryFunction.getResultType());
            UserFunction userFunction = xQueryFunction.getUserFunction();
            if (userFunction == null) {
                xQueryFunction.registerReference(userFunctionCall);
            } else {
                userFunctionCall.setFunction(userFunction, xQueryFunction.getStaticContext());
            }
            return userFunctionCall;
        }
        if (this.allowForwardsReferences) {
            UserFunctionCall userFunctionCall = new UserFunctionCall();
            userFunctionCall.setFunctionNameCode(n);
            userFunctionCall.setArguments(expressionArray);
            this.unboundFunctionCalls.add(userFunctionCall);
            return userFunctionCall;
        }
        return null;
    }

    public void bindUnboundFunctionCalls() throws StaticError {
        Iterator iterator = this.unboundFunctionCalls.iterator();
        while (iterator.hasNext()) {
            UserFunctionCall userFunctionCall = (UserFunctionCall)iterator.next();
            int n = userFunctionCall.getFunctionNameCode() & 0xFFFFF;
            int n2 = userFunctionCall.getNumberOfArguments();
            Long l = new Long((long)n2 << (int)(32L + (long)n));
            XQueryFunction xQueryFunction = (XQueryFunction)this.functions.get(l);
            if (xQueryFunction != null) {
                userFunctionCall.setStaticType(xQueryFunction.getResultType());
                xQueryFunction.registerReference(userFunctionCall);
                continue;
            }
            throw new StaticError("Function " + this.getNamePool().getDisplayName(userFunctionCall.getFunctionNameCode()) + " has not been declared", ExpressionTool.getLocator(userFunctionCall));
        }
    }

    public Iterator getFunctionDefinitions() {
        return this.functions.values().iterator();
    }

    protected void fixupGlobalFunctions(StaticQueryContext staticQueryContext) throws StaticError {
        Iterator iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            XQueryFunction xQueryFunction = (XQueryFunction)iterator.next();
            xQueryFunction.compile(staticQueryContext);
        }
    }

    public void explainGlobalFunctions() throws XPathException {
        Iterator iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            XQueryFunction xQueryFunction = (XQueryFunction)iterator.next();
            xQueryFunction.explain(this.getNamePool());
        }
    }

    public UserFunction getUserDefinedFunction(String string, String string2, int n) {
        int n2 = this.getNamePool().allocate("", string, string2) & 0xFFFFF;
        Long l = new Long((long)n << (int)(32L + (long)n2));
        XQueryFunction xQueryFunction = (XQueryFunction)this.functions.get(l);
        if (xQueryFunction == null) {
            return null;
        }
        return xQueryFunction.getUserFunction();
    }
}

