/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xpath.XPathException;

public class Orphan
implements NodeInfo {
    private short kind;
    private int nameCode = -1;
    private CharSequence stringValue;
    private int typeAnnotation = -1;
    private NamePool namePool;
    private String systemId;

    public Orphan(NamePool namePool) {
        this.namePool = namePool;
    }

    public void setNodeKind(short s) {
        this.kind = s;
    }

    public void setNameCode(int n) {
        this.nameCode = n;
    }

    public void setStringValue(CharSequence charSequence) {
        this.stringValue = charSequence;
    }

    public void setTypeAnnotation(int n) {
        this.typeAnnotation = n;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public int getNodeKind() {
        return this.kind;
    }

    public SequenceIterator getTypedValue(Configuration configuration) throws XPathException {
        if (this.typeAnnotation == -1) {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(this.stringValue));
        }
        SchemaType schemaType = configuration.getSchemaType(this.typeAnnotation);
        if (schemaType == null) {
            String string = this.namePool.getDisplayName(this.typeAnnotation);
            throw new IllegalStateException("Unknown type annotation " + Err.wrap(string) + " in standalone node");
        }
        return schemaType.getTypedValue(this);
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public int getTypeAnnotation() {
        return this.typeAnnotation;
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        return this == nodeInfo;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getBaseURI() {
        return this.systemId;
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        if (this.isSameNodeInfo(nodeInfo)) {
            return 0;
        }
        return this.hashCode() < nodeInfo.hashCode() ? -1 : 1;
    }

    public String getStringValue() {
        return this.stringValue.toString();
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public int getFingerprint() {
        return this.getNameCode() & 0xFFFFF;
    }

    public String getLocalPart() {
        if (this.nameCode == -1) {
            return "";
        }
        return this.namePool.getLocalName(this.nameCode);
    }

    public String getURI() {
        if (this.nameCode == -1) {
            return "";
        }
        return this.namePool.getURI(this.nameCode);
    }

    public String getDisplayName() {
        if (this.nameCode == -1) {
            return "";
        }
        return this.namePool.getDisplayName(this.nameCode);
    }

    public NodeInfo getParent() {
        return null;
    }

    public AxisIterator iterateAxis(byte by) {
        switch (by) {
            case 1: 
            case 5: 
            case 12: {
                return SingletonIterator.makeIterator(this);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 1: 
            case 5: 
            case 12: {
                if (nodeTest.matches(this)) {
                    return SingletonIterator.makeIterator(this);
                }
                return EmptyIterator.getInstance();
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public String getAttributeValue(int n) {
        return null;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return null;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public String generateId() {
        return "Q" + this.hashCode();
    }

    public int getDocumentNumber() {
        return this.hashCode() & 0xFFFFFF;
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        Navigator.copy(this, receiver, this.namePool, n, bl, n2);
    }

    public void outputNamespaceNodes(Receiver receiver, boolean bl) {
    }
}

