/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;

public class Executable
implements Serializable {
    private transient Configuration config;
    private Mode stripperRules;
    private boolean stripsWhitespace;
    private RuleManager ruleManager;
    private KeyManager keyManager;
    private DecimalFormatManager decimalFormatManager;
    private SlotManager globalVariableMap;
    private HashMap globalVariableIndex = new HashMap(32);
    private String defaultCollationName;
    private Properties defaultOutputProperties;
    private HashMap namedTemplateTable = new HashMap(32);
    private int largestPatternStackFrame = 0;
    private HashMap collationTable = new HashMap(10);
    private HashMap characterMapIndex;
    private LocationMap locationMap;
    private HashMap queryLibraryModules;
    private FunctionLibrary functionLibrary;

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public HashMap getNamedTemplateTable() {
        if (this.namedTemplateTable == null) {
            this.namedTemplateTable = new HashMap(32);
        }
        return this.namedTemplateTable;
    }

    public Template getNamedTemplate(int n) {
        return (Template)this.namedTemplateTable.get(new Integer(n));
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public void setFunctionLibrary(FunctionLibrary functionLibrary) {
        this.functionLibrary = functionLibrary;
    }

    public void setCharacterMapIndex(HashMap hashMap) {
        this.characterMapIndex = hashMap;
    }

    public HashMap getCharacterMapIndex() {
        if (this.characterMapIndex == null) {
            this.characterMapIndex = new HashMap(10);
        }
        return this.characterMapIndex;
    }

    public void setStripperRules(Mode mode) {
        this.stripperRules = mode;
    }

    public Mode getStripperRules() {
        return this.stripperRules;
    }

    public void setStripsWhitespace(boolean bl) {
        this.stripsWhitespace = bl;
    }

    public Stripper newStripper() {
        return new Stripper(this.stripperRules);
    }

    public boolean stripsWhitespace() {
        return this.stripsWhitespace;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public KeyManager getKeyManager() {
        if (this.keyManager == null) {
            this.keyManager = new KeyManager(this.getConfiguration());
        }
        return this.keyManager;
    }

    public void setDefaultOutputProperties(Properties properties) {
        this.defaultOutputProperties = properties;
    }

    public Properties getDefaultOutputProperties() {
        if (this.defaultOutputProperties == null) {
            this.defaultOutputProperties = new Properties();
        }
        return this.defaultOutputProperties;
    }

    public void setDecimalFormatManager(DecimalFormatManager decimalFormatManager) {
        this.decimalFormatManager = decimalFormatManager;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager();
        }
        return this.decimalFormatManager;
    }

    public void setDefaultCollationName(String string) {
        this.defaultCollationName = string;
    }

    public String getDefaultCollationName() {
        if (this.defaultCollationName == null) {
            return CodepointCollator.URI;
        }
        return this.defaultCollationName;
    }

    public Comparator getDefaultCollation() {
        if (this.defaultCollationName == null) {
            return CodepointCollator.getInstance();
        }
        return this.getNamedCollation(this.defaultCollationName);
    }

    public void setCollationTable(HashMap hashMap) {
        this.collationTable = hashMap;
    }

    public HashMap getCollationTable() {
        return this.collationTable;
    }

    public Comparator getNamedCollation(String string) {
        if (this.collationTable == null) {
            this.collationTable = new HashMap(10);
        }
        return (Comparator)this.collationTable.get(string);
    }

    public void addQueryLibraryModule(StaticQueryContext staticQueryContext) {
        if (this.queryLibraryModules == null) {
            this.queryLibraryModules = new HashMap(5);
        }
        this.queryLibraryModules.put(staticQueryContext.getModuleNamespace(), staticQueryContext);
    }

    public StaticQueryContext getQueryLibraryModule(String string) {
        if (this.queryLibraryModules == null) {
            return null;
        }
        return (StaticQueryContext)this.queryLibraryModules.get(string);
    }

    public void setPatternSlotSpace(int n) {
        this.largestPatternStackFrame = n;
    }

    public SlotManager getGlobalVariableMap() {
        if (this.globalVariableMap == null) {
            this.globalVariableMap = this.config.makeSlotManager();
        }
        return this.globalVariableMap;
    }

    public HashMap getGlobalVariableIndex() {
        return this.globalVariableIndex;
    }

    public void registerGlobalVariable(GeneralVariable generalVariable) {
        this.globalVariableIndex.put(new Integer(generalVariable.getVariableFingerprint()), generalVariable);
    }

    public void initialiseBindery(Bindery bindery) {
        bindery.allocateGlobals(this.getGlobalVariableMap());
    }

    public int getLargestPatternStackFrame() {
        return this.largestPatternStackFrame;
    }

    public void setLocationMap(LocationMap locationMap) {
        this.locationMap = locationMap;
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }
}

