/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.InstructionWithChildren;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.AtomizableIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.TextFragmentValue;
import net.sf.saxon.xpath.XPathException;

public class DocumentInstr
extends InstructionWithChildren {
    private static final int[] treeSizeParameters = new int[]{50, 10, 5, 200};
    boolean textOnly = false;
    String constantText = null;
    String baseURI = null;
    private int validationAction = 3;
    private SchemaType schemaType;

    public DocumentInstr(boolean bl, String string, String string2) {
        this.textOnly = bl;
        this.constantText = string;
        this.baseURI = string2;
    }

    public void setValidationAction(int n) {
        this.validationAction = n;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    public ItemType getItemType() {
        return NodeKindTest.DOCUMENT;
    }

    public int getCardinality() {
        return 512;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Item item = this.evaluateItem(xPathContext);
        if (item != null) {
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            sequenceReceiver.append(item, this.locationId);
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        DocumentInfo documentInfo = null;
        if (this.textOnly) {
            CharSequence charSequence;
            if (this.constantText != null) {
                charSequence = this.constantText;
            } else {
                charSequence = new StringBuffer();
                Expression[] expressionArray = this.getChildren();
                int n = 0;
                while (n < expressionArray.length) {
                    Item item;
                    SequenceIterator sequenceIterator = expressionArray[n].iterate(xPathContext);
                    if (sequenceIterator instanceof AtomizableIterator) {
                        ((AtomizableIterator)sequenceIterator).setIsAtomizing(true);
                    }
                    while ((item = sequenceIterator.next()) != null) {
                        ((StringBuffer)charSequence).append(item.getStringValue());
                    }
                    ++n;
                }
            }
            documentInfo = new TextFragmentValue(charSequence, this.baseURI);
            documentInfo.setConfiguration(controller.getConfiguration());
        } else {
            XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
            xPathContextMinor.setOrigin(this);
            TinyBuilder tinyBuilder = new TinyBuilder();
            tinyBuilder.setSizeParameters(treeSizeParameters);
            tinyBuilder.setLineNumbering(controller.getConfiguration().isLineNumbering());
            TinyBuilder tinyBuilder2 = tinyBuilder;
            tinyBuilder2.setSystemId(this.baseURI);
            tinyBuilder2.setConfiguration(controller.getConfiguration());
            tinyBuilder2.open();
            tinyBuilder2.startDocument(0);
            xPathContextMinor.changeOutputDestination(null, tinyBuilder2, false, this.validationAction, this.schemaType);
            this.processChildren(xPathContextMinor);
            tinyBuilder2.endDocument();
            tinyBuilder2.close();
            documentInfo = tinyBuilder.getCurrentDocument();
        }
        return documentInfo;
    }

    public int getInstructionNameCode() {
        return 142;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "document-constructor");
        if (this.children.length == 0) {
            printStream.println(ExpressionTool.indent(n + 1) + "empty content");
        } else {
            InstructionWithChildren.displayChildren(this.children, n + 1, namePool, printStream);
        }
    }
}

