/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class Trace
extends SystemFunction {
    NamespaceResolver resolver;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.resolver = staticContext.getNamespaceResolver();
        return super.simplify(staticContext);
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public int computeSpecialProperties() {
        return this.argument[0].getSpecialProperties();
    }

    public int computeCardinality() {
        return this.argument[0].getCardinality();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.argument[0].evaluateItem(xPathContext);
        String string = this.argument[1].evaluateAsString(xPathContext);
        if (xPathContext.getController().isTracing()) {
            this.notifyListener(string, Value.asValue(item), xPathContext);
        } else {
            this.traceItem(item, string);
        }
        return item;
    }

    private void notifyListener(String string, Value value, XPathContext xPathContext) {
        InstructionDetails instructionDetails = (InstructionDetails)this.getInstructionInfo();
        instructionDetails.setConstructType(2031);
        instructionDetails.setNamespaceResolver(this.resolver);
        instructionDetails.setProperty("label", string);
        instructionDetails.setProperty("value", value);
        TraceListener traceListener = xPathContext.getController().getTraceListener();
        traceListener.enter(instructionDetails, xPathContext);
        traceListener.leave(instructionDetails);
    }

    private void traceItem(Item item, String string) throws XPathException {
        if (item == null) {
            System.err.println(string + ": empty sequence");
        } else if (item instanceof NodeInfo) {
            System.err.println(string + ": " + Type.displayTypeName(item) + ": " + Navigator.getPath((NodeInfo)item));
        } else {
            System.err.println(string + ": " + Type.displayTypeName(item) + ": " + item.getStringValue());
        }
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        if (xPathContext.getController().isTracing()) {
            String string = this.argument[1].evaluateAsString(xPathContext);
            Value value = ExpressionTool.eagerEvaluate(this.argument[0], xPathContext);
            this.notifyListener(string, value, xPathContext);
            return value.iterate(xPathContext);
        }
        return new TracingIterator(this.argument[0].iterate(xPathContext), this.argument[1].evaluateAsString(xPathContext));
    }

    public class TracingIterator
    implements SequenceIterator {
        SequenceIterator base;
        String label;
        boolean empty = true;

        public TracingIterator(SequenceIterator sequenceIterator, String string) throws XPathException {
            this.base = sequenceIterator;
            this.label = string;
        }

        public Item next() throws XPathException {
            Item item = this.base.next();
            if (item == null) {
                if (this.empty) {
                    Trace.this.traceItem(null, this.label);
                }
            } else {
                Trace.this.traceItem(item, this.label + " [" + this.position() + "]");
                this.empty = false;
            }
            return item;
        }

        public Item current() {
            return this.base.current();
        }

        public int position() {
            return this.base.position();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new TracingIterator(this.base.getAnother(), this.label);
        }
    }
}

