/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public class SystemFunctionLibrary
implements FunctionLibrary {
    private boolean allowXSLTFunctions;

    public SystemFunctionLibrary(Configuration configuration, boolean bl) {
        this.allowXSLTFunctions = bl;
    }

    public boolean isAvailable(int n, String string, String string2, int n2) {
        if (string.equals("http://www.w3.org/2004/07/xpath-functions")) {
            StandardFunction.Entry entry = StandardFunction.getFunction(string2);
            if (entry == null) {
                return false;
            }
            return n2 == -1 || n2 >= entry.minArguments && n2 <= entry.maxArguments;
        }
        return false;
    }

    public Expression bind(int n, String string, String string2, Expression[] expressionArray) throws XPathException {
        if (string.equals("http://www.w3.org/2004/07/xpath-functions")) {
            SystemFunction systemFunction;
            StandardFunction.Entry entry = StandardFunction.getFunction(string2);
            if (entry == null) {
                throw new StaticError("Unknown system function " + string2 + "()");
            }
            Class clazz = entry.implementationClass;
            try {
                systemFunction = (SystemFunction)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new AssertionError((Object)("Failed to load system function: " + exception.getMessage()));
            }
            systemFunction.setDetails(entry);
            systemFunction.setFunctionNameCode(n);
            systemFunction.setArguments(expressionArray);
            this.checkArgumentCount(expressionArray.length, entry.minArguments, entry.maxArguments, string2);
            if (systemFunction instanceof XSLTFunction && !this.allowXSLTFunctions) {
                throw new StaticError("Cannot use the " + string2 + "() function in a non-XSLT context");
            }
            return systemFunction;
        }
        return null;
    }

    private int checkArgumentCount(int n, int n2, int n3, String string) throws XPathException {
        if (n2 == n3 && n != n2) {
            throw new StaticError("Function " + string + " must have " + n2 + SystemFunctionLibrary.pluralArguments(n2));
        }
        if (n < n2) {
            throw new StaticError("Function " + string + " must have at least " + n2 + SystemFunctionLibrary.pluralArguments(n2));
        }
        if (n > n3) {
            throw new StaticError("Function " + string + " must have no more than " + n3 + SystemFunctionLibrary.pluralArguments(n3));
        }
        return n;
    }

    private static String pluralArguments(int n) {
        if (n == 1) {
            return " argument";
        }
        return " arguments";
    }
}

