/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public class Key
extends SystemFunction
implements MappingFunction,
XSLTFunction {
    private NamespaceResolver nsContext = null;
    private int keyFingerprint = -1;
    private transient boolean checked = false;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        Key key = (Key)super.simplify(staticContext);
        if (this.argument.length == 2) {
            key.addContextDocumentArgument(2, "key");
        }
        return key;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(staticContext);
        this.argument[1] = ExpressionTool.unsorted(this.argument[1], false);
        if (this.argument[0] instanceof StringValue) {
            this.keyFingerprint = ((ExpressionContext)staticContext).getFingerprint(((StringValue)this.argument[0]).getStringValue(), false);
            if (this.keyFingerprint == -1) {
                throw new StaticError("Key " + ((StringValue)this.argument[0]).getStringValue() + " is not defined");
            }
        } else {
            this.nsContext = staticContext.getNamespaceResolver();
        }
    }

    public int computeSpecialProperties() {
        int n = 131072;
        if (this.getNumberOfArguments() == 2 || (this.argument[2].getSpecialProperties() & 0x10000) != 0) {
            n |= 0x10000;
        }
        return n;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Object object;
        Controller controller = xPathContext.getController();
        Item item = this.argument[2].evaluateItem(xPathContext);
        if (!(item instanceof NodeInfo)) {
            this.dynamicError("When calling the key() function, the context item must be a node", "XT1270", xPathContext);
            return null;
        }
        NodeInfo nodeInfo = ((NodeInfo)item).getRoot();
        if (!(nodeInfo instanceof DocumentInfo)) {
            this.dynamicError("In the key() function, the node supplied in the third argument (or the context node if absent) must be in a tree whose root is a document node", "XT1270", xPathContext);
            return null;
        }
        DocumentInfo documentInfo = (DocumentInfo)nodeInfo;
        int n = this.keyFingerprint;
        if (n == -1) {
            object = this.argument[0].evaluateItem(xPathContext).getStringValue();
            try {
                n = this.nsContext.getFingerprint((String)object, false, xPathContext.getController().getNamePool());
            }
            catch (XPathException xPathException) {
                this.dynamicError("Invalid key name: " + xPathException.getMessage(), "XT1260", xPathContext);
            }
            if (n == -1) {
                this.dynamicError("Key '" + (String)object + "' has not been defined", "XT1260", xPathContext);
                return null;
            }
        }
        if (Cardinality.allowsMany((object = this.argument[1]).getCardinality())) {
            KeyContextInfo keyContextInfo = new KeyContextInfo();
            keyContextInfo.document = documentInfo;
            keyContextInfo.context = xPathContext;
            keyContextInfo.keyFingerprint = n;
            SequenceIterator sequenceIterator = this.argument[1].iterate(xPathContext);
            MappingIterator mappingIterator = new MappingIterator(sequenceIterator, this, null, keyContextInfo);
            return new DocumentOrderIterator(mappingIterator, LocalOrderComparer.getInstance());
        }
        AtomicValue atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return EmptyIterator.getInstance();
        }
        KeyManager keyManager = controller.getKeyManager();
        return keyManager.selectByKey(n, documentInfo, atomicValue, xPathContext);
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        KeyContextInfo keyContextInfo = (KeyContextInfo)object;
        KeyManager keyManager = keyContextInfo.context.getController().getKeyManager();
        return keyManager.selectByKey(keyContextInfo.keyFingerprint, keyContextInfo.document, (AtomicValue)item, keyContextInfo.context);
    }

    private static class KeyContextInfo {
        public DocumentInfo document;
        public XPathContext context;
        public int keyFingerprint;

        private KeyContextInfo() {
        }
    }
}

