/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.StandaloneContext;
import net.sf.saxon.xpath.Variable;
import net.sf.saxon.xpath.XPathException;

public class Evaluate
extends SystemFunction {
    StandaloneContext staticContext;
    InstructionDetails details;
    public static final int EVALUATE = 0;
    public static final int EXPRESSION = 1;
    public static final int EVAL = 2;

    protected SequenceType getRequiredType(int n) {
        if (n == 0) {
            return super.getRequiredType(n);
        }
        return SequenceType.ANY_SEQUENCE;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        if (this.operation != 2) {
            NamespaceResolver namespaceResolver = staticContext.getNamespaceResolver();
            this.staticContext = new StandaloneContext(staticContext.getConfiguration());
            this.staticContext.setBaseURI(staticContext.getBaseURI());
            this.staticContext.setDefaultFunctionNamespace(staticContext.getDefaultFunctionNamespace());
            Iterator iterator = namespaceResolver.iteratePrefixes();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = namespaceResolver.getURIForPrefix(string, true);
                this.staticContext.declareNamespace(string, string2);
            }
            this.details = new InstructionDetails();
            this.details.setConstructType(2051);
            this.details.setSystemId(staticContext.getLocationMap().getSystemId(this.locationId));
            this.details.setLineNumber(staticContext.getLocationMap().getLineNumber(this.locationId));
        }
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    private PreparedExpression prepareExpression(XPathContext xPathContext) throws XPathException {
        Expression expression;
        if (this.operation == 2) {
            Item item = this.argument[0].evaluateItem(xPathContext);
            if (!(item instanceof ObjectValue)) {
                this.dynamicError("First argument to saxon:eval must be an expression prepared using saxon:expression", xPathContext);
                return null;
            }
            ObjectValue objectValue = (ObjectValue)item;
            Object object = objectValue.getObject();
            if (!(object instanceof PreparedExpression)) {
                this.dynamicError("First argument to saxon:eval must be an expression prepared using saxon:expression", xPathContext);
                return null;
            }
            return (PreparedExpression)object;
        }
        this.staticContext.setFunctionLibrary(xPathContext.getController().getExecutable().getFunctionLibrary());
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        PreparedExpression preparedExpression = new PreparedExpression();
        preparedExpression.variables = new Variable[10];
        int n = 1;
        while (n < 10) {
            preparedExpression.variables[n - 1] = this.staticContext.declareVariable("p" + n, EmptySequence.getInstance());
            ++n;
        }
        try {
            expression = ExpressionTool.make(atomicValue.getStringValue(), this.staticContext, 0, 0, 1);
        }
        catch (XPathException xPathException) {
            DynamicError dynamicError = new DynamicError("Static error in XPath expression supplied to saxon:evaluate: " + xPathException.getMessage().trim());
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        ItemType itemType = Type.ITEM_TYPE;
        expression = expression.analyze(this.staticContext, itemType);
        preparedExpression.stackFrameMap = this.staticContext.getStackFrameMap();
        ExpressionTool.allocateSlots(expression, preparedExpression.stackFrameMap.getNumberOfVariables(), preparedExpression.stackFrameMap);
        preparedExpression.expression = expression;
        return preparedExpression;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        PreparedExpression preparedExpression = this.prepareExpression(xPathContext);
        if (this.operation == 1) {
            return new ObjectValue(preparedExpression);
        }
        int n = 1;
        while (n < this.argument.length) {
            preparedExpression.variables[n - 1].setXPathValue(ExpressionTool.eagerEvaluate(this.argument[n], xPathContext));
            ++n;
        }
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setOrigin(this.details);
        xPathContextMajor.openStackFrame(preparedExpression.stackFrameMap);
        xPathContextMajor.setCurrentIterator(xPathContext.getCurrentIterator());
        return preparedExpression.expression.evaluateItem(xPathContextMajor);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        PreparedExpression preparedExpression = this.prepareExpression(xPathContext);
        if (this.operation == 1) {
            return SingletonIterator.makeIterator(new ObjectValue(preparedExpression));
        }
        int n = 1;
        while (n < this.argument.length) {
            preparedExpression.variables[n - 1].setXPathValue(ExpressionTool.eagerEvaluate(this.argument[n], xPathContext));
            ++n;
        }
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setOrigin(this.details);
        xPathContextMajor.openStackFrame(preparedExpression.stackFrameMap);
        xPathContextMajor.setCurrentIterator(xPathContext.getCurrentIterator());
        return ExpressionTool.lazyEvaluate(preparedExpression.expression, xPathContextMajor).iterate(xPathContextMajor);
    }

    public int getIntrinsicDependencies() {
        return 30;
    }

    protected static class PreparedExpression {
        public Expression expression;
        public Variable[] variables;
        public SlotManager stackFrameMap;

        protected PreparedExpression() {
        }
    }
}

