/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.LocalParam;
import net.sf.saxon.instruct.RegexIterator;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class XPathContextMajor
extends XPathContextMinor {
    private StackFrame stackFrame = null;
    private ParameterSet localParameters = null;
    private ParameterSet tunnelParameters = null;
    private Mode currentMode = null;
    private Template currentTemplate = null;
    private GroupIterator currentGroupIterator = null;
    private RegexIterator currentRegexIterator = null;

    public XPathContextMajor(Controller controller) {
        this.controller = controller;
        this.stackFrame = StackFrame.EMPTY;
        this.origin = this.controller;
    }

    private XPathContextMajor() {
    }

    public XPathContextMajor(Item item, Configuration configuration) {
        this.controller = new Controller(configuration);
        this.controller.setExecutable(new Executable());
        AxisIterator axisIterator = SingletonIterator.makeIterator(item);
        axisIterator.next();
        this.currentIterator = axisIterator;
        this.origin = this.controller;
    }

    public XPathContextMajor newContext() {
        XPathContextMajor xPathContextMajor = new XPathContextMajor();
        xPathContextMajor.controller = this.controller;
        xPathContextMajor.currentIterator = this.currentIterator;
        xPathContextMajor.stackFrame = this.stackFrame;
        xPathContextMajor.localParameters = this.localParameters;
        xPathContextMajor.tunnelParameters = this.tunnelParameters;
        xPathContextMajor.last = this.last;
        xPathContextMajor.currentReceiver = this.currentReceiver;
        xPathContextMajor.isTemporaryDestination = this.isTemporaryDestination;
        xPathContextMajor.currentMode = this.currentMode;
        xPathContextMajor.currentTemplate = this.currentTemplate;
        xPathContextMajor.currentGroupIterator = this.currentGroupIterator;
        xPathContextMajor.currentRegexIterator = this.currentRegexIterator;
        xPathContextMajor.caller = this;
        return xPathContextMajor;
    }

    public static XPathContextMajor newContext(XPathContextMinor xPathContextMinor) {
        XPathContextMajor xPathContextMajor = new XPathContextMajor();
        xPathContextMajor.controller = xPathContextMinor.getController();
        xPathContextMajor.currentIterator = xPathContextMinor.getCurrentIterator();
        xPathContextMajor.stackFrame = xPathContextMinor.getStackFrame();
        xPathContextMajor.localParameters = xPathContextMinor.getLocalParameters();
        xPathContextMajor.tunnelParameters = xPathContextMinor.getTunnelParameters();
        xPathContextMajor.last = xPathContextMinor.last;
        xPathContextMajor.currentReceiver = xPathContextMinor.currentReceiver;
        xPathContextMajor.isTemporaryDestination = xPathContextMinor.isTemporaryDestination;
        xPathContextMajor.currentMode = xPathContextMinor.getCurrentMode();
        xPathContextMajor.currentTemplate = xPathContextMinor.getCurrentTemplate();
        xPathContextMajor.currentGroupIterator = xPathContextMinor.getCurrentGroupIterator();
        xPathContextMajor.currentRegexIterator = xPathContextMinor.getCurrentRegexIterator();
        xPathContextMajor.caller = xPathContextMinor;
        return xPathContextMajor;
    }

    public ParameterSet getLocalParameters() {
        return this.localParameters;
    }

    public void setLocalParameters(ParameterSet parameterSet) {
        this.localParameters = parameterSet;
    }

    public ParameterSet getTunnelParameters() {
        return this.tunnelParameters;
    }

    public void setTunnelParameters(ParameterSet parameterSet) {
        this.tunnelParameters = parameterSet;
    }

    public void setOrigin(InstructionInfoProvider instructionInfoProvider) {
        this.origin = instructionInfoProvider;
    }

    public StackFrame getStackFrame() {
        return this.stackFrame;
    }

    public void setStackFrame(SlotManager slotManager, Value[] valueArray) {
        this.stackFrame = new StackFrame(slotManager, valueArray);
        if (slotManager != null && valueArray.length != slotManager.getNumberOfVariables()) {
            this.stackFrame.slots = new Value[slotManager.getNumberOfVariables()];
            System.arraycopy(valueArray, 0, this.stackFrame.slots, 0, valueArray.length);
        }
    }

    public void openStackFrame(SlotManager slotManager) {
        this.stackFrame = new StackFrame(slotManager, new Value[slotManager.getNumberOfVariables()]);
    }

    public void openStackFrame(int n) {
        this.stackFrame = new StackFrame(null, new Value[n]);
    }

    public Value evaluateLocalVariable(int n) {
        return this.stackFrame.slots[n];
    }

    public void setLocalVariable(int n, Value value) {
        this.stackFrame.slots[n] = value;
    }

    public void setCurrentMode(Mode mode) {
        this.currentMode = mode;
    }

    public Mode getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentTemplate(Template template) {
        this.currentTemplate = template;
    }

    public Template getCurrentTemplate() {
        return this.currentTemplate;
    }

    public void setCurrentGroupIterator(GroupIterator groupIterator) {
        this.currentGroupIterator = groupIterator;
    }

    public GroupIterator getCurrentGroupIterator() {
        return this.currentGroupIterator;
    }

    public void setCurrentRegexIterator(RegexIterator regexIterator) {
        this.currentRegexIterator = regexIterator;
    }

    public RegexIterator getCurrentRegexIterator() {
        return this.currentRegexIterator;
    }

    public boolean useLocalParameter(int n, LocalParam localParam, boolean bl) throws XPathException {
        Value value;
        ParameterSet parameterSet;
        ParameterSet parameterSet2 = parameterSet = bl ? this.tunnelParameters : this.localParameters;
        if (parameterSet == null) {
            return false;
        }
        this.stackFrame.slots[localParam.getSlotNumber()] = value = parameterSet.get(n);
        return value != null;
    }
}

